/*
 * Decompiled with CFR 0.152.
 */
package orchestrator.plus;

import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import service.ComposedState;
import service.SimpleState;
import service.SimpleTransition;
import service.Transition;
import service.TransitionSystem;

public class TransitionResultEntry
implements Comparable<TransitionResultEntry> {
    private SimpleState targetState;
    private ComposedState composedState;
    private String action;
    private Vector<TransitionSystem<SimpleState, SimpleTransition>> ts;

    public TransitionResultEntry(SimpleState targetState, ComposedState composedState, Transition action) {
        this.targetState = targetState;
        this.composedState = composedState;
        this.action = action.getName();
        this.ts = new Vector();
    }

    public TransitionResultEntry(SimpleState targetState, ComposedState composedState, Transition action, TransitionSystem<SimpleState, SimpleTransition> ts) {
        this.targetState = targetState;
        this.composedState = composedState;
        this.action = action.getName();
        this.ts = new Vector();
        this.ts.add(ts);
    }

    public TransitionResultEntry(SimpleState targetState, ComposedState composedState, Transition action, Set<TransitionSystem<SimpleState, SimpleTransition>> ts) {
        this.targetState = targetState;
        this.composedState = composedState;
        this.action = action.getName();
        this.ts = new Vector();
        this.ts.addAll(ts);
    }

    public void addTransitionSystemInTransition(TransitionSystem<SimpleState, SimpleTransition> ts) {
        Iterator<TransitionSystem<SimpleState, SimpleTransition>> itTS = this.ts.iterator();
        while (itTS.hasNext()) {
            if (!itTS.next().getName().equals(ts.getName())) continue;
            return;
        }
        this.ts.add(ts);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.action == null ? 0 : this.action.hashCode());
        result = 31 * result + (this.composedState == null ? 0 : this.composedState.hashCode());
        result = 31 * result + (this.targetState == null ? 0 : this.targetState.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TransitionResultEntry other = (TransitionResultEntry)obj;
        if (this.action == null ? other.action != null : !this.action.equals(other.action)) {
            return false;
        }
        if (this.composedState == null ? other.composedState != null : !this.composedState.equals(other.composedState)) {
            return false;
        }
        return !(this.targetState == null ? other.targetState != null : !this.targetState.equals(other.targetState));
    }

    public String[] toStringArray() {
        String[] result = new String[]{this.targetState.getName(), "", this.action, ""};
        int i = 0;
        while (i < this.composedState.getStates().length) {
            try {
                if (i > 0) {
                    result[1] = String.valueOf(result[1]) + ",";
                }
                result[1] = String.valueOf(result[1]) + this.composedState.getServicesState(i).getName();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        i = 0;
        while (i < this.ts.size()) {
            if (i > 0) {
                result[3] = String.valueOf(result[3]) + ",";
            }
            result[3] = String.valueOf(result[3]) + this.ts.elementAt(i).getName();
            ++i;
        }
        return result;
    }

    @Override
    public int compareTo(TransitionResultEntry t) {
        int targetName = this.targetState.getName().compareTo(t.targetState.getName());
        if (targetName != 0) {
            return targetName;
        }
        int composedStateName = this.composedState.getName().compareTo(t.composedState.getName());
        if (composedStateName != 0) {
            return composedStateName;
        }
        int actionName = this.action.compareTo(t.action);
        if (actionName != 0) {
            return actionName;
        }
        return 0;
    }
}

