/*
 * Decompiled with CFR 0.152.
 */
package orchestrator.plus;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import orchestrator.Orchestrator;
import orchestrator.plus.TransitionResultEntry;
import service.ComposedState;
import service.ComposedTransition;
import service.ServiceFactory;
import service.SimpleState;
import service.SimpleTransition;
import service.State;
import service.TransitionSystem;
import simulator.Simulation;
import simulator.SimulationFactoryImpl;
import simulator.plus.SimilarState;
import simulator.plus.SimulationPlusImpl;

public class OrchestratorPlusImpl
extends Orchestrator {
    SimulationPlusImpl sym;
    SimpleState currentTargetState;
    ComposedState currentServicesState;
    ComposedTransition lastExecutedAction = null;
    TransitionSystem<SimpleState, SimpleTransition> target;
    TransitionSystem<SimpleState, SimpleTransition>[] availableServices;
    Vector<TransitionResultEntry> transition;
    TransitionSystem<SimpleState, SimpleTransition>[] available;

    public OrchestratorPlusImpl(TransitionSystem<SimpleState, SimpleTransition> target, TransitionSystem<SimpleState, SimpleTransition>[] availableServices, ServiceFactory serviceFactory) throws Exception {
        super(target, availableServices);
        this.sym = new SimulationFactoryImpl().createSimulationPlus(target, availableServices, serviceFactory);
        this.available = availableServices;
        this.currentTargetState = target.getInitial();
        this.target = target;
        this.availableServices = availableServices;
        this.currentServicesState = this.sym.getCompositionTs().getInitial();
        this.transition = this.createTransitions();
    }

    private Vector<TransitionResultEntry> createTransitions() throws Exception {
        Vector<TransitionResultEntry> result = new Vector<TransitionResultEntry>();
        TransitionSystem<ComposedState, ComposedTransition> compositionTS = this.getCompositionTs();
        Set<SimilarState> setSimilarState = this.sym.getAllSimilarState1();
        for (SimilarState currentSimulationCouple : setSimilarState) {
            for (SimpleTransition simpleAction : this.target.getActionsOf(currentSimulationCouple.getTargetState())) {
                Iterator<ComposedTransition> itComposedAction = compositionTS.getActionsOfStateWithName(currentSimulationCouple.getAvalableServiceState(), simpleAction.getName()).iterator();
                TransitionResultEntry newTransition = new TransitionResultEntry(currentSimulationCouple.getTargetState(), currentSimulationCouple.getAvalableServiceState(), simpleAction);
                while (itComposedAction.hasNext()) {
                    ComposedTransition currentComposedAction = itComposedAction.next();
                    newTransition.addTransitionSystemInTransition(currentComposedAction.getService());
                }
                result.add(newTransition);
            }
        }
        Collections.sort(result);
        return result;
    }

    @Override
    public void doAction(SimpleTransition action) throws Exception {
        Set<SimpleTransition> actions = this.sym.getTargetTs().getActionsOf(this.currentTargetState);
        if (!actions.contains(action)) {
            throw new Exception("Selected action is not available");
        }
        Iterator<ComposedTransition> it = this.sym.getCompositionTs().getActionsOf(this.currentServicesState).iterator();
        ComposedTransition current = null;
        while (it.hasNext()) {
            current = it.next();
            if (!current.actionSimulates(action)) continue;
            this.currentServicesState = current.getStateTo();
            this.currentTargetState = (SimpleState)action.getStateTo();
            this.lastExecutedAction = current;
        }
    }

    @Override
    public Vector<String[]> getSimulationDataToExport() {
        Set<SimilarState> similarStates = this.sym.getAllSimilarState1();
        Vector<SimilarState> resultSimilarState = new Vector<SimilarState>(similarStates.size());
        Iterator<SimilarState> itSimilarStates = similarStates.iterator();
        while (itSimilarStates.hasNext()) {
            resultSimilarState.add(itSimilarStates.next());
        }
        Collections.sort(resultSimilarState);
        Vector<String[]> result = new Vector<String[]>(similarStates.size());
        int i = 0;
        while (i < resultSimilarState.size()) {
            result.add(((SimilarState)resultSimilarState.elementAt(i)).toStringArray());
            ++i;
        }
        return result;
    }

    @Override
    public Vector<String[]> getCompositionDataToExport() {
        Vector<String[]> result = new Vector<String[]>();
        Iterator<TransitionResultEntry> itTransition = this.transition.iterator();
        while (itTransition.hasNext()) {
            result.add(itTransition.next().toStringArray());
        }
        return result;
    }

    @Override
    public SimpleState getCurrentTargetState() {
        return this.currentTargetState;
    }

    @Override
    public ComposedState getCurrentServicesState() {
        return this.currentServicesState;
    }

    @Override
    public ComposedTransition getLastExecutedAction() {
        return this.lastExecutedAction;
    }

    @Override
    public TransitionSystem<ComposedState, ComposedTransition> getCompositionTs() {
        return this.sym.getCompositionTs();
    }

    public Simulation getSimulation() {
        return this.sym;
    }

    public Vector<TransitionResultEntry> getTransition() {
        return this.transition;
    }

    @Override
    public TransitionSystem<ComposedState, ComposedTransition> getAsyncProduct() {
        return this.sym.getAsyncProduct();
    }

    @Override
    public Set<State[]> getAllSimilarState() {
        return this.sym.getAllSimilarState();
    }
}

