/*
 * Decompiled with CFR 0.152.
 */
package orchestrator;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.Vector;
import orchestrator.Orchestrator;
import service.ComposedState;
import service.ComposedTransition;
import service.SimpleState;
import service.SimpleTransition;
import service.State;
import service.TransitionSystem;
import simulator.Simulation;
import simulator.SimulationFactoryImpl;

public class OrchestratorStandardImpl
extends Orchestrator {
    Simulation sym;
    SimpleState currentTargetState;
    ComposedState currentServicesState;
    ComposedTransition lastExecutedAction = null;
    TransitionSystem<SimpleState, SimpleTransition>[] available;

    public OrchestratorStandardImpl(TransitionSystem<SimpleState, SimpleTransition> target, TransitionSystem<SimpleState, SimpleTransition>[] availableServices) throws Exception {
        super(target, availableServices);
        this.available = availableServices;
        this.sym = new SimulationFactoryImpl().createSimulationStandard(target, availableServices);
        this.currentTargetState = target.getInitial();
        this.currentServicesState = this.sym.getCompositionTs().getInitial();
    }

    @Override
    public void doAction(SimpleTransition action) throws Exception {
        Set<SimpleTransition> actions = this.sym.getTargetTs().getActionsOf(this.currentTargetState);
        if (!actions.contains(action)) {
            throw new Exception("Selected action is not available");
        }
        Iterator<ComposedTransition> it = this.sym.getCompositionTs().getActionsOf(this.currentServicesState).iterator();
        ComposedTransition current = null;
        while (it.hasNext()) {
            current = it.next();
            if (!current.actionSimulates(action) || !this.sym.getSimilarStates(action.getStateTo()).contains(current.getStateTo())) continue;
            this.currentServicesState = current.getStateTo();
            this.currentTargetState = (SimpleState)action.getStateTo();
            this.lastExecutedAction = current;
            break;
        }
    }

    @Override
    public SimpleState getCurrentTargetState() {
        return this.currentTargetState;
    }

    @Override
    public ComposedState getCurrentServicesState() {
        return this.currentServicesState;
    }

    @Override
    public ComposedTransition getLastExecutedAction() {
        return this.lastExecutedAction;
    }

    @Override
    public TransitionSystem<ComposedState, ComposedTransition> getCompositionTs() {
        return this.sym.getCompositionTs();
    }

    @Override
    public Set<State[]> getAllSimilarState() {
        return this.sym.getAllSimilarState();
    }

    @Override
    public Vector<String[]> getSimulationDataToExport() {
        Iterator<Object> it = this.sym.getAllSimilarState().iterator();
        LinkedList<State[]> sorter = new LinkedList<State[]>();
        while (it.hasNext()) {
            sorter.add(it.next());
        }
        Collections.sort(sorter, new SimulationTuplesComparator());
        it = sorter.iterator();
        Vector<String[]> result = new Vector<String[]>();
        State[] current = null;
        while (it.hasNext()) {
            current = (State[])it.next();
            result.add(new String[]{current[0].getName(), current[1].getName()});
        }
        return result;
    }

    @Override
    public Vector<String[]> getCompositionDataToExport() {
        Vector<String[]> result = new Vector<String[]>();
        Iterator<SimpleState> itOverTSstates = this.sym.getTargetTs().getAllStates().iterator();
        LinkedList<String[]> sorter = new LinkedList<String[]>();
        LinkedList<String> serviceList = new LinkedList<String>();
        SimpleState currentTS = null;
        ComposedState currentComposedState2 = null;
        SimpleTransition currentAction2 = null;
        ComposedTransition currentComposedAction2 = null;
        try {
            while (itOverTSstates.hasNext()) {
                currentTS = itOverTSstates.next();
                String firstArg = currentTS.getName();
                for (ComposedState currentComposedState2 : this.sym.getSimilarStates(currentTS)) {
                    String secondArg = "";
                    State[] states = currentComposedState2.getStates();
                    int i = 0;
                    while (i < states.length) {
                        if (i > 0) {
                            secondArg = String.valueOf(secondArg) + ",";
                        }
                        secondArg = String.valueOf(secondArg) + states[i].getName();
                        ++i;
                    }
                    for (SimpleTransition currentAction2 : this.sym.getTargetTs().getActionsOf(currentTS)) {
                        String thirdArg = currentAction2.getName();
                        String fourthArg = "";
                        serviceList = new LinkedList();
                        LinkedList<String> serviceListToRemove = new LinkedList<String>();
                        boolean firstAdd = true;
                        for (ComposedTransition currentComposedAction2 : this.sym.getCompositionTs().getActionsOf(currentComposedState2)) {
                            int index = this.getServiceIndex(currentComposedAction2.getService());
                            if (currentAction2.actionSimulates(currentComposedAction2) && this.sym.getSimilarStates(currentAction2.getStateTo()).contains(currentComposedAction2.getStateTo())) {
                                if (serviceList.contains(this.available[index].getName())) continue;
                                serviceList.add(this.available[index].getName());
                                continue;
                            }
                            if (!currentAction2.actionSimulates(currentComposedAction2)) continue;
                            serviceListToRemove.add(this.available[index].getName());
                        }
                        serviceList.removeAll(serviceListToRemove);
                        Collections.sort(serviceList);
                        Iterator itOverStrings = serviceList.iterator();
                        while (itOverStrings.hasNext()) {
                            if (!firstAdd) {
                                fourthArg = String.valueOf(fourthArg) + ",";
                            } else {
                                firstAdd = false;
                            }
                            fourthArg = String.valueOf(fourthArg) + (String)itOverStrings.next();
                        }
                        sorter.add(new String[]{firstArg, secondArg, thirdArg, fourthArg});
                    }
                }
            }
            Collections.sort(sorter, new CompositionComparator());
            Iterator it = sorter.iterator();
            while (it.hasNext()) {
                result.add((String[])it.next());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private int getServiceIndex(TransitionSystem<SimpleState, SimpleTransition> service) {
        int i = 0;
        while (i < this.available.length) {
            if (this.available[i] == service) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public TransitionSystem<ComposedState, ComposedTransition> getAsyncProduct() {
        return this.sym.getAsyncProduct();
    }

    private class CompositionComparator
    implements Comparator<String[]> {
        private CompositionComparator() {
        }

        @Override
        public int compare(String[] arg0, String[] arg1) {
            if (arg0[0].compareTo(arg1[0]) < 0) {
                return -1;
            }
            if (arg0[0].compareTo(arg1[0]) == 0) {
                if (arg0[1].compareTo(arg1[1]) < 0) {
                    return -1;
                }
                if (arg0[1].compareTo(arg1[1]) == 0) {
                    if (arg0[2].compareTo(arg1[2]) < 0) {
                        return -1;
                    }
                    if (arg0[2].compareTo(arg1[2]) == 0) {
                        return arg0[3].compareTo(arg1[3]);
                    }
                    return 1;
                }
                return 1;
            }
            return 1;
        }
    }

    private class SimulationTuplesComparator
    implements Comparator<State[]> {
        private SimulationTuplesComparator() {
        }

        @Override
        public int compare(State[] o1, State[] o2) {
            if (o1[0].getName().compareTo(o2[0].getName()) < 0) {
                return -1;
            }
            if (o1[0].getName().compareTo(o2[0].getName()) == 0) {
                return o1[1].getName().compareTo(o2[1].getName());
            }
            return 1;
        }
    }
}

