/*
 * Decompiled with CFR 0.152.
 */
package gui.menus.view;

import gui.GenericLoader;
import gui.GraphViewerPanel;
import gui.MainFrame;
import gui.jtransitionsystem.JTransitionSystemSimple;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class TargetViewItem
extends JMenuItem {
    static final long serialVersionUID = 1L;

    public TargetViewItem() {
        this.initialize();
    }

    private void initialize() {
        this.setText("Show Target");
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TargetViewItem.this.showTarget();
            }
        });
    }

    public void showTarget() {
        if (GenericLoader.getTargetService() == null) {
            JOptionPane.showMessageDialog(null, "Target Transition System not selected");
            return;
        }
        if (GenericLoader.getTargetService().getAllStates().size() >= 20) {
            int optionSelected = JOptionPane.showConfirmDialog(null, "The Target Graph size is " + GenericLoader.getTargetService().getAllStates().size() + " nodes\n" + GenericLoader.getTargetService().getAllActions().size() + " edges\nVisualization could be very slow.\nAre you sure you want to visualize it anyway?", "Warning", 0, 2);
            if (optionSelected == 0) {
                JTransitionSystemSimple jt = GenericLoader.getJTargetService();
                GraphViewerPanel graphPanel = MainFrame.getInstance().getGraphViewerPanel();
                graphPanel.printGraph(jt.getVisualizationViewer());
                graphPanel.setGraphName(GenericLoader.getTargetServiceName());
            }
        } else {
            JTransitionSystemSimple jt = GenericLoader.getJTargetService();
            GraphViewerPanel graphPanel = MainFrame.getInstance().getGraphViewerPanel();
            graphPanel.printGraph(jt.getVisualizationViewer());
            graphPanel.setGraphName(GenericLoader.getTargetServiceName());
        }
    }
}

