/*
 * Decompiled with CFR 0.152.
 */
package gui.menus.view;

import gui.GenericLoader;
import gui.GraphViewerPanel;
import gui.MainFrame;
import gui.jtransitionsystem.JTransitionSystemComposed;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import service.ComposedState;
import service.ComposedTransition;
import service.TransitionSystem;

public class CompViewItem
extends JMenuItem {
    static final long serialVersionUID = 1L;

    public CompViewItem() {
        this.initialize();
    }

    private void initialize() {
        this.setText("Show Composition");
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!GenericLoader.orchestratorIsStarted()) {
                    JOptionPane.showMessageDialog(MainFrame.getInstance(), "Orchestrator not started", "Warning", 2);
                    return;
                }
                try {
                    if (GenericLoader.getCompositionTs().getAllStates().size() >= 20) {
                        int optionSelected = JOptionPane.showConfirmDialog(null, "The Composition Graph size is " + GenericLoader.getCompositionTs().getAllStates().size() + " nodes\n" + GenericLoader.getCompositionTs().getAllActions().size() + " edges\nVisualization could be very slow.\nAre you sure you want to visualize it anyway?", "Warning", 0, 2);
                        if (optionSelected == 0) {
                            TransitionSystem<ComposedState, ComposedTransition> composition = GenericLoader.getCompositionTs();
                            JTransitionSystemComposed jComposition = new JTransitionSystemComposed(composition);
                            GraphViewerPanel graphPanel = MainFrame.getInstance().getGraphViewerPanel();
                            graphPanel.printGraph(jComposition.getVisualizationViewer());
                            graphPanel.setGraphName("Composition");
                        }
                    } else {
                        TransitionSystem<ComposedState, ComposedTransition> composition = GenericLoader.getCompositionTs();
                        JTransitionSystemComposed jComposition = new JTransitionSystemComposed(composition);
                        GraphViewerPanel graphPanel = MainFrame.getInstance().getGraphViewerPanel();
                        graphPanel.printGraph(jComposition.getVisualizationViewer());
                        graphPanel.setGraphName("Composition");
                    }
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(null, "Error: " + ex.getMessage(), "Error", 0);
                }
            }
        });
    }
}

