/*
 * Decompiled with CFR 0.152.
 */
package gui.menus.view;

import gui.GenericLoader;
import gui.GraphViewerPanel;
import gui.MainFrame;
import gui.jtransitionsystem.JTransitionSystemComposed;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import service.ComposedState;
import service.ComposedTransition;
import service.TransitionSystem;

public class CartProdItem
extends JMenuItem {
    private static final long serialVersionUID = 1L;

    public CartProdItem() {
        this.init();
    }

    void init() {
        this.setText("View Cartesian Product");
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!GenericLoader.orchestratorIsStarted()) {
                    JOptionPane.showMessageDialog(MainFrame.getInstance(), "Orchestrator not started", "Warning", 2);
                    return;
                }
                try {
                    if (GenericLoader.getAsyncProduct().getAllStates().size() >= 20) {
                        int optionSelected = JOptionPane.showConfirmDialog(null, "Warning! You have selected to show the Cartesian Product of the entire Simulation.\n It has size:\n" + GenericLoader.getAsyncProduct().getAllStates().size() + " nodes\n" + GenericLoader.getAsyncProduct().getAllActions().size() + " edges\nVisualization could be very slow.\n Are you sure you want to visualize it anyway?", "Warning", 0, 2);
                        if (optionSelected == 0) {
                            TransitionSystem<ComposedState, ComposedTransition> asyncProduct = GenericLoader.getAsyncProduct();
                            JTransitionSystemComposed jAsyncProduct = new JTransitionSystemComposed(asyncProduct);
                            GraphViewerPanel graphPanel = MainFrame.getInstance().getGraphViewerPanel();
                            graphPanel.printGraph(jAsyncProduct.getVisualizationViewer());
                            graphPanel.setGraphName("Cartesian Product");
                        } else {
                            JOptionPane.showMessageDialog(MainFrame.getInstance(), "You are a very wise person ;)");
                        }
                    } else {
                        TransitionSystem<ComposedState, ComposedTransition> asyncProduct = GenericLoader.getAsyncProduct();
                        JTransitionSystemComposed jAsyncProduct = new JTransitionSystemComposed(asyncProduct);
                        GraphViewerPanel graphPanel = MainFrame.getInstance().getGraphViewerPanel();
                        graphPanel.printGraph(jAsyncProduct.getVisualizationViewer());
                        graphPanel.setGraphName("Cartesian Product");
                    }
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(null, "Error: " + ex.getMessage(), "Error", 0);
                }
            }
        });
    }
}

