/*
 * Decompiled with CFR 0.152.
 */
package gui.menus.file.export;

import gui.GenericLoader;
import gui.MainFrame;
import gui.XML.saveToXML;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;

public class SaveSimulatorsItem
extends JMenuItem {
    static final long serialVersionUID = 1L;
    final JFileChooser fc;

    public SaveSimulatorsItem() {
        String[] extensions = new String[]{"xml"};
        FileNameExtensionFilter filter = new FileNameExtensionFilter(".xml", extensions);
        this.fc = new JFileChooser();
        this.fc.setFileFilter(filter);
        this.init();
    }

    void init() {
        this.setText("Simulation Informations as xml...");
        this.setToolTipText("Saves information about which Composition State simulates a particular Target System State");
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SaveSimulatorsItem.this.fc.setSelectedFile(new File("simulation"));
                int action = SaveSimulatorsItem.this.fc.showSaveDialog(MainFrame.getInstance());
                if (action == 0) {
                    String fileName = SaveSimulatorsItem.this.fc.getSelectedFile().getPath();
                    File toSave = new File(String.valueOf(SaveSimulatorsItem.this.fc.getSelectedFile().getPath()) + ".xml");
                    boolean writeFile = true;
                    boolean wantsStylesheet = false;
                    if (toSave.exists()) {
                        if (JOptionPane.showConfirmDialog(null, "A file with the specified name already exists.\nDo you want to replace it?", "Specified file already exists", 0, 2) != 0) {
                            writeFile = false;
                        } else {
                            toSave.delete();
                        }
                    }
                    try {
                        if (writeFile) {
                            if (JOptionPane.showConfirmDialog(null, "Would you like to export the default stylesheet\nfor this file?", "Question", 0, 3) == 0) {
                                wantsStylesheet = true;
                            }
                            saveToXML.saveSimulationXML(GenericLoader.getSimulationDataToExport(), fileName, wantsStylesheet);
                            JOptionPane.showMessageDialog(MainFrame.getInstance(), "File saved correctly", "Message", 1);
                        }
                    }
                    catch (IOException ex) {
                        JOptionPane.showMessageDialog(null, ex.getMessage(), "Error", 0);
                    }
                    catch (Exception exc) {
                        JOptionPane.showMessageDialog(null, exc.getMessage(), "Error", 0);
                    }
                }
            }
        });
    }
}

