/*
 * Decompiled with CFR 0.152.
 */
package gui.menus.file;

import gui.GenericLoader;
import gui.MainFrame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.table.DefaultTableModel;
import service.ServiceFactoryImpl;
import service.SimpleState;
import service.SimpleTransition;
import service.TransitionSystem;

public class RefreshSimulItem
extends JMenuItem {
    static final long serialVersionUID = 1L;

    public RefreshSimulItem() {
        this.initialize();
    }

    private void initialize() {
        this.setText("Refresh Services");
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GenericLoader.orchestratorIsStarted()) {
                    JOptionPane.showMessageDialog(null, "Stop the simulation before refresh the services", "Error", 0);
                    return;
                }
                ServiceFactoryImpl sf = new ServiceFactoryImpl();
                Vector<TransitionSystem<SimpleState, SimpleTransition>> tss = new Vector<TransitionSystem<SimpleState, SimpleTransition>>(0, 1);
                Vector<String> tssNames = new Vector<String>(0, 1);
                DefaultTableModel availableTableModel = (DefaultTableModel)MainFrame.getInstance().getAvServPanel().getAvailableServiceList().getModel();
                if (GenericLoader.getPathAvailableService().size() > 0) {
                    int i = 0;
                    while (i < GenericLoader.getPathAvailableService().size()) {
                        try {
                            TransitionSystem<SimpleState, SimpleTransition> ts = sf.createSimpleTransitionSystem(GenericLoader.getPathAvailableService().elementAt(i));
                            tss.addElement(ts);
                            tssNames.addElement(ts.getName());
                            availableTableModel.setValueAt(ts.getName(), i, 0);
                        }
                        catch (Exception exception) {
                            JOptionPane.showMessageDialog(null, String.valueOf(GenericLoader.getPathAvailableService().elementAt(i)) + "not loaded: " + exception.getMessage(), "Error", 0);
                            exception.printStackTrace();
                        }
                        ++i;
                    }
                    GenericLoader.setAvailableServices(tss);
                    GenericLoader.setAvailableServicesNames(tssNames);
                }
                if (GenericLoader.getTargetService() != null) {
                    try {
                        TransitionSystem<SimpleState, SimpleTransition> target = sf.createSimpleTransitionSystem(GenericLoader.getPathTarget());
                        GenericLoader.setTargetService(target);
                        GenericLoader.setTargetServiceName(target.getName());
                        DefaultTableModel targetTableModel = (DefaultTableModel)MainFrame.getInstance().getAvServPanel().getTargetServiceList().getModel();
                        targetTableModel.setValueAt(target.getName(), 0, 0);
                    }
                    catch (Exception exception) {
                        JOptionPane.showMessageDialog(null, String.valueOf(GenericLoader.getPathTarget()) + "not loaded: " + exception.getMessage(), "Error", 0);
                        System.out.println(exception.getMessage());
                    }
                }
            }
        });
    }
}

