/*
 * Decompiled with CFR 0.152.
 */
package gui.menus.edit;

import gui.GenericLoader;
import gui.MainFrame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import service.ServiceFactoryImpl;
import service.SimpleState;
import service.SimpleTransition;
import service.TransitionSystem;

public class setTargetServItem
extends JMenuItem {
    static final long serialVersionUID = 1L;

    public setTargetServItem() {
        this.initialize();
    }

    private void initialize() {
        this.setText("Set Target System...");
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileInputStream in;
                if (GenericLoader.orchestratorIsStarted()) {
                    JOptionPane.showMessageDialog(MainFrame.getInstance(), "You have to stop the orchestrator, first", "Action not allowed", 2);
                    return;
                }
                JFileChooser jfc = new JFileChooser();
                try {
                    Properties applicationProps = new Properties();
                    in = new FileInputStream("symphony.conf");
                    applicationProps.load(in);
                    jfc = new JFileChooser(applicationProps.getProperty("targetDirectory"));
                    in.close();
                }
                catch (Exception applicationProps) {
                    // empty catch block
                }
                int returnVal = jfc.showDialog(MainFrame.getInstance(), "Set as Target Service");
                if (returnVal == 0) {
                    try {
                        File file = jfc.getSelectedFile();
                        try {
                            Properties applicationProps = new Properties();
                            in = new FileInputStream("symphony.conf");
                            applicationProps.load(in);
                            in.close();
                            applicationProps.setProperty("targetDirectory", file.getParent());
                            try {
                                FileOutputStream out = new FileOutputStream("symphony.conf");
                                applicationProps.store(out, "");
                                out.close();
                            }
                            catch (FileNotFoundException e1) {
                                e1.printStackTrace();
                            }
                            catch (IOException e2) {
                                e2.printStackTrace();
                            }
                        }
                        catch (Exception applicationProps) {
                            // empty catch block
                        }
                        ServiceFactoryImpl servFact = new ServiceFactoryImpl();
                        TransitionSystem<SimpleState, SimpleTransition> target = servFact.createSimpleTransitionSystem(file.getCanonicalPath());
                        GenericLoader.setTargetService(target);
                        GenericLoader.setTargetServiceName(file.getName());
                        GenericLoader.setTargetServicePath(file.getAbsolutePath());
                        MainFrame.getInstance().showTarget();
                        JTable serviceList = MainFrame.getInstance().getAvServPanel().getTargetServiceList();
                        Object[][] data = new String[1][3];
                        data[0][0] = target.getName();
                        data[0][1] = "none";
                        data[0][2] = file.getName();
                        DefaultTableModel tableModel = new DefaultTableModel(data, new String[]{"TS name", "State", "Filename"});
                        serviceList.setModel(tableModel);
                        serviceList.getColumnModel().getColumn(0).setPreferredWidth(150);
                        serviceList.getColumnModel().getColumn(1).setPreferredWidth(150);
                        serviceList.getColumnModel().getColumn(2).setPreferredWidth(150);
                        JOptionPane.showMessageDialog(MainFrame.getInstance(), "Target Transition System loaded");
                        MainFrame.getInstance().getAvServPanel().getActionButton1().setEnabled(true);
                    }
                    catch (Exception exc) {
                        JOptionPane.showMessageDialog(null, "Target system not loaded\nError: " + exc.getMessage(), "Error", 0);
                    }
                }
            }
        });
    }
}

