/*
 * Decompiled with CFR 0.152.
 */
package gui.menus.edit;

import gui.GenericLoader;
import gui.MainFrame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import service.ServiceFactoryImpl;
import service.SimpleState;
import service.SimpleTransition;
import service.TransitionSystem;

public class AvailableServiceAdder
extends JMenuItem {
    static final long serialVersionUID = 1L;

    public AvailableServiceAdder() {
        this.initialize();
    }

    private void initialize() {
        this.setText("Set Available Services...");
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileInputStream in;
                if (GenericLoader.orchestratorIsStarted()) {
                    JOptionPane.showMessageDialog(MainFrame.getInstance(), "Must stop the orchestrator to add new available services", "Action not allowed", 2);
                    return;
                }
                JFileChooser jfc = new JFileChooser();
                try {
                    Properties applicationProps = new Properties();
                    in = new FileInputStream("symphony.conf");
                    applicationProps.load(in);
                    jfc = new JFileChooser(applicationProps.getProperty("availableDirectory"));
                    System.out.println(applicationProps);
                    in.close();
                }
                catch (Exception applicationProps) {
                    // empty catch block
                }
                jfc.setFileSelectionMode(0);
                jfc.setMultiSelectionEnabled(true);
                int returnVal = jfc.showDialog(MainFrame.getInstance(), "Add Available Services");
                if (returnVal == 0) {
                    File[] files = jfc.getSelectedFiles();
                    if (files.length > 0) {
                        File firstFile = files[0];
                        String pathTargetDirectory = firstFile.getParent();
                        try {
                            Properties applicationProps = new Properties();
                            in = new FileInputStream("symphony.conf");
                            applicationProps.load(in);
                            in.close();
                            applicationProps.setProperty("availableDirectory", pathTargetDirectory);
                            try {
                                FileOutputStream out = new FileOutputStream("symphony.conf");
                                applicationProps.store(out, "");
                                out.close();
                            }
                            catch (FileNotFoundException e1) {
                                e1.printStackTrace();
                            }
                            catch (IOException e2) {
                                e2.printStackTrace();
                            }
                        }
                        catch (Exception applicationProps) {
                            // empty catch block
                        }
                    }
                    ServiceFactoryImpl sf = new ServiceFactoryImpl();
                    Vector<TransitionSystem<SimpleState, SimpleTransition>> tss = new Vector<TransitionSystem<SimpleState, SimpleTransition>>(0, 1);
                    Vector<String> tssNames = new Vector<String>(0, 1);
                    Vector<String> pathAvailableServices = new Vector<String>();
                    int i = 0;
                    while (i < files.length) {
                        try {
                            if (files[i].isDirectory()) {
                                JOptionPane.showMessageDialog(null, "File: << " + files[i].getName() + " >> is a directory. It will not be used to generate available services", "Info", 1);
                            } else {
                                tss.addElement(sf.createSimpleTransitionSystem(files[i].getAbsolutePath()));
                                tssNames.addElement(files[i].getName());
                                pathAvailableServices.addElement(files[i].getAbsolutePath());
                            }
                        }
                        catch (Exception exception) {
                            JOptionPane.showMessageDialog(null, String.valueOf(files[i].getName()) + "not loaded: " + exception.getMessage(), "Error", 0);
                            System.out.println(exception.getMessage());
                        }
                        ++i;
                    }
                    GenericLoader.addAvailableServices(tss);
                    GenericLoader.addAvailableServicesNames(tssNames);
                    GenericLoader.setAvailableServicesPath(pathAvailableServices);
                    JTable serviceList = MainFrame.getInstance().getAvServPanel().getAvailableServiceList();
                    Object[][] data = new String[GenericLoader.getAvailableServicesNames().size()][3];
                    Vector<String> availableServicesNames = GenericLoader.getAvailableServicesNames();
                    Vector<TransitionSystem<SimpleState, SimpleTransition>> availableServices = GenericLoader.getAvailableServices();
                    int i2 = 0;
                    while (i2 < data.length) {
                        data[i2][0] = availableServices.elementAt(i2).getName();
                        data[i2][1] = "none";
                        data[i2][2] = availableServicesNames.elementAt(i2);
                        ++i2;
                    }
                    DefaultTableModel tableModel = new DefaultTableModel(data, new String[]{"TS name", "State", "Filename"});
                    serviceList.setModel(tableModel);
                    serviceList.getColumnModel().getColumn(0).setPreferredWidth(150);
                    serviceList.getColumnModel().getColumn(1).setPreferredWidth(150);
                    serviceList.getColumnModel().getColumn(2).setPreferredWidth(150);
                    JOptionPane.showMessageDialog(MainFrame.getInstance(), String.valueOf(tss.size()) + " transition system loaded");
                    MainFrame.getInstance().getAvServPanel().getActionButton().setEnabled(true);
                    MainFrame.getInstance().getAvServPanel().getRemoveAvailableServiceButton().setEnabled(true);
                }
            }
        });
    }
}

