/*
 * Decompiled with CFR 0.152.
 */
package gui.jtransitionsystem;

import edu.uci.ics.jung.algorithms.layout.FRLayout;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.SparseMultigraph;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.CrossoverScalingControl;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.control.ModalGraphMouse;
import edu.uci.ics.jung.visualization.decorators.ToStringLabeller;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import edu.uci.ics.jung.visualization.renderers.VertexLabelAsShapeRenderer;
import gui.jtransitionsystem.TSSimpleActionEdge;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import org.apache.commons.collections15.Transformer;
import org.apache.commons.collections15.functors.ChainedTransformer;
import service.SimpleState;
import service.SimpleTransition;
import service.TransitionSystem;

public class JTransitionSystemSimple {
    private Graph<String, TSSimpleActionEdge> graph = new SparseMultigraph<String, TSSimpleActionEdge>();
    private TransitionSystem<SimpleState, SimpleTransition> ts;
    private VisualizationViewer<String, TSSimpleActionEdge> vv;
    private SimpleState currentState = null;
    private SimpleTransition lastAction = null;
    private JPanel panelTransitionSystem;

    public JTransitionSystemSimple(TransitionSystem<SimpleState, SimpleTransition> ts) {
        FRLayout<String, TSSimpleActionEdge> layout = new FRLayout<String, TSSimpleActionEdge>(this.graph);
        layout.setRepulsionMultiplier(200.0);
        layout.setAttractionMultiplier(2.0);
        this.vv = new VisualizationViewer<String, TSSimpleActionEdge>(layout);
        this.ts = ts;
        this.currentState = ts.getInitial();
        this.addStates();
        this.addActions();
        Transformer<String, Paint> vertexPaint = new Transformer<String, Paint>(){

            @Override
            public Paint transform(String i) {
                if (i.equals(JTransitionSystemSimple.this.currentState.getName())) {
                    return Color.GREEN;
                }
                return Color.CYAN;
            }
        };
        Transformer<TSSimpleActionEdge, Paint> edgePaint = new Transformer<TSSimpleActionEdge, Paint>(){

            @Override
            public Paint transform(TSSimpleActionEdge actionEdge) {
                if (JTransitionSystemSimple.this.lastAction != null && actionEdge.equals(JTransitionSystemSimple.this.lastAction.getName(), JTransitionSystemSimple.this.lastAction.getStateFrom().getName(), JTransitionSystemSimple.this.lastAction.getStateTo().getName())) {
                    return Color.RED;
                }
                return Color.BLACK;
            }
        };
        this.vv.getRenderContext().setVertexFillPaintTransformer(vertexPaint);
        this.vv.getRenderContext().setVertexLabelTransformer(new ToStringLabeller());
        this.vv.getRenderContext().setEdgeLabelTransformer(new ToStringLabeller());
        this.vv.getRenderer().getVertexLabelRenderer().setPosition(Renderer.VertexLabel.Position.CNTR);
        this.vv.getRenderContext().setEdgeDrawPaintTransformer(edgePaint);
        VertexLabelAsShapeRenderer vlasr = new VertexLabelAsShapeRenderer(this.vv.getRenderContext());
        this.vv.getRenderer().setVertexLabelRenderer(vlasr);
        this.vv.getRenderContext().setVertexShapeTransformer(vlasr);
        this.vv.getRenderContext().setVertexLabelTransformer(new ChainedTransformer(new Transformer[]{new ToStringLabeller(), new Transformer<String, String>(){

            @Override
            public String transform(String input) {
                return "<html><center>" + input;
            }
        }}));
        this.vv.getRenderContext().setEdgeLabelTransformer(new ChainedTransformer(new Transformer[]{new ToStringLabeller(), new Transformer<String, String>(){

            @Override
            public String transform(String input) {
                return "<html><center><font size=\"4\" color=\"#ff0000\">" + input;
            }
        }}));
        DefaultModalGraphMouse gm = new DefaultModalGraphMouse();
        gm.setMode(ModalGraphMouse.Mode.EDITING);
        this.vv.setGraphMouse(gm);
        JPanel panelButtons = new JPanel(new FlowLayout());
        final CrossoverScalingControl scaler = new CrossoverScalingControl();
        JButton zoomIn = new JButton("Zoom in");
        zoomIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                scaler.scale(JTransitionSystemSimple.this.vv, 1.1f, JTransitionSystemSimple.this.vv.getCenter());
            }
        });
        panelButtons.add(zoomIn);
        JButton zoomOut = new JButton("Zoom out");
        zoomOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                scaler.scale(JTransitionSystemSimple.this.vv, 0.9090909f, JTransitionSystemSimple.this.vv.getCenter());
            }
        });
        panelButtons.add(zoomOut);
        JButton editingMode = new JButton("Translation Mode");
        editingMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTransitionSystemSimple.this.setModeEditing();
            }
        });
        panelButtons.add(editingMode);
        JButton pickingMode = new JButton("Picking mode");
        pickingMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTransitionSystemSimple.this.setModePicking();
            }
        });
        panelButtons.add(pickingMode);
        JPanel panelGraph = new JPanel();
        panelGraph.add(this.vv);
        JTextArea textDotArea = new JTextArea(this.getDotFormatString());
        textDotArea.setEditable(false);
        JScrollPane scroolPaneDotArea = new JScrollPane(textDotArea);
        JSplitPane splitPane = new JSplitPane(0, panelGraph, scroolPaneDotArea);
        splitPane.setDividerLocation(600);
        this.panelTransitionSystem = new JPanel(new BorderLayout());
        this.panelTransitionSystem.add((Component)panelButtons, "North");
        this.panelTransitionSystem.add((Component)splitPane, "Center");
    }

    private String getDotFormatString() {
        StringBuffer result = new StringBuffer();
        result.append("digraph " + this.ts.getName() + " {\n");
        for (SimpleTransition currentAction : this.ts.getAllActions()) {
            String currentActionName = currentAction.getName();
            String currentSourceName = currentAction.getStateFrom().getName();
            String currentTargetName = currentAction.getStateTo().getName();
            result.append("\t" + currentSourceName + " -> " + currentTargetName + " [label=\"" + currentActionName + "\"]\n");
        }
        LinkedList<String> initialStatesStr = new LinkedList<String>();
        LinkedList<String> finalStatesStr = new LinkedList<String>();
        for (SimpleState currentState : this.ts.getAllStates()) {
            if (currentState.isInitial()) {
                initialStatesStr.add(currentState.getName());
            }
            if (!currentState.isFinal()) continue;
            finalStatesStr.add(currentState.getName());
        }
        result.append("\t[initial = {");
        Iterator itInitial = initialStatesStr.iterator();
        boolean firstInitialAdded = false;
        while (itInitial.hasNext()) {
            if (!firstInitialAdded) {
                firstInitialAdded = true;
                result.append((String)itInitial.next());
                continue;
            }
            result.append("," + (String)itInitial.next());
        }
        result.append("} ]\n");
        result.append("\t[final = {");
        Iterator itFinal = finalStatesStr.iterator();
        boolean firstFinalAdded = false;
        while (itFinal.hasNext()) {
            if (!firstFinalAdded) {
                firstFinalAdded = true;
                result.append((String)itFinal.next());
                continue;
            }
            result.append("," + (String)itFinal.next());
        }
        result.append("} ]\n");
        result.append("}\n");
        return result.toString();
    }

    public void setModeEditing() {
        DefaultModalGraphMouse gm = new DefaultModalGraphMouse();
        gm.setMode(ModalGraphMouse.Mode.EDITING);
        this.vv.setGraphMouse(gm);
    }

    public void setModePicking() {
        DefaultModalGraphMouse gm = new DefaultModalGraphMouse();
        gm.setMode(ModalGraphMouse.Mode.PICKING);
        this.vv.setGraphMouse(gm);
    }

    public SimpleState getCurrentState() {
        return this.currentState;
    }

    public JPanel getVisualizationViewer() {
        return this.panelTransitionSystem;
    }

    private void addStates() {
        for (SimpleState state : this.ts.getAllStates()) {
            this.graph.addVertex(state.getName());
        }
    }

    private void addActions() {
        for (SimpleTransition action : this.ts.getAllActions()) {
            this.graph.addEdge(new TSSimpleActionEdge(action.getName(), action.getStateFrom().getName(), action.getStateTo().getName()), action.getStateFrom().getName(), action.getStateTo().getName(), EdgeType.DIRECTED);
        }
    }

    public Set<SimpleTransition> getPossibleAction() throws Exception {
        return this.ts.getActionsOf(this.currentState);
    }

    public void executeAction(SimpleTransition action) throws Exception {
        this.lastAction = action;
        this.currentState = (SimpleState)action.getStateTo();
    }
}

