/*
 * Decompiled with CFR 0.152.
 */
package gui.XML;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;

public class saveToXML {
    private static String targetState;
    private static String availableState;
    private static String action;
    private static String availableService;
    private static String composedStateSimulator;
    private static String targetStateSimulated;
    private static String state;
    private static String service;
    private static char c;

    static {
        state = "";
        service = "";
    }

    public static void saveCompositionXML(Vector<String[]> v, String fileName, boolean wantsStylesheet) {
        try {
            File file = new File(String.valueOf(fileName) + ".xml");
            FileWriter fw = new FileWriter(file);
            fw.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
            if (wantsStylesheet) {
                fw.write("<?xml-stylesheet href=\"" + fileName + ".xsl\" type=\"text/xsl\"?>\n\n");
                saveToXML.saveCompositionXSL(fileName);
            }
            fw.write("<SetTransition>\n");
            int j = 0;
            while (j < v.size()) {
                String[] transition = v.elementAt(j);
                targetState = transition[0];
                availableState = transition[1];
                action = transition[2];
                availableService = transition[3];
                fw.write("\t<Transition>\n");
                fw.write("\t\t<InputState>\n");
                fw.write("\t\t\t<TargetState name=\"" + targetState + "\"/>" + "\n");
                int i = 0;
                while (i < availableState.length()) {
                    c = availableState.charAt(i);
                    if (c != ',') {
                        state = String.valueOf(state) + c;
                    } else {
                        fw.write("\t\t\t<AvailableState name=\"" + state + "\"/>" + "\n");
                        state = "";
                    }
                    ++i;
                }
                fw.write("\t\t\t<AvailableState name=\"" + state + "\"/>" + "\n");
                state = "";
                fw.write("\t\t\t<Action name=\"" + action + "\"/>" + "\n");
                fw.write("\t\t</InputState>\n");
                fw.write("\t\t<SetAvailableService>\n");
                i = 0;
                while (i < availableService.length()) {
                    c = availableService.charAt(i);
                    if (c != ',') {
                        service = String.valueOf(service) + c;
                    } else {
                        fw.write("\t\t\t<AvailableService name=\"" + service + "\"/>" + "\n");
                        service = "";
                    }
                    ++i;
                }
                fw.write("\t\t\t<AvailableService name=\"" + service + "\"/>" + "\n");
                service = "";
                fw.write("\t\t</SetAvailableService>\n");
                fw.write("\t</Transition>\n");
                ++j;
            }
            fw.write("</SetTransition>\n");
            fw.flush();
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void saveSimulationXML(Vector<String[]> v, String fileName, boolean wantsStylesheet) {
        try {
            File file = new File(String.valueOf(fileName) + ".xml");
            FileWriter fw = new FileWriter(file);
            fw.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
            if (wantsStylesheet) {
                fw.write("<?xml-stylesheet href=\"" + fileName + ".xsl\" type=\"text/xsl\"?>\n\n");
                saveToXML.saveSimulationXSL(fileName);
            }
            fw.write("<SetSimulation>\n");
            int j = 0;
            while (j < v.size()) {
                String[] transition = v.elementAt(j);
                targetStateSimulated = transition[0];
                composedStateSimulator = transition[1];
                fw.write("\t<Simulation>\n");
                fw.write("\t\t<TargetStateSimulated name=\"" + targetStateSimulated + "\"/>" + "\n");
                fw.write("\t\t<ComposedStateSimulator name=\"" + composedStateSimulator + "\"/>" + "\n");
                fw.write("\t</Simulation>\n");
                ++j;
            }
            fw.write("</SetSimulation>\n");
            fw.flush();
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void saveCompositionXSL(String fileName) {
        try {
            File file = new File(String.valueOf(fileName) + ".xsl");
            FileWriter fw = new FileWriter(file);
            fw.write("<?xml version=\"1.0\"?>\n");
            fw.write("<xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" version=\"1.0\">\n");
            fw.write("<xsl:output method=\"html\"/>\n\n");
            fw.write("<xsl:template match=\"/SetTransition\">\n");
            fw.write("\t<html>\n");
            fw.write("\t\t<body>\n");
            fw.write("\t\t\t<TABLE width=\"80%\" border=\"1\">\n");
            fw.write("\t\t\t\t<CAPTION>\n");
            fw.write("\t\t\t\t\t<DIV align=\"left\"><b>Composition Details</b></DIV>\n");
            fw.write("\t\t\t\t</CAPTION>\n");
            fw.write("\t\t\t\t<THEAD>\n");
            fw.write("\t\t\t\t\t<TR>\n");
            fw.write("\t\t\t\t\t\t<TH bgcolor=\"cyan\">Target System State</TH>\n");
            fw.write("\t\t\t\t\t\t<TH bgcolor=\"lightgreen\">Available Services States</TH>\n");
            fw.write("\t\t\t\t\t\t<TH bgcolor=\"red\">Action</TH>\n");
            fw.write("\t\t\t\t\t\t<TH bgcolor=\"orange\">Available Services</TH>\n");
            fw.write("\t\t\t\t\t</TR>\n");
            fw.write("\t\t\t\t</THEAD>\n");
            fw.write("\t\t\t\t<TBODY>\n");
            fw.write("\t\t\t\t\t<xsl:apply-templates/>\n");
            fw.write("\t\t\t\t</TBODY>\n");
            fw.write("\t\t\t</TABLE>\n");
            fw.write("\t\t</body>\n");
            fw.write("\t</html>\n");
            fw.write("</xsl:template>\n\n");
            fw.write("<xsl:template match=\"/SetTransition/Transition\">\n");
            fw.write("\t<TR>\n");
            fw.write("\t\t<xsl:apply-templates select=\"InputState\"/>\n");
            fw.write("\t\t<TD>\n");
            fw.write("\t\t\t<xsl:apply-templates select=\"SetAvailableService\"/>\n");
            fw.write("\t\t</TD>\n");
            fw.write("\t</TR>\n");
            fw.write("</xsl:template>\n\n");
            fw.write("<xsl:template match=\"/SetTransition/Transition/InputState\">\n");
            fw.write("\t<xsl:apply-templates select=\"TargetState\"/>\n");
            fw.write("\t<TD>\n");
            fw.write("\t\t<xsl:apply-templates select=\".//AvailableState\"/>\n");
            fw.write("\t</TD>\n");
            fw.write("\t<xsl:apply-templates select=\"Action\"/>\n");
            fw.write("</xsl:template>\n\n");
            fw.write("<xsl:template match=\"/SetTransition/Transition/InputState/TargetState\">\n");
            fw.write("\t<TD><FONT color=\"blue\"><b><xsl:value-of select=\"@name\"/></b></FONT></TD>\n");
            fw.write("</xsl:template>\n\n");
            fw.write("<xsl:template match=\"/SetTransition/Transition/InputState/AvailableState\">\n");
            fw.write("\t<FONT color=\"green\"><xsl:value-of select=\"@name\"/>,</FONT>\n");
            fw.write("</xsl:template>\n\n");
            fw.write("<xsl:template match=\"/SetTransition/Transition/InputState/AvailableState[last()]\">\n");
            fw.write("\t<FONT color=\"green\"><xsl:value-of select=\"@name\"/></FONT>\n");
            fw.write("</xsl:template>\n\n");
            fw.write("<xsl:template match=\"/SetTransition/Transition/InputState/Action\">\n");
            fw.write("\t<TD><FONT color=\"red\"><b><xsl:value-of select=\"@name\"/></b></FONT></TD>\n");
            fw.write("</xsl:template>\n\n");
            fw.write("<xsl:template match=\"/SetTransition/Transition/SetAvailableService\">\n");
            fw.write("\t<FONT color=\"orange\"><xsl:apply-templates/> </FONT>\n");
            fw.write("</xsl:template>\n\n");
            fw.write("<xsl:template match=\"/SetTransition/Transition/SetAvailableService/AvailableService\">\n");
            fw.write("\t<xsl:value-of select=\"@name\"/>,\n");
            fw.write("</xsl:template>\n\n");
            fw.write("<xsl:template match=\"/SetTransition/Transition/SetAvailableService/AvailableService[last()]\">\n");
            fw.write("\t<xsl:value-of select=\"@name\"/>\n");
            fw.write("</xsl:template>\n\n");
            fw.write("</xsl:stylesheet>\n");
            fw.flush();
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void saveSimulationXSL(String fileName) {
        try {
            File file = new File(String.valueOf(fileName) + ".xsl");
            FileWriter fw = new FileWriter(file);
            fw.write("<?xml version=\"1.0\"?>\n");
            fw.write("<xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" version=\"1.0\">\n");
            fw.write("<xsl:output method=\"html\"/>\n\n");
            fw.write("<xsl:template match=\"/SetSimulation\">\n");
            fw.write("\t<html>\n");
            fw.write("\t\t<body>\n");
            fw.write("\t\t\t<TABLE width=\"40%\" border=\"1\">\n");
            fw.write("\t\t\t\t<CAPTION>\n");
            fw.write("\t\t\t\t\t<DIV align=\"left\"><b>Simulation Details</b></DIV>\n");
            fw.write("\t\t\t\t</CAPTION>\n");
            fw.write("\t\t\t\t<THEAD>\n");
            fw.write("\t\t\t\t\t<TR>\n");
            fw.write("\t\t\t\t\t\t<TH bgcolor=\"cyan\">Target State Simulated</TH>\n");
            fw.write("\t\t\t\t\t\t<TH bgcolor=\"lightgreen\">Composed State Simulator</TH>\n");
            fw.write("\t\t\t\t\t</TR>\n");
            fw.write("\t\t\t\t</THEAD>\n");
            fw.write("\t\t\t\t<TBODY>\n");
            fw.write("\t\t\t\t\t<xsl:apply-templates/>\n");
            fw.write("\t\t\t\t</TBODY>\n");
            fw.write("\t\t\t</TABLE>\n");
            fw.write("\t\t</body>\n");
            fw.write("\t</html>\n");
            fw.write("</xsl:template>\n\n");
            fw.write("<xsl:template match=\"/SetSimulation/Simulation\">\n");
            fw.write("\t<TR>\n");
            fw.write("\t\t<xsl:apply-templates/>\n");
            fw.write("\t</TR>\n");
            fw.write("</xsl:template>\n\n");
            fw.write("<xsl:template match=\"/SetSimulation/Simulation/TargetStateSimulated\">\n");
            fw.write("\t<TD><FONT color=\"blue\"><b><xsl:value-of select=\"@name\"/></b></FONT></TD>\n");
            fw.write("</xsl:template>\n\n");
            fw.write("<xsl:template match=\"/SetSimulation/Simulation/ComposedStateSimulator\">\n");
            fw.write("\t<TD><FONT color=\"green\"><xsl:value-of select=\"@name\"/></FONT></TD>\n");
            fw.write("</xsl:template>\n\n");
            fw.write("</xsl:stylesheet>\n");
            fw.flush();
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

