/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.GenericLoader;
import gui.MainFrame;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

public class TableMenu
extends JPopupMenu {
    private boolean usingTarget = false;
    private static final long serialVersionUID = 1L;
    private JMenuItem editService;
    private int selected;

    public TableMenu() {
        this.init();
    }

    void init() {
        this.add(this.getEditService());
    }

    public void setUsingTarget(boolean t) {
        this.usingTarget = t;
    }

    public JMenuItem getEditService() {
        if (this.editService == null) {
            this.editService = new JMenuItem();
            this.editService.setText("Edit in external editor");
            this.editService.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    block5: {
                        try {
                            if (TableMenu.this.usingTarget) {
                                File toOpen = new File(GenericLoader.getPathTarget());
                                if (Desktop.isDesktopSupported()) {
                                    Desktop.getDesktop().open(toOpen);
                                    break block5;
                                }
                                throw new Exception("Sorry, your System does not support this functionality.");
                            }
                            Vector<String> availablePaths = GenericLoader.getPathAvailableService();
                            String path = availablePaths.elementAt(TableMenu.this.selected);
                            File toOpen = new File(path);
                            if (Desktop.isDesktopSupported()) {
                                Desktop.getDesktop().open(toOpen);
                                break block5;
                            }
                            throw new Exception("Sorry, your System does not support this functionality.");
                        }
                        catch (Exception exc) {
                            JOptionPane.showMessageDialog(MainFrame.getInstance(), "Error: " + exc.getMessage(), "Error", 0);
                        }
                    }
                }
            });
        }
        return this.editService;
    }

    public void setSelected(int n) {
        this.selected = n;
    }
}

