/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.GenericLoader;
import gui.GraphViewerPanel;
import gui.MainFrame;
import gui.jtransitionsystem.JTransitionSystemSimple;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import service.ComposedState;
import service.SimpleState;
import service.SimpleTransition;
import service.TransitionSystem;

public class SimulationPanel
extends JPanel {
    static final long serialVersionUID = 1L;
    private JScrollPane listScroller = null;
    private JTable actionList = null;
    private JLabel actionLabel = null;
    private JButton actionButton = null;
    private JPanel buttonPanel = null;
    private JButton startSimulation = null;
    private JButton stopSimulation = null;
    private Vector<SimpleTransition> availableActions = null;
    private Vector<String> actionNames = null;

    public SimulationPanel() {
        this.initialize();
    }

    void initialize() {
        this.setLayout(new BorderLayout());
        this.actionList = this.getActionList();
        this.listScroller = new JScrollPane(this.actionList);
        this.listScroller.setPreferredSize(new Dimension(100, 100));
        this.add((Component)this.listScroller, "Center");
        this.add((Component)this.getActionLabel(), "West");
        this.buttonPanel = new JPanel();
        this.buttonPanel.add(this.getActionButton());
        this.buttonPanel.add(this.getStartSimulation());
        this.buttonPanel.add(this.getStopSimulation());
        this.add((Component)this.buttonPanel, "South");
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.RED, 1), "Simulation Panel", 0, 0, new Font("Arial", 1, 14), Color.red));
    }

    private JLabel getActionLabel() {
        if (this.actionLabel == null) {
            this.actionLabel = new JLabel();
            this.actionLabel.setText("Available Actions:");
            this.actionLabel.setVerticalTextPosition(1);
            this.actionLabel.setVerticalAlignment(1);
        }
        return this.actionLabel;
    }

    public JButton getActionButton() {
        if (this.actionButton == null) {
            this.actionButton = new JButton();
            this.actionButton.setText("Do Action");
            this.actionButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (SimulationPanel.this.actionList.getSelectedRow() != -1) {
                        int index = SimulationPanel.this.actionList.getSelectedRow();
                        try {
                            GenericLoader.doAction((SimpleTransition)SimulationPanel.this.availableActions.elementAt(index));
                            JTransitionSystemSimple jt = GenericLoader.getJTargetService();
                            GraphViewerPanel graphPanel = MainFrame.getInstance().getGraphViewerPanel();
                            graphPanel.printGraph(jt.getVisualizationViewer());
                            graphPanel.setGraphName(GenericLoader.getTargetServiceName());
                            SimulationPanel.this.initActionList();
                            JTable serviceList = MainFrame.getInstance().getAvServPanel().getAvailableServiceList();
                            TableModel tableModel = serviceList.getModel();
                            ComposedState composedState = GenericLoader.getCurrentAvailableState();
                            int i = 0;
                            while (i < tableModel.getRowCount()) {
                                tableModel.setValueAt(composedState.getServicesState(i).getName(), i, 1);
                                ++i;
                            }
                            TransitionSystem<SimpleState, SimpleTransition> lastTSExecutedAction = GenericLoader.getLastTSExecutedAction();
                            JTable targetList = MainFrame.getInstance().getAvServPanel().getTargetServiceList();
                            TableModel tableModel1 = targetList.getModel();
                            tableModel1.setValueAt(GenericLoader.getCurrentTargetState().getName(), 0, 1);
                            JOptionPane.showMessageDialog(null, "Action executed by the service " + lastTSExecutedAction.getName());
                        }
                        catch (Exception ex) {
                            JOptionPane.showMessageDialog(MainFrame.getInstance(), "State Description Panel error: \n" + ex.getMessage(), "Error", 0);
                        }
                    }
                }
            });
            this.actionButton.setEnabled(false);
        }
        return this.actionButton;
    }

    public JButton getStartSimulation() {
        if (this.startSimulation == null) {
            this.startSimulation = new JButton("Compute Simulation");
            this.startSimulation.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        GenericLoader.startOrchestrator();
                        JTable serviceList = MainFrame.getInstance().getAvServPanel().getAvailableServiceList();
                        TableModel tableModel = serviceList.getModel();
                        ComposedState composedState = GenericLoader.getCurrentAvailableState();
                        if (!GenericLoader.getCompositionTs().isValid()) {
                            JOptionPane.showMessageDialog(MainFrame.getInstance(), "Composition Transition System is not valid.\nNo any Initial State found.\nCannot go further with the Simulation.", "Error", 0);
                            return;
                        }
                        int i = 0;
                        while (i < tableModel.getRowCount()) {
                            tableModel.setValueAt(composedState.getServicesState(i).getName(), i, 1);
                            ++i;
                        }
                        JTable targetList = MainFrame.getInstance().getAvServPanel().getTargetServiceList();
                        TableModel tableModel1 = targetList.getModel();
                        tableModel1.setValueAt(GenericLoader.getCurrentTargetState().getName(), 0, 1);
                        JTransitionSystemSimple jt = GenericLoader.getJTargetService();
                        GraphViewerPanel graphPanel = MainFrame.getInstance().getGraphViewerPanel();
                        if (GenericLoader.getTargetService().getAllStates().size() >= 20) {
                            if (JOptionPane.showConfirmDialog(null, "Target System size is " + GenericLoader.getTargetService().getAllStates().size() + "nodes.\nVisualization could be very slow.\nDo you want to visualize it anyway?", "Warning", 0, 2) == 0) {
                                graphPanel.printGraph(jt.getVisualizationViewer());
                                graphPanel.setGraphName(GenericLoader.getTargetServiceName());
                            }
                        } else {
                            graphPanel.printGraph(jt.getVisualizationViewer());
                            graphPanel.setGraphName(GenericLoader.getTargetServiceName());
                        }
                        MainFrame.getInstance().getStateDescriptionPanel().initActionList();
                        MainFrame.getInstance().toFront();
                        MainFrame.getInstance().getAvServPanel().getRemoveAvailableServiceButton().setEnabled(false);
                    }
                    catch (Exception exc) {
                        JOptionPane.showMessageDialog(null, "Error: " + exc.getMessage(), "Error", 0);
                    }
                }
            });
            this.startSimulation.setEnabled(false);
        }
        return this.startSimulation;
    }

    public JButton getStopSimulation() {
        if (this.stopSimulation == null) {
            this.stopSimulation = new JButton("Stop Simulation");
            this.stopSimulation.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        GenericLoader.stopOrchestrator();
                        JTable serviceList = MainFrame.getInstance().getAvServPanel().getAvailableServiceList();
                        TableModel tableModel = serviceList.getModel();
                        int i = 0;
                        while (i < tableModel.getRowCount()) {
                            tableModel.setValueAt("None", i, 1);
                            ++i;
                        }
                        MainFrame.getInstance().getStateDescriptionPanel().resetActionList();
                        MainFrame.getInstance().getAvServPanel().getRemoveAvailableServiceButton().setEnabled(true);
                        MainFrame.getInstance().getAvServPanel().getActionButton().setEnabled(true);
                        MainFrame.getInstance().getAvServPanel().getActionButton1().setEnabled(true);
                    }
                    catch (Exception exc) {
                        JOptionPane.showMessageDialog(null, exc.getMessage(), "Error", 0);
                        System.out.println(exc.getMessage());
                    }
                }
            });
            this.stopSimulation.setEnabled(false);
        }
        return this.stopSimulation;
    }

    public void resetActionList() {
        if (this.actionList != null) {
            DefaultTableModel tableModel = new DefaultTableModel(new String[][]{new String[0]}, new String[]{"Action Name", "Target State"});
            this.actionList.setModel(tableModel);
            this.actionList.setAutoResizeMode(0);
            this.actionList.getColumnModel().getColumn(0).setPreferredWidth(150);
            this.actionList.getColumnModel().getColumn(1).setPreferredWidth(150);
            this.actionList.setSelectionMode(0);
            this.actionList.setColumnSelectionAllowed(false);
            this.actionList.setRowSelectionAllowed(true);
            this.updateUI();
        }
    }

    public void initActionList() {
        if (this.availableActions == null) {
            this.availableActions = new Vector(0, 1);
        }
        if (this.actionNames == null) {
            this.actionNames = new Vector(0, 1);
        }
        this.availableActions.removeAllElements();
        this.actionNames.removeAllElements();
        try {
            SimpleState currentState = GenericLoader.getCurrentTargetState();
            Set<SimpleTransition> actions = GenericLoader.getTargetService().getActionsOf(currentState);
            Iterator<SimpleTransition> it = actions.iterator();
            Object[][] data = new String[actions.size()][2];
            int i = 0;
            while (it.hasNext()) {
                SimpleTransition temp = it.next();
                this.availableActions.add(temp);
                this.actionNames.add(temp.getName());
                data[i][0] = temp.getName();
                data[i][1] = temp.getStateTo().getName();
                ++i;
            }
            DefaultTableModel tableModel = new DefaultTableModel(data, new String[]{"Action Name", "Target State"});
            this.actionList.setModel(tableModel);
            this.actionList.setAutoResizeMode(0);
            this.actionList.getColumnModel().getColumn(0).setPreferredWidth(150);
            this.actionList.getColumnModel().getColumn(1).setPreferredWidth(150);
            this.actionList.setSelectionMode(0);
            this.actionList.setColumnSelectionAllowed(false);
            this.actionList.setRowSelectionAllowed(true);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(MainFrame.getInstance(), "Error: " + ex.getMessage(), "Error", 0);
        }
    }

    private JTable getActionList() {
        if (this.actionList == null) {
            this.actionList = new JTable();
            DefaultTableModel tableModel = new DefaultTableModel(new String[][]{new String[0]}, new String[]{"Action Name", "Target State"});
            this.actionList.setModel(tableModel);
            this.actionList.setAutoResizeMode(0);
            this.actionList.getColumnModel().getColumn(0).setPreferredWidth(150);
            this.actionList.getColumnModel().getColumn(1).setPreferredWidth(150);
            this.actionList.setSelectionMode(0);
            this.actionList.setColumnSelectionAllowed(false);
            this.actionList.setRowSelectionAllowed(true);
        }
        return this.actionList;
    }
}

