/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.GenericLoader;
import gui.GraphViewerPanel;
import gui.MainFrame;
import gui.TableMenu;
import gui.jtransitionsystem.JTransitionSystemSimple;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import service.SimpleState;
import service.SimpleTransition;
import service.TransitionSystem;

public class ServicePanel
extends JPanel {
    static final long serialVersionUID = 1L;
    private JScrollPane listScroller = null;
    private JTable serviceList = null;
    private JButton serviceButton = null;
    private JPanel buttonPanel = null;
    private JPanel availableServicePanel = null;
    private JPanel targetServicePanel = null;
    private JScrollPane listScroller1;
    private JTable targetList;
    private JPanel buttonPanel1;
    private JButton targetButton;
    private TableMenu popup;
    private JButton removeAvailableService;

    public JTable getTargetList() {
        return this.targetList;
    }

    public JTable getServiceList() {
        return this.serviceList;
    }

    public ServicePanel() {
        this.initialize();
    }

    void initialize() {
        this.popup = new TableMenu();
        this.availableServicePanel = new JPanel();
        this.availableServicePanel.setLayout(new BorderLayout());
        this.listScroller = new JScrollPane(this.getAvailableServiceList());
        this.availableServicePanel.add((Component)this.listScroller, "Center");
        this.buttonPanel = new JPanel();
        this.buttonPanel.add(this.getActionButton());
        this.buttonPanel.add(this.getRemoveAvailableServiceButton());
        this.availableServicePanel.add((Component)this.buttonPanel, "South");
        this.availableServicePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.ORANGE, 1), "Services Panel", 0, 0, new Font("Arial", 1, 14), Color.orange));
        this.targetServicePanel = new JPanel();
        this.targetServicePanel.setLayout(new BorderLayout());
        this.targetServicePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLUE, 1), "Target Service", 0, 0, new Font("Arial", 1, 14), Color.BLUE));
        this.listScroller1 = new JScrollPane(this.getTargetServiceList());
        this.targetServicePanel.add((Component)this.listScroller1, "Center");
        this.buttonPanel1 = new JPanel();
        this.buttonPanel1.add(this.getActionButton1());
        this.targetServicePanel.add((Component)this.buttonPanel1, "South");
        JSplitPane splitPane = new JSplitPane(0, this.availableServicePanel, this.targetServicePanel);
        splitPane.setDividerLocation(Toolkit.getDefaultToolkit().getScreenSize().height / 4);
        this.setLayout(new BorderLayout());
        this.add((Component)splitPane, "Center");
    }

    public JButton getActionButton() {
        if (this.serviceButton == null) {
            this.serviceButton = new JButton();
            this.serviceButton.setText("Show Available Service");
            this.serviceButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ServicePanel.this.showAvailableService();
                }
            });
            this.serviceButton.setEnabled(false);
        }
        return this.serviceButton;
    }

    public JButton getActionButton1() {
        if (this.targetButton == null) {
            this.targetButton = new JButton();
            this.targetButton.setText("Show Target Service");
            this.targetButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ServicePanel.this.showTargetService();
                }
            });
            this.targetButton.setEnabled(false);
        }
        return this.targetButton;
    }

    public JButton getRemoveAvailableServiceButton() {
        if (this.removeAvailableService == null) {
            this.removeAvailableService = new JButton();
            this.removeAvailableService.setText("Remove selected service");
            this.removeAvailableService.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int index = ServicePanel.this.serviceList.getSelectedRow();
                    if (index == -1) {
                        JOptionPane.showMessageDialog(MainFrame.getInstance(), "No available service selected.", "Error", 0);
                    } else {
                        GenericLoader.getPathAvailableService().removeElementAt(index);
                        GenericLoader.getAvailableServices().removeElementAt(index);
                        DefaultTableModel tableModel = (DefaultTableModel)ServicePanel.this.serviceList.getModel();
                        tableModel.removeRow(index);
                    }
                }
            });
            this.removeAvailableService.setEnabled(false);
        }
        return this.removeAvailableService;
    }

    public JTable getAvailableServiceList() {
        if (this.serviceList == null) {
            this.serviceList = new JTable();
            DefaultTableModel tableModel = new DefaultTableModel(new String[][]{new String[0]}, new String[]{"TS name", "State", "Filename"});
            this.serviceList.setModel(tableModel);
            this.serviceList.setAutoResizeMode(0);
            this.serviceList.getColumnModel().getColumn(0).setPreferredWidth(150);
            this.serviceList.getColumnModel().getColumn(1).setPreferredWidth(150);
            this.serviceList.getColumnModel().getColumn(2).setPreferredWidth(150);
            this.serviceList.setSelectionMode(0);
            this.serviceList.setColumnSelectionAllowed(false);
            this.serviceList.setRowSelectionAllowed(true);
            this.serviceList.addMouseMotionListener(new MouseMotionListener(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    JTable aTable = (JTable)e.getSource();
                    int itsRow = aTable.rowAtPoint(e.getPoint());
                    if (itsRow >= 0 && itsRow < GenericLoader.getPathAvailableService().size()) {
                        aTable.setToolTipText(GenericLoader.getPathAvailableService().elementAt(itsRow));
                    }
                }

                @Override
                public void mouseDragged(MouseEvent e) {
                }
            });
            this.serviceList.addMouseListener(new MouseListener(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        JTable service = (JTable)e.getSource();
                        int row = service.rowAtPoint(e.getPoint());
                        System.out.println(row);
                        if (row >= 0 && row < GenericLoader.getPathAvailableService().size()) {
                            ServicePanel.this.popup.setSelected(row);
                            ServicePanel.this.popup.setUsingTarget(false);
                            ServicePanel.this.popup.show(e.getComponent(), e.getX(), e.getY());
                        }
                    }
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    JTable service;
                    int row;
                    if (e.isPopupTrigger() && (row = (service = (JTable)e.getSource()).rowAtPoint(e.getPoint())) >= 0 && row < GenericLoader.getPathAvailableService().size()) {
                        ServicePanel.this.popup.setSelected(row);
                        ServicePanel.this.popup.setUsingTarget(false);
                        ServicePanel.this.popup.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            });
            this.showAvailableService();
        }
        return this.serviceList;
    }

    public JTable getTargetServiceList() {
        if (this.targetList == null) {
            this.targetList = new JTable();
            DefaultTableModel tableModel = new DefaultTableModel(new String[][]{new String[0]}, new String[]{"TS name", "State", "Filename"});
            this.targetList.setModel(tableModel);
            this.targetList.setAutoResizeMode(0);
            this.targetList.getColumnModel().getColumn(0).setPreferredWidth(150);
            this.targetList.getColumnModel().getColumn(1).setPreferredWidth(150);
            this.targetList.getColumnModel().getColumn(2).setPreferredWidth(150);
            this.targetList.setSelectionMode(0);
            this.targetList.setColumnSelectionAllowed(false);
            this.targetList.setRowSelectionAllowed(true);
            this.targetList.setCellSelectionEnabled(false);
            this.targetList.setDragEnabled(false);
            this.targetList.addMouseMotionListener(new MouseMotionListener(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    JTable aTable = (JTable)e.getSource();
                    int itsRow = aTable.rowAtPoint(e.getPoint());
                    if (itsRow >= 0) {
                        aTable.setToolTipText(GenericLoader.getPathTarget());
                    }
                }

                @Override
                public void mouseDragged(MouseEvent e) {
                }
            });
            this.targetList.addMouseListener(new MouseListener(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        ServicePanel.this.popup.setUsingTarget(true);
                        ServicePanel.this.popup.show(e.getComponent(), e.getX(), e.getY());
                    }
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        ServicePanel.this.popup.setUsingTarget(true);
                        ServicePanel.this.popup.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            });
        }
        return this.targetList;
    }

    public void showAvailableService() {
        int index = this.serviceList.getSelectedRow();
        if (index == -1) {
            return;
        }
        Vector<TransitionSystem<SimpleState, SimpleTransition>> availableServices = GenericLoader.getAvailableServices();
        if (availableServices == null) {
            JOptionPane.showMessageDialog(null, "No service available. Load available services please.", "Error", 0);
        } else {
            TransitionSystem<SimpleState, SimpleTransition> availableService = GenericLoader.getAvailableServices().get(index);
            if (availableService.getAllStates().size() >= 20) {
                if (JOptionPane.showConfirmDialog(null, "The selected available service has size " + availableService.getAllStates().size() + " nodes\n" + availableService.getAllActions().size() + " edges\nVisualization could be very slow.\nAre you sure you want to show it anyway?", "Warning", 0, 2) == 0) {
                    JTransitionSystemSimple javailableService = new JTransitionSystemSimple(availableService);
                    GraphViewerPanel graphPanel = MainFrame.getInstance().getGraphViewerPanel();
                    graphPanel.printGraph(javailableService.getVisualizationViewer());
                    graphPanel.setGraphName(GenericLoader.getAvailableServicesNames().get(index));
                }
            } else {
                JTransitionSystemSimple javailableService = new JTransitionSystemSimple(availableService);
                GraphViewerPanel graphPanel = MainFrame.getInstance().getGraphViewerPanel();
                graphPanel.printGraph(javailableService.getVisualizationViewer());
                graphPanel.setGraphName(GenericLoader.getAvailableServicesNames().get(index));
            }
        }
    }

    public void showTargetService() {
        TransitionSystem<SimpleState, SimpleTransition> targetService = GenericLoader.getTargetService();
        if (targetService == null) {
            JOptionPane.showMessageDialog(null, "No target available. Load a target service please.", "Error", 0);
        } else if (targetService.getAllStates().size() >= 20) {
            if (JOptionPane.showConfirmDialog(null, "The selected target service has size " + targetService.getAllStates().size() + " nodes\n" + targetService.getAllActions().size() + " edges\nVisualization could be very slow.\nAre you sure you want to show it anyway?", "Warning", 0, 2) == 0) {
                JTransitionSystemSimple javailableService = new JTransitionSystemSimple(targetService);
                GraphViewerPanel graphPanel = MainFrame.getInstance().getGraphViewerPanel();
                graphPanel.printGraph(javailableService.getVisualizationViewer());
                graphPanel.setGraphName(GenericLoader.getTargetServiceName());
            }
        } else {
            JTransitionSystemSimple javailableService = new JTransitionSystemSimple(targetService);
            GraphViewerPanel graphPanel = MainFrame.getInstance().getGraphViewerPanel();
            graphPanel.printGraph(javailableService.getVisualizationViewer());
            graphPanel.setGraphName(GenericLoader.getTargetServiceName());
        }
    }
}

