/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.GenericLoader;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;

public class OptionsFrame
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JRadioButton jStandard;
    private JButton Ok;
    private ButtonGroup buttonGroup1;
    private JButton jCancel;
    private JRadioButton jPlus;
    private JLabel jLabel1;

    public OptionsFrame() {
        this.initGUI();
    }

    private void initGUI() {
        try {
            this.setDefaultCloseOperation(2);
            this.getContentPane().setLayout(null);
            this.jLabel1 = new JLabel();
            this.getContentPane().add(this.jLabel1);
            this.jLabel1.setText("Select orchestrator:");
            this.jLabel1.setBounds(12, 28, 159, 16);
            this.jStandard = new JRadioButton();
            this.getContentPane().add(this.jStandard);
            this.jStandard.setText("Standard");
            this.jStandard.setBounds(131, 55, 168, 20);
            this.jPlus = new JRadioButton();
            this.getContentPane().add(this.jPlus);
            this.jPlus.setText("Plus");
            this.jPlus.setBounds(131, 84, 168, 20);
            this.Ok = new JButton();
            this.getContentPane().add(this.Ok);
            this.Ok.setText("Ok");
            this.Ok.setBounds(52, 121, 69, 22);
            this.Ok.addActionListener(this);
            this.jCancel = new JButton();
            this.getContentPane().add(this.jCancel);
            this.jCancel.setText("Cancel");
            this.jCancel.setBounds(166, 121, 78, 22);
            this.jCancel.addActionListener(this);
            this.getButtonGroup1();
            this.pack();
            this.setSize(320, 218);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ButtonGroup getButtonGroup1() {
        if (this.buttonGroup1 == null) {
            this.buttonGroup1 = new ButtonGroup();
            this.buttonGroup1.add(this.jStandard);
            this.buttonGroup1.add(this.jPlus);
            Properties applicationProps = new Properties();
            try {
                FileInputStream in = new FileInputStream("symphony.conf");
                applicationProps.load(in);
                in.close();
                String orchestrator_prop = applicationProps.getProperty("orchestrator");
                if (orchestrator_prop.equals("standard")) {
                    this.jStandard.setSelected(true);
                } else if (orchestrator_prop.equals("plus")) {
                    this.jPlus.setSelected(true);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.buttonGroup1;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.jCancel)) {
            this.setVisible(false);
        }
        if (e.getSource().equals(this.Ok)) {
            byte orchestrator_selected = 0;
            if (this.jStandard.isSelected()) {
                orchestrator_selected = GenericLoader.ORCHESTRATOR_STANDARD;
            }
            if (this.jPlus.isSelected()) {
                orchestrator_selected = GenericLoader.ORCHESTRATOR_PLUS;
            }
            if (GenericLoader.orchestratorIsStarted()) {
                JOptionPane.showMessageDialog(this, "Stop the orchestrator before to change options");
                return;
            }
            Properties applicationProps = new Properties();
            if (orchestrator_selected == GenericLoader.ORCHESTRATOR_STANDARD) {
                applicationProps.put("orchestrator", "standard");
            }
            if (orchestrator_selected == GenericLoader.ORCHESTRATOR_PLUS) {
                applicationProps.put("orchestrator", "plus");
            }
            GenericLoader.setOrchestrator(orchestrator_selected);
            try {
                FileOutputStream out = new FileOutputStream("symphony.conf");
                applicationProps.store(out, "");
                out.close();
            }
            catch (FileNotFoundException e2) {
                e2.printStackTrace();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            this.setVisible(false);
        }
    }
}

