/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.GenericLoader;
import gui.GraphViewerPanel;
import gui.MainFrameMenuBar;
import gui.ServicePanel;
import gui.SimulationPanel;
import gui.menus.view.TargetViewItem;
import java.awt.Toolkit;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import javax.swing.JFrame;
import javax.swing.JSplitPane;

public class MainFrame
extends JFrame {
    static final long serialVersionUID = 1L;
    private MainFrameMenuBar menuBar;
    private SimulationPanel statePanel;
    private ServicePanel availableServicePanel;
    private JSplitPane leftSplitPane;
    private GraphViewerPanel graphPanel;
    private JSplitPane splitPane;
    static MainFrame mainFrame;
    private Properties applicationProps = new Properties();

    public MainFrame() {
        this.initialize();
        mainFrame = this;
        this.leftSplitPane.setDividerLocation(mainFrame.getContentPane().getHeight() / 3 * 2);
    }

    void initialize() {
        try {
            FileInputStream in = new FileInputStream("symphony.conf");
            this.applicationProps.load(in);
            in.close();
            String orchestrator_prop = this.applicationProps.getProperty("orchestrator");
            if (orchestrator_prop.equals("standard")) {
                GenericLoader.setOrchestrator(GenericLoader.ORCHESTRATOR_STANDARD);
            } else if (orchestrator_prop.equals("plus")) {
                GenericLoader.setOrchestrator(GenericLoader.ORCHESTRATOR_PLUS);
            }
        }
        catch (FileNotFoundException e1) {
            this.applicationProps.put("orchestrator", "standard");
            this.applicationProps.put("targetDirectory", ".");
            this.applicationProps.put("availableDirectory", ".");
            try {
                FileOutputStream out = new FileOutputStream("symphony.conf");
                this.applicationProps.store(out, "");
                out.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.setTitle("Symphony 2.0");
        this.setLocation(0, 0);
        this.setSize(Toolkit.getDefaultToolkit().getScreenSize().width, Toolkit.getDefaultToolkit().getScreenSize().height - 30);
        this.setDefaultCloseOperation(3);
        this.menuBar = new MainFrameMenuBar();
        this.setJMenuBar(this.menuBar);
        this.statePanel = new SimulationPanel();
        this.graphPanel = new GraphViewerPanel();
        this.availableServicePanel = new ServicePanel();
        this.leftSplitPane = new JSplitPane(0, this.availableServicePanel, this.statePanel);
        this.leftSplitPane.setDividerLocation(500);
        this.splitPane = new JSplitPane(1, this.leftSplitPane, this.graphPanel);
        this.splitPane.setOneTouchExpandable(true);
        this.add(this.splitPane);
        this.setVisible(true);
    }

    public static MainFrame getInstance() {
        if (mainFrame == null) {
            return new MainFrame();
        }
        return mainFrame;
    }

    public GraphViewerPanel getGraphViewerPanel() {
        return this.graphPanel;
    }

    public ServicePanel getAvServPanel() {
        return this.availableServicePanel;
    }

    public SimulationPanel getStateDescriptionPanel() {
        return this.statePanel;
    }

    public void showTarget() {
        ((TargetViewItem)this.menuBar.getViewMenu().getTargetItem()).showTarget();
    }
}

