/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.MainFrame;
import gui.jtransitionsystem.JTransitionSystemSimple;
import java.util.Vector;
import javax.swing.JOptionPane;
import orchestrator.Orchestrator;
import orchestrator.OrchestratorStandardImpl;
import orchestrator.plus.OrchestratorPlusImpl;
import service.ComposedState;
import service.ComposedTransition;
import service.ServiceFactory;
import service.ServiceFactoryImpl;
import service.SimpleState;
import service.SimpleTransition;
import service.TransitionSystem;
import service.TransitionSystemImpl;

public class GenericLoader {
    public static byte ORCHESTRATOR_STANDARD = 0;
    public static byte ORCHESTRATOR_PLUS = 1;
    private static byte selected_orchestrator = 0;
    private static ServiceFactory serviceFactory = new ServiceFactoryImpl();
    private static TransitionSystem<SimpleState, SimpleTransition> targetService;
    private static String targetName;
    private static JTransitionSystemSimple jTargetService;
    private static Vector<TransitionSystem<SimpleState, SimpleTransition>> availableServices;
    private static Vector<String> pathAvailableServices;
    private static String pathTarget;
    private static Vector<String> availableServicesNames;
    private static Orchestrator orchestrator;

    static {
        pathAvailableServices = new Vector();
        pathTarget = "";
        orchestrator = null;
    }

    public static void setOrchestrator(byte orchestrator) {
        selected_orchestrator = orchestrator;
    }

    public static void setTargetService(TransitionSystem<SimpleState, SimpleTransition> TS) {
        targetService = TS;
        jTargetService = new JTransitionSystemSimple(targetService);
        if (GenericLoader.checkSimulationComputable()) {
            GenericLoader.activateComputeButton();
        }
    }

    public static TransitionSystem<SimpleState, SimpleTransition> getTargetService() {
        return targetService;
    }

    public static JTransitionSystemSimple getJTargetService() {
        return jTargetService;
    }

    public static void setTargetServiceName(String name) {
        targetName = name;
    }

    public static String getTargetServiceName() {
        return targetName;
    }

    public static void addAvailableServices(Vector<TransitionSystem<SimpleState, SimpleTransition>> ts) {
        if (availableServices == null) {
            availableServices = new Vector<TransitionSystem<SimpleState, SimpleTransition>>(ts);
        } else {
            int i = 0;
            while (i < ts.size()) {
                availableServices.addElement(ts.get(i));
                ++i;
            }
        }
        if (GenericLoader.checkSimulationComputable()) {
            GenericLoader.activateComputeButton();
        }
    }

    public static Vector<TransitionSystem<SimpleState, SimpleTransition>> getAvailableServices() {
        return availableServices;
    }

    public static void addAvailableServicesNames(Vector<String> names) {
        if (availableServicesNames == null) {
            availableServicesNames = new Vector<String>(names);
        } else {
            int i = 0;
            while (i < names.size()) {
                availableServicesNames.addElement(names.get(i));
                ++i;
            }
        }
    }

    public static Vector<String> getAvailableServicesNames() {
        return availableServicesNames;
    }

    public static void resetSystem() {
        orchestrator = null;
        targetService = null;
        targetName = "";
        jTargetService = null;
        if (availableServices != null) {
            availableServices = new Vector();
        }
        if (availableServicesNames != null) {
            availableServicesNames = new Vector();
        }
        pathTarget = "";
        pathAvailableServices = new Vector();
    }

    public static void startOrchestrator() throws Exception {
        if (availableServices == null || availableServices.size() == 0) {
            JOptionPane.showMessageDialog(null, "No Available Service defined.\nDefine the directory containing available services.\nUnable to run Simulation", "Warning", 2);
        }
        if (targetService == null) {
            JOptionPane.showMessageDialog(null, "Target System not defined.\nSelect a Target System.\nUnable to run Simulation", "Warning", 2);
            return;
        }
        TransitionSystemImpl[] aServices = new TransitionSystemImpl[availableServices.size()];
        int i = 0;
        while (i < availableServices.size()) {
            aServices[i] = availableServices.get(i);
            ++i;
        }
        long a = System.currentTimeMillis();
        if (selected_orchestrator == ORCHESTRATOR_PLUS) {
            orchestrator = new OrchestratorPlusImpl(targetService, aServices, serviceFactory);
        } else if (selected_orchestrator == ORCHESTRATOR_STANDARD) {
            orchestrator = new OrchestratorStandardImpl(targetService, aServices);
        }
        long b = System.currentTimeMillis();
        System.out.println("time in msec:" + (b - a));
        MainFrame.getInstance().getStateDescriptionPanel().getStartSimulation().setEnabled(false);
        MainFrame.getInstance().getStateDescriptionPanel().getStopSimulation().setEnabled(true);
        MainFrame.getInstance().getStateDescriptionPanel().getActionButton().setEnabled(true);
    }

    public static void stopOrchestrator() {
        orchestrator = null;
        MainFrame.getInstance().getStateDescriptionPanel().getStartSimulation().setEnabled(true);
        MainFrame.getInstance().getStateDescriptionPanel().getStopSimulation().setEnabled(false);
        MainFrame.getInstance().getStateDescriptionPanel().getActionButton().setEnabled(false);
    }

    public static boolean orchestratorIsStarted() {
        return orchestrator != null;
    }

    public static TransitionSystem<ComposedState, ComposedTransition> getCompositionTs() throws Exception {
        if (orchestrator == null) {
            throw new Exception("Orchestrator not started");
        }
        return orchestrator.getCompositionTs();
    }

    public static void doAction(SimpleTransition a) throws Exception {
        if (orchestrator == null) {
            throw new Exception("Orchestrator not started");
        }
        orchestrator.doAction(a);
        jTargetService.executeAction(a);
    }

    public static SimpleState getCurrentTargetState() throws Exception {
        if (orchestrator == null) {
            throw new Exception("Orchestrator not started");
        }
        return orchestrator.getCurrentTargetState();
    }

    public static ComposedState getCurrentAvailableState() throws Exception {
        if (orchestrator == null) {
            throw new Exception("Orchestrator not started");
        }
        return orchestrator.getCurrentServicesState();
    }

    public static TransitionSystem<SimpleState, SimpleTransition> getLastTSExecutedAction() throws Exception {
        if (orchestrator == null) {
            throw new Exception("Orchestrator not started");
        }
        return orchestrator.getLastExecutedAction().getService();
    }

    public static Vector<String[]> getCompositionDataToExport() throws Exception {
        if (orchestrator == null) {
            throw new Exception("Orchestrator not started");
        }
        return orchestrator.getCompositionDataToExport();
    }

    public static Vector<String[]> getSimulationDataToExport() throws Exception {
        if (orchestrator == null) {
            throw new Exception("Orchestrator not started");
        }
        return orchestrator.getSimulationDataToExport();
    }

    public static TransitionSystem<ComposedState, ComposedTransition> getAsyncProduct() throws Exception {
        if (orchestrator == null) {
            throw new Exception("Orchestrator not started");
        }
        return orchestrator.getAsyncProduct();
    }

    private static boolean checkSimulationComputable() {
        return targetService != null && availableServices != null && availableServices.size() > 0;
    }

    private static void activateComputeButton() {
        MainFrame.getInstance().getStateDescriptionPanel().getStartSimulation().setEnabled(true);
    }

    public static void setAvailableServices(Vector<TransitionSystem<SimpleState, SimpleTransition>> ts) {
        if (availableServices == null) {
            availableServices = new Vector<TransitionSystem<SimpleState, SimpleTransition>>(ts);
        } else {
            availableServices.removeAllElements();
            availableServices.addAll(ts);
        }
        if (GenericLoader.checkSimulationComputable()) {
            GenericLoader.activateComputeButton();
        }
    }

    public static Vector<String> getPathAvailableService() {
        return pathAvailableServices;
    }

    public static String getPathTarget() {
        return pathTarget;
    }

    public static void setAvailableServicesPath(Vector<String> pathAvailableServices) {
        if (GenericLoader.pathAvailableServices == null) {
            GenericLoader.pathAvailableServices = new Vector<String>(pathAvailableServices);
        } else {
            int i = 0;
            while (i < pathAvailableServices.size()) {
                GenericLoader.pathAvailableServices.addElement(pathAvailableServices.get(i));
                ++i;
            }
        }
    }

    public static void setTargetServicePath(String absolutePath) {
        pathTarget = absolutePath;
    }

    public static void setAvailableServicesNames(Vector<String> tssNames) {
        availableServicesNames = tssNames;
    }
}

