/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.transform;

import edu.uci.ics.jung.visualization.VisualizationServer;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.ModalGraphMouse;
import edu.uci.ics.jung.visualization.transform.LensSupport;
import edu.uci.ics.jung.visualization.transform.LensTransformer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Ellipse2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLensSupport<V, E>
implements LensSupport {
    protected VisualizationViewer<V, E> vv;
    protected VisualizationViewer.GraphMouse graphMouse;
    protected LensTransformer lensTransformer;
    protected ModalGraphMouse lensGraphMouse;
    protected Lens lens;
    protected LensControls lensControls;
    protected String defaultToolTipText;
    protected static final String instructions = "<html><center>Mouse-Drag the Lens center to move it<p>Mouse-Drag the Lens edge to resize it<p>Ctrl+MouseWheel to change magnification</center></html>";

    public AbstractLensSupport(VisualizationViewer<V, E> vv, ModalGraphMouse lensGraphMouse) {
        this.vv = vv;
        this.graphMouse = vv.getGraphMouse();
        this.defaultToolTipText = vv.getToolTipText();
        this.lensGraphMouse = lensGraphMouse;
    }

    @Override
    public void activate(boolean state) {
        if (state) {
            this.activate();
        } else {
            this.deactivate();
        }
    }

    @Override
    public LensTransformer getLensTransformer() {
        return this.lensTransformer;
    }

    @Override
    public ModalGraphMouse getGraphMouse() {
        return this.lensGraphMouse;
    }

    public Lens getLens() {
        return this.lens;
    }

    public void setLens(Lens lens) {
        this.lens = lens;
    }

    public LensControls getLensControls() {
        return this.lensControls;
    }

    public void setLensControls(LensControls lensControls) {
        this.lensControls = lensControls;
    }

    public static class LensControls
    implements VisualizationServer.Paintable {
        LensTransformer lensTransformer;
        Ellipse2D ellipse;
        Paint paint = Color.gray;

        public LensControls(LensTransformer lensTransformer) {
            this.lensTransformer = lensTransformer;
            this.ellipse = lensTransformer.getEllipse();
        }

        public Paint getPaint() {
            return this.paint;
        }

        public void setPaint(Paint paint) {
            this.paint = paint;
        }

        public void paint(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setPaint(this.paint);
            g2d.draw(this.ellipse);
            int centerX = (int)Math.round(this.ellipse.getCenterX());
            int centerY = (int)Math.round(this.ellipse.getCenterY());
            g.drawOval(centerX - 10, centerY - 10, 20, 20);
        }

        public boolean useTransform() {
            return true;
        }
    }

    public static class Lens
    implements VisualizationServer.Paintable {
        LensTransformer lensTransformer;
        Ellipse2D ellipse;
        Paint paint = Color.decode("0xdddddd");

        public Lens(LensTransformer lensTransformer) {
            this.lensTransformer = lensTransformer;
            this.ellipse = lensTransformer.getEllipse();
        }

        public Paint getPaint() {
            return this.paint;
        }

        public void setPaint(Paint paint) {
            this.paint = paint;
        }

        public void paint(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setPaint(this.paint);
            g2d.fill(this.ellipse);
        }

        public boolean useTransform() {
            return true;
        }
    }
}

