/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.samples;

import edu.uci.ics.jung.algorithms.layout.FRLayout;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.algorithms.layout.StaticLayout;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.SparseGraph;
import edu.uci.ics.jung.graph.util.TestGraphs;
import edu.uci.ics.jung.visualization.DefaultVisualizationModel;
import edu.uci.ics.jung.visualization.GraphZoomScrollPane;
import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.CrossoverScalingControl;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.control.LensMagnificationGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.ModalLensGraphMouse;
import edu.uci.ics.jung.visualization.control.ScalingControl;
import edu.uci.ics.jung.visualization.decorators.PickableEdgePaintTransformer;
import edu.uci.ics.jung.visualization.decorators.PickableVertexPaintTransformer;
import edu.uci.ics.jung.visualization.decorators.ToStringLabeller;
import edu.uci.ics.jung.visualization.picking.PickedState;
import edu.uci.ics.jung.visualization.transform.HyperbolicTransformer;
import edu.uci.ics.jung.visualization.transform.LayoutLensSupport;
import edu.uci.ics.jung.visualization.transform.LensSupport;
import edu.uci.ics.jung.visualization.transform.MagnifyTransformer;
import edu.uci.ics.jung.visualization.transform.shape.HyperbolicShapeTransformer;
import edu.uci.ics.jung.visualization.transform.shape.MagnifyShapeTransformer;
import edu.uci.ics.jung.visualization.transform.shape.ViewLensSupport;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.plaf.basic.BasicLabelUI;
import org.apache.commons.collections15.Transformer;
import org.apache.commons.collections15.TransformerUtils;
import org.apache.commons.collections15.functors.ConstantTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LensDemo
extends JApplet {
    Graph<String, Number> graph = TestGraphs.getOneComponentGraph();
    Layout<String, Number> graphLayout = new FRLayout<String, Number>(this.graph);
    Graph<String, Number> grid;
    Layout<String, Number> gridLayout;
    VisualizationViewer<String, Number> vv;
    LensSupport hyperbolicViewSupport;
    LensSupport magnifyViewSupport;
    LensSupport hyperbolicLayoutSupport;
    LensSupport magnifyLayoutSupport;
    ScalingControl scaler;

    public LensDemo() {
        ((FRLayout)this.graphLayout).setMaxIterations(1000);
        Dimension preferredSize = new Dimension(600, 600);
        HashMap<String, Point2D> map = new HashMap<String, Point2D>();
        Transformer vlf = TransformerUtils.mapTransformer(map);
        this.grid = this.generateVertexGrid(map, preferredSize, 25);
        this.gridLayout = new StaticLayout<String, Number>(this.grid, vlf, preferredSize);
        final DefaultVisualizationModel<String, Number> visualizationModel = new DefaultVisualizationModel<String, Number>(this.graphLayout, preferredSize);
        this.vv = new VisualizationViewer<String, Number>(visualizationModel, preferredSize);
        PickedState ps = this.vv.getPickedVertexState();
        PickedState pes = this.vv.getPickedEdgeState();
        this.vv.getRenderContext().setVertexFillPaintTransformer(new PickableVertexPaintTransformer(ps, Color.red, Color.yellow));
        this.vv.getRenderContext().setEdgeDrawPaintTransformer(new PickableEdgePaintTransformer(pes, Color.black, Color.cyan));
        this.vv.setBackground(Color.white);
        this.vv.getRenderContext().setVertexLabelTransformer(new ToStringLabeller());
        final Transformer ovals = this.vv.getRenderContext().getVertexShapeTransformer();
        final ConstantTransformer<Rectangle2D.Float> squares = new ConstantTransformer<Rectangle2D.Float>(new Rectangle2D.Float(-10.0f, -10.0f, 20.0f, 20.0f));
        this.vv.setVertexToolTipTransformer(new ToStringLabeller());
        Container content = this.getContentPane();
        GraphZoomScrollPane gzsp = new GraphZoomScrollPane(this.vv);
        content.add(gzsp);
        DefaultModalGraphMouse graphMouse = new DefaultModalGraphMouse();
        this.vv.setGraphMouse(graphMouse);
        this.vv.addKeyListener(graphMouse.getModeKeyListener());
        this.hyperbolicViewSupport = new ViewLensSupport<String, Number>(this.vv, new HyperbolicShapeTransformer(this.vv, this.vv.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.VIEW)), new ModalLensGraphMouse());
        this.hyperbolicLayoutSupport = new LayoutLensSupport<String, Number>(this.vv, new HyperbolicTransformer(this.vv, this.vv.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.LAYOUT)), new ModalLensGraphMouse());
        this.magnifyViewSupport = new ViewLensSupport<String, Number>(this.vv, new MagnifyShapeTransformer(this.vv, this.vv.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.VIEW)), new ModalLensGraphMouse(new LensMagnificationGraphMousePlugin(1.0f, 6.0f, 0.2f)));
        this.magnifyLayoutSupport = new LayoutLensSupport<String, Number>(this.vv, new MagnifyTransformer(this.vv, this.vv.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.LAYOUT)), new ModalLensGraphMouse(new LensMagnificationGraphMousePlugin(1.0f, 6.0f, 0.2f)));
        this.hyperbolicLayoutSupport.getLensTransformer().setEllipse(this.hyperbolicViewSupport.getLensTransformer().getEllipse());
        this.magnifyViewSupport.getLensTransformer().setEllipse(this.hyperbolicLayoutSupport.getLensTransformer().getEllipse());
        this.magnifyLayoutSupport.getLensTransformer().setEllipse(this.magnifyViewSupport.getLensTransformer().getEllipse());
        final CrossoverScalingControl scaler = new CrossoverScalingControl();
        JButton plus = new JButton("+");
        plus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                scaler.scale(LensDemo.this.vv, 1.1f, LensDemo.this.vv.getCenter());
            }
        });
        JButton minus = new JButton("-");
        minus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                scaler.scale(LensDemo.this.vv, 0.9090909f, LensDemo.this.vv.getCenter());
            }
        });
        ButtonGroup radio = new ButtonGroup();
        JRadioButton normal = new JRadioButton("None");
        normal.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    if (LensDemo.this.hyperbolicViewSupport != null) {
                        LensDemo.this.hyperbolicViewSupport.deactivate();
                    }
                    if (LensDemo.this.hyperbolicLayoutSupport != null) {
                        LensDemo.this.hyperbolicLayoutSupport.deactivate();
                    }
                    if (LensDemo.this.magnifyViewSupport != null) {
                        LensDemo.this.magnifyViewSupport.deactivate();
                    }
                    if (LensDemo.this.magnifyLayoutSupport != null) {
                        LensDemo.this.magnifyLayoutSupport.deactivate();
                    }
                }
            }
        });
        JRadioButton hyperView = new JRadioButton("Hyperbolic View");
        hyperView.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                LensDemo.this.hyperbolicViewSupport.activate(e.getStateChange() == 1);
            }
        });
        JRadioButton hyperModel = new JRadioButton("Hyperbolic Layout");
        hyperModel.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                LensDemo.this.hyperbolicLayoutSupport.activate(e.getStateChange() == 1);
            }
        });
        JRadioButton magnifyView = new JRadioButton("Magnified View");
        magnifyView.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                LensDemo.this.magnifyViewSupport.activate(e.getStateChange() == 1);
            }
        });
        JRadioButton magnifyModel = new JRadioButton("Magnified Layout");
        magnifyModel.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                LensDemo.this.magnifyLayoutSupport.activate(e.getStateChange() == 1);
            }
        });
        JLabel modeLabel = new JLabel("     Mode Menu >>");
        modeLabel.setUI(new VerticalLabelUI(false));
        radio.add(normal);
        radio.add(hyperModel);
        radio.add(hyperView);
        radio.add(magnifyModel);
        radio.add(magnifyView);
        normal.setSelected(true);
        graphMouse.addItemListener(this.hyperbolicLayoutSupport.getGraphMouse().getModeListener());
        graphMouse.addItemListener(this.hyperbolicViewSupport.getGraphMouse().getModeListener());
        graphMouse.addItemListener(this.magnifyLayoutSupport.getGraphMouse().getModeListener());
        graphMouse.addItemListener(this.magnifyViewSupport.getGraphMouse().getModeListener());
        ButtonGroup graphRadio = new ButtonGroup();
        JRadioButton graphButton = new JRadioButton("Graph");
        graphButton.setSelected(true);
        graphButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    visualizationModel.setGraphLayout(LensDemo.this.graphLayout);
                    LensDemo.this.vv.getRenderContext().setVertexShapeTransformer(ovals);
                    LensDemo.this.vv.getRenderContext().setVertexLabelTransformer(new ToStringLabeller());
                    LensDemo.this.vv.repaint();
                }
            }
        });
        JRadioButton gridButton = new JRadioButton("Grid");
        gridButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    visualizationModel.setGraphLayout(LensDemo.this.gridLayout);
                    LensDemo.this.vv.getRenderContext().setVertexShapeTransformer(squares);
                    LensDemo.this.vv.getRenderContext().setVertexLabelTransformer(new ConstantTransformer<Object>(null));
                    LensDemo.this.vv.repaint();
                }
            }
        });
        graphRadio.add(graphButton);
        graphRadio.add(gridButton);
        JPanel modePanel = new JPanel(new GridLayout(3, 1));
        modePanel.setBorder(BorderFactory.createTitledBorder("Display"));
        modePanel.add(graphButton);
        modePanel.add(gridButton);
        JMenuBar menubar = new JMenuBar();
        menubar.add(graphMouse.getModeMenu());
        gzsp.setCorner(menubar);
        Box controls = Box.createHorizontalBox();
        JPanel zoomControls = new JPanel(new GridLayout(2, 1));
        zoomControls.setBorder(BorderFactory.createTitledBorder("Zoom"));
        JPanel hyperControls = new JPanel(new GridLayout(3, 2));
        hyperControls.setBorder(BorderFactory.createTitledBorder("Examiner Lens"));
        zoomControls.add(plus);
        zoomControls.add(minus);
        hyperControls.add(normal);
        hyperControls.add(new JLabel());
        hyperControls.add(hyperModel);
        hyperControls.add(magnifyModel);
        hyperControls.add(hyperView);
        hyperControls.add(magnifyView);
        controls.add(zoomControls);
        controls.add(hyperControls);
        controls.add(modePanel);
        controls.add(modeLabel);
        content.add((Component)controls, "South");
    }

    private Graph<String, Number> generateVertexGrid(Map<String, Point2D> vlf, Dimension d, int interval) {
        int count = d.width / interval * d.height / interval;
        SparseGraph<String, Number> graph = new SparseGraph<String, Number>();
        for (int i = 0; i < count; ++i) {
            int x = interval * i;
            int y = x / d.width * interval;
            Point2D.Float location = new Point2D.Float(x %= d.width, y);
            String vertex = "v" + i;
            vlf.put(vertex, location);
            graph.addVertex(vertex);
        }
        return graph;
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        f.getContentPane().add(new LensDemo());
        f.pack();
        f.setVisible(true);
    }

    static class VerticalLabelUI
    extends BasicLabelUI {
        protected boolean clockwise;
        private static Rectangle paintIconR;
        private static Rectangle paintTextR;
        private static Rectangle paintViewR;
        private static Insets paintViewInsets;

        VerticalLabelUI(boolean clockwise) {
            this.clockwise = clockwise;
        }

        public Dimension getPreferredSize(JComponent c) {
            Dimension dim = super.getPreferredSize(c);
            return new Dimension(dim.height, dim.width);
        }

        public void paint(Graphics g, JComponent c) {
            Icon icon;
            JLabel label = (JLabel)c;
            String text = label.getText();
            Icon icon2 = icon = label.isEnabled() ? label.getIcon() : label.getDisabledIcon();
            if (icon == null && text == null) {
                return;
            }
            FontMetrics fm = g.getFontMetrics();
            paintViewInsets = c.getInsets(paintViewInsets);
            VerticalLabelUI.paintViewR.x = VerticalLabelUI.paintViewInsets.left;
            VerticalLabelUI.paintViewR.y = VerticalLabelUI.paintViewInsets.top;
            VerticalLabelUI.paintViewR.height = c.getWidth() - (VerticalLabelUI.paintViewInsets.left + VerticalLabelUI.paintViewInsets.right);
            VerticalLabelUI.paintViewR.width = c.getHeight() - (VerticalLabelUI.paintViewInsets.top + VerticalLabelUI.paintViewInsets.bottom);
            VerticalLabelUI.paintIconR.height = 0;
            VerticalLabelUI.paintIconR.width = 0;
            VerticalLabelUI.paintIconR.y = 0;
            VerticalLabelUI.paintIconR.x = 0;
            VerticalLabelUI.paintTextR.height = 0;
            VerticalLabelUI.paintTextR.width = 0;
            VerticalLabelUI.paintTextR.y = 0;
            VerticalLabelUI.paintTextR.x = 0;
            String clippedText = this.layoutCL(label, fm, text, icon, paintViewR, paintIconR, paintTextR);
            Graphics2D g2 = (Graphics2D)g;
            AffineTransform tr = g2.getTransform();
            if (this.clockwise) {
                g2.rotate(1.5707963267948966);
                g2.translate(0, -c.getWidth());
            } else {
                g2.rotate(-1.5707963267948966);
                g2.translate(-c.getHeight(), 0);
            }
            if (icon != null) {
                icon.paintIcon(c, g, VerticalLabelUI.paintIconR.x, VerticalLabelUI.paintIconR.y);
            }
            if (text != null) {
                int textX = VerticalLabelUI.paintTextR.x;
                int textY = VerticalLabelUI.paintTextR.y + fm.getAscent();
                if (label.isEnabled()) {
                    this.paintEnabledText(label, g, clippedText, textX, textY);
                } else {
                    this.paintDisabledText(label, g, clippedText, textX, textY);
                }
            }
            g2.setTransform(tr);
        }

        static {
            labelUI = new VerticalLabelUI(false);
            paintIconR = new Rectangle();
            paintTextR = new Rectangle();
            paintViewR = new Rectangle();
            paintViewInsets = new Insets(0, 0, 0, 0);
        }
    }
}

