/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.io;

import cern.colt.list.DoubleArrayList;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.SparseDoubleMatrix2D;
import corejava.Format;
import edu.uci.ics.jung.algorithms.matrix.GraphMatrixOperations;
import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.UndirectedGraph;
import edu.uci.ics.jung.io.GraphFile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.collections15.Factory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatrixFile<V, E>
implements GraphFile<V, E> {
    private Map<E, Number> mWeightKey;
    Factory<UndirectedGraph<V, E>> undirectedGraphFactory;
    Factory<DirectedGraph<V, E>> directedGraphFactory;
    Factory<V> vertexFactory;
    Factory<E> edgeFactory;

    public MatrixFile(Map<E, Number> weightKey, Factory<UndirectedGraph<V, E>> undirectedGraphFactory, Factory<DirectedGraph<V, E>> directedGraphFactory, Factory<V> vertexFactory, Factory<E> edgeFactory) {
        this.mWeightKey = weightKey;
        this.undirectedGraphFactory = undirectedGraphFactory;
        this.directedGraphFactory = directedGraphFactory;
        this.vertexFactory = vertexFactory;
        this.edgeFactory = edgeFactory;
    }

    public Graph<V, E> load(BufferedReader reader) {
        Graph<V, E> graph = null;
        try {
            DoubleMatrix2D matrix = this.createMatrixFromFile(reader);
            graph = GraphMatrixOperations.matrixToGraph(matrix, this.undirectedGraphFactory, this.directedGraphFactory, this.vertexFactory, this.edgeFactory, this.mWeightKey);
        }
        catch (Exception e) {
            throw new RuntimeException("Fatal exception calling MatrixFile.load(...)", e);
        }
        return graph;
    }

    private DoubleMatrix2D createMatrixFromFile(BufferedReader reader) throws IOException, ParseException {
        StringTokenizer tokenizer;
        ArrayList<DoubleArrayList> rows = new ArrayList<DoubleArrayList>();
        String currentLine = null;
        while ((currentLine = reader.readLine()) != null && (tokenizer = new StringTokenizer(currentLine)).countTokens() != 0) {
            DoubleArrayList currentRow = new DoubleArrayList();
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                currentRow.add(Double.parseDouble(token));
            }
            rows.add(currentRow);
        }
        int size = rows.size();
        SparseDoubleMatrix2D matrix = new SparseDoubleMatrix2D(size, size);
        for (int i = 0; i < size; ++i) {
            DoubleArrayList currentRow = (DoubleArrayList)rows.get(i);
            if (currentRow.size() != size) {
                throw new ParseException("Matrix must have the same number of rows as columns", 0);
            }
            for (int j = 0; j < size; ++j) {
                double currentVal = currentRow.get(j);
                if (currentVal == 0.0) continue;
                ((DoubleMatrix2D)matrix).setQuick(i, j, currentVal);
            }
        }
        return matrix;
    }

    @Override
    public Graph<V, E> load(String filename) {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(filename));
            Graph<V, E> graph = this.load(reader);
            reader.close();
            return graph;
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error in loading file " + filename, ioe);
        }
    }

    @Override
    public void save(Graph<V, E> graph, String filename) {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(filename));
            SparseDoubleMatrix2D matrix = GraphMatrixOperations.graphToSparseMatrix(graph, this.mWeightKey);
            Format labelFormat = new Format("%4.2f");
            for (int i = 0; i < matrix.rows(); ++i) {
                for (int j = 0; j < matrix.columns(); ++j) {
                    writer.write(labelFormat.format(((DoubleMatrix2D)matrix).getQuick(i, j)) + " ");
                }
                writer.write("\n");
            }
            writer.close();
        }
        catch (Exception e) {
            throw new RuntimeException("Error saving file: " + filename, e);
        }
    }
}

