/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph;

import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.graph.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import junit.framework.TestCase;
import org.apache.commons.collections15.Factory;

public abstract class AbstractSortedSparseMultigraphTest
extends TestCase {
    protected Integer v0 = 0;
    protected Integer v1 = 1;
    protected Integer v2 = 2;
    protected Number e01 = 0.1;
    protected Number e10 = 0.2;
    protected Number e12 = 0.3;
    protected Number e21 = 0.4;
    protected Factory<Number> vertexFactory = new Factory<Number>(){
        int v = 0;

        @Override
        public Number create() {
            return this.v++;
        }
    };
    protected Factory<Number> edgeFactory = new Factory<Number>(){
        int e = 0;

        @Override
        public Number create() {
            return this.e++;
        }
    };
    protected Graph<Number, Number> graph;
    protected int vertexCount = 50;
    protected Graph<Integer, Number> smallGraph;

    public void testGetEdges() {
        AbstractSortedSparseMultigraphTest.assertEquals((int)this.smallGraph.getEdgeCount(), (int)4);
    }

    public void testGetVertices() {
        AbstractSortedSparseMultigraphTest.assertEquals((int)this.smallGraph.getVertexCount(), (int)3);
    }

    public void testAddVertex() {
        int count = this.graph.getVertexCount();
        this.graph.addVertex(count);
        AbstractSortedSparseMultigraphTest.assertEquals((int)this.graph.getVertexCount(), (int)(count + 1));
    }

    public void testRemoveEndVertex() {
        int vertexCount = this.graph.getVertexCount();
        int edgeCount = this.graph.getEdgeCount();
        Collection incident = this.graph.getIncidentEdges(vertexCount - 1);
        this.graph.removeVertex(vertexCount - 1);
        AbstractSortedSparseMultigraphTest.assertEquals((int)(vertexCount - 1), (int)this.graph.getVertexCount());
        AbstractSortedSparseMultigraphTest.assertEquals((int)(edgeCount - incident.size()), (int)this.graph.getEdgeCount());
    }

    public void testRemoveMiddleVertex() {
        int vertexCount = this.graph.getVertexCount();
        int edgeCount = this.graph.getEdgeCount();
        Collection incident = this.graph.getIncidentEdges(vertexCount / 2);
        this.graph.removeVertex(vertexCount / 2);
        AbstractSortedSparseMultigraphTest.assertEquals((int)(vertexCount - 1), (int)this.graph.getVertexCount());
        AbstractSortedSparseMultigraphTest.assertEquals((int)(edgeCount - incident.size()), (int)this.graph.getEdgeCount());
    }

    public void testAddEdge() {
        int edgeCount = this.graph.getEdgeCount();
        this.graph.addEdge(this.edgeFactory.create(), 0, 1);
        AbstractSortedSparseMultigraphTest.assertEquals((int)this.graph.getEdgeCount(), (int)(edgeCount + 1));
    }

    public void testNullEndpoint() {
        try {
            this.graph.addEdge(this.edgeFactory.create(), new Pair<Object>(1, null));
            AbstractSortedSparseMultigraphTest.fail((String)"should not be able to add an edge with a null endpoint");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testRemoveEdge() {
        ArrayList edgeList = new ArrayList(this.graph.getEdges());
        int edgeCount = this.graph.getEdgeCount();
        this.graph.removeEdge((Number)edgeList.get(edgeList.size() / 2));
        AbstractSortedSparseMultigraphTest.assertEquals((int)this.graph.getEdgeCount(), (int)(edgeCount - 1));
    }

    public void testGetInOutEdges() {
        for (Number v : this.graph.getVertices()) {
            Collection incident = this.graph.getIncidentEdges(v);
            Collection<Number> in = this.graph.getInEdges(v);
            Collection<Number> out = this.graph.getOutEdges(v);
            AbstractSortedSparseMultigraphTest.assertTrue((boolean)incident.containsAll(in));
            AbstractSortedSparseMultigraphTest.assertTrue((boolean)incident.containsAll(out));
            for (Number e : in) {
                if (!out.contains(e)) continue;
                AbstractSortedSparseMultigraphTest.assertTrue((this.graph.getEdgeType(e) == EdgeType.UNDIRECTED ? 1 : 0) != 0);
            }
            for (Number e : out) {
                if (!in.contains(e)) continue;
                AbstractSortedSparseMultigraphTest.assertTrue((this.graph.getEdgeType(e) == EdgeType.UNDIRECTED ? 1 : 0) != 0);
            }
        }
        AbstractSortedSparseMultigraphTest.assertEquals((int)this.smallGraph.getInEdges(this.v1).size(), (int)4);
        AbstractSortedSparseMultigraphTest.assertEquals((int)this.smallGraph.getOutEdges(this.v1).size(), (int)3);
        AbstractSortedSparseMultigraphTest.assertEquals((int)this.smallGraph.getOutEdges(this.v0).size(), (int)2);
    }

    public void testGetPredecessors() {
        AbstractSortedSparseMultigraphTest.assertTrue((boolean)this.smallGraph.getPredecessors(this.v0).containsAll(Collections.singleton(this.v1)));
    }

    public void testGetSuccessors() {
        AbstractSortedSparseMultigraphTest.assertTrue((boolean)this.smallGraph.getPredecessors(this.v1).contains(this.v0));
        AbstractSortedSparseMultigraphTest.assertTrue((boolean)this.smallGraph.getPredecessors(this.v1).contains(this.v2));
    }

    public void testGetNeighbors() {
        Collection<Integer> neighbors = this.smallGraph.getNeighbors(this.v1);
        AbstractSortedSparseMultigraphTest.assertTrue((boolean)neighbors.contains(this.v0));
        AbstractSortedSparseMultigraphTest.assertTrue((boolean)neighbors.contains(this.v2));
    }

    public void testGetIncidentEdges() {
        AbstractSortedSparseMultigraphTest.assertEquals((int)this.smallGraph.getIncidentEdges(this.v0).size(), (int)2);
    }

    public void testFindEdge() {
        Number edge = (Number)this.smallGraph.findEdge(this.v1, this.v2);
        AbstractSortedSparseMultigraphTest.assertTrue((edge == this.e12 || edge == this.e21 ? 1 : 0) != 0);
    }

    public void testGetEndpoints() {
        Pair<Integer> endpoints = this.smallGraph.getEndpoints(this.e01);
        AbstractSortedSparseMultigraphTest.assertTrue((endpoints.getFirst() == this.v0 && endpoints.getSecond() == this.v1 || endpoints.getFirst() == this.v1 && endpoints.getSecond() == this.v0 ? 1 : 0) != 0);
    }

    public void testIsDirected() {
        for (Number edge : this.smallGraph.getEdges()) {
            if (edge == this.e21) {
                AbstractSortedSparseMultigraphTest.assertEquals((Object)((Object)this.smallGraph.getEdgeType(edge)), (Object)((Object)EdgeType.DIRECTED));
                continue;
            }
            AbstractSortedSparseMultigraphTest.assertEquals((Object)((Object)this.smallGraph.getEdgeType(edge)), (Object)((Object)EdgeType.UNDIRECTED));
        }
    }

    public static class Bar {
    }

    public static class Foo {
    }
}

