/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.layout;

import edu.uci.ics.jung.algorithms.layout.AbstractLayout;
import edu.uci.ics.jung.graph.Graph;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections15.Factory;
import org.apache.commons.collections15.map.LazyMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CircleLayout<V, E>
extends AbstractLayout<V, E> {
    private double radius;
    Map<V, CircleVertexData> circleVertexDataMap = LazyMap.decorate(new HashMap(), new Factory<CircleVertexData>(){

        @Override
        public CircleVertexData create() {
            return new CircleVertexData();
        }
    });

    public CircleLayout(Graph<V, E> g) {
        super(g);
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    public void orderVertices(V[] vertices) {
        List<V> list = Arrays.asList(vertices);
        Collections.shuffle(list);
    }

    @Override
    public void reset() {
        this.initialize();
    }

    @Override
    public void initialize() {
        Graph graph = this.getGraph();
        Dimension d = this.getSize();
        if (graph != null && d != null) {
            Object[] vertices = graph.getVertices().toArray();
            this.orderVertices(vertices);
            double height = d.getHeight();
            double width = d.getWidth();
            if (this.radius <= 0.0) {
                this.radius = 0.45 * (height < width ? height : width);
            }
            for (int i = 0; i < vertices.length; ++i) {
                Object coord = this.transform(vertices[i]);
                double angle = Math.PI * 2 * (double)i / (double)vertices.length;
                ((Point2D)coord).setLocation(Math.cos(angle) * this.radius + width / 2.0, Math.sin(angle) * this.radius + height / 2.0);
                CircleVertexData data = this.getCircleData(vertices[i]);
                data.setAngle(angle);
            }
        }
    }

    public CircleVertexData getCircleData(V v) {
        return this.circleVertexDataMap.get(v);
    }

    public static class CircleVertexData {
        private double angle;

        public double getAngle() {
            return this.angle;
        }

        public void setAngle(double angle) {
            this.angle = angle;
        }

        public String toString() {
            return "CircleVertexData: angle=" + this.angle;
        }
    }
}

