/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.importance;

import edu.uci.ics.jung.algorithms.importance.PageRank;
import edu.uci.ics.jung.algorithms.shortestpath.BFSDistanceLabeler;
import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.Pair;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageRankWithPriors<V, E>
extends PageRank<V, E> {
    public PageRankWithPriors(DirectedGraph<V, E> graph, double beta, Set<V> priors, Map<E, Number> edgeWeights) {
        super(graph, beta, edgeWeights, PageRankWithPriors.computeReachableVertices(graph, priors));
        this.setPriors(priors);
        this.initializePriorWeights();
    }

    protected void initializePriorWeights() {
        Collection allVertices = this.getVertices();
        Set priors = this.getPriors();
        double numPriors = priors.size();
        HashSet nonPriors = new HashSet();
        nonPriors.addAll(allVertices);
        nonPriors.removeAll(priors);
        for (Object currentVertex : nonPriors) {
            this.setPriorRankScore(currentVertex, 0.0);
        }
        for (Object currentVertex : this.getPriors()) {
            this.setPriorRankScore(currentVertex, 1.0 / numPriors);
        }
    }

    private static <V, E> Pair<Set<V>> computeReachableVertices(Graph<V, E> g, Set<V> priors) {
        BFSDistanceLabeler<Set<V>, E> labeler = new BFSDistanceLabeler<Set<V>, E>();
        labeler.labelDistances((Graph<Set<V>, E>)g, priors);
        labeler.removeDecorations(g);
        Pair<Set<V>> p = new Pair<Set<V>>(new HashSet(labeler.getVerticesInOrderVisited()), new HashSet(labeler.getUnvisitedVertices()));
        return p;
    }

    @Override
    public void reset() {
        super.reset();
        this.initializePriorWeights();
    }
}

