/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.cluster;

import edu.uci.ics.jung.algorithms.cluster.WeakComponentClusterer;
import edu.uci.ics.jung.algorithms.importance.BetweennessCentrality;
import edu.uci.ics.jung.algorithms.importance.Ranking;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections15.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EdgeBetweennessClusterer<V, E>
implements Transformer<Graph<V, E>, Set<Set<V>>> {
    private int mNumEdgesToRemove;
    private List<E> mEdgesRemoved;

    public EdgeBetweennessClusterer(int numEdgesToRemove) {
        this.mNumEdgesToRemove = numEdgesToRemove;
        this.mEdgesRemoved = new ArrayList();
    }

    @Override
    public Set<Set<V>> transform(Graph<V, E> graph) {
        if (this.mNumEdgesToRemove < 0 || this.mNumEdgesToRemove > graph.getEdgeCount()) {
            throw new IllegalArgumentException("Invalid number of edges passed in.");
        }
        HashMap removedEdges = new HashMap();
        this.mEdgesRemoved.clear();
        for (int k = 0; k < this.mNumEdgesToRemove; ++k) {
            BetweennessCentrality<V, E> bc = new BetweennessCentrality<V, E>(graph, false);
            bc.setRemoveRankScoresOnFinalize(true);
            bc.evaluate();
            Ranking<?> highestBetweenness = bc.getRankings().get(0);
            Object removedEdge = highestBetweenness.getRanked();
            Pair<V> removedEdgeEndpoints = graph.getEndpoints(removedEdge);
            removedEdges.put(removedEdge, removedEdgeEndpoints);
            this.mEdgesRemoved.add(highestBetweenness.getRanked());
            graph.removeEdge(highestBetweenness.getRanked());
        }
        WeakComponentClusterer wcSearch = new WeakComponentClusterer();
        Set clusterSet = wcSearch.transform(graph);
        for (E edge : this.mEdgesRemoved) {
            Pair endpoints = (Pair)removedEdges.get(edge);
            graph.addEdge(edge, endpoints.getFirst(), endpoints.getSecond());
        }
        return clusterSet;
    }

    public List<E> getEdgesRemoved() {
        return this.mEdgesRemoved;
    }
}

