/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.jai;

import edu.uci.ics.jung.algorithms.layout.GraphElementAccessor;
import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.VisualizationServer;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.ModalGraphMouse;
import edu.uci.ics.jung.visualization.control.ModalLensGraphMouse;
import edu.uci.ics.jung.visualization.jai.TransformingImageVertexIconRenderer;
import edu.uci.ics.jung.visualization.picking.ViewLensShapePickSupport;
import edu.uci.ics.jung.visualization.renderers.BasicRenderer;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import edu.uci.ics.jung.visualization.renderers.ReshapingEdgeRenderer;
import edu.uci.ics.jung.visualization.transform.AbstractLensSupport;
import edu.uci.ics.jung.visualization.transform.BidirectionalTransformer;
import edu.uci.ics.jung.visualization.transform.LensTransformer;
import edu.uci.ics.jung.visualization.transform.MutableTransformer;
import edu.uci.ics.jung.visualization.transform.shape.GraphicsDecorator;
import edu.uci.ics.jung.visualization.transform.shape.HyperbolicShapeTransformer;
import edu.uci.ics.jung.visualization.transform.shape.TransformingFlatnessGraphics;
import java.awt.Dimension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HyperbolicImageLensSupport<V, E>
extends AbstractLensSupport<V, E> {
    protected RenderContext<V, E> renderContext;
    protected GraphicsDecorator lensGraphicsDecorator;
    protected GraphicsDecorator savedGraphicsDecorator;
    protected Renderer<V, E> renderer;
    protected Renderer<V, E> transformingRenderer;
    protected GraphElementAccessor<V, E> pickSupport;
    protected Renderer.Edge savedEdgeRenderer;
    protected Renderer.Edge reshapingEdgeRenderer;
    static final String instructions = "<html><center>Mouse-Drag the Lens center to move it<p>Mouse-Drag the Lens edge to resize it<p>Ctrl+MouseWheel to change magnification</center></html>";

    public HyperbolicImageLensSupport(VisualizationViewer<V, E> vv) {
        this(vv, (LensTransformer)new HyperbolicShapeTransformer(vv), (ModalGraphMouse)new ModalLensGraphMouse());
    }

    public HyperbolicImageLensSupport(VisualizationViewer<V, E> vv, LensTransformer lensTransformer, ModalGraphMouse lensGraphMouse) {
        super(vv, lensGraphMouse);
        this.renderContext = vv.getRenderContext();
        this.pickSupport = this.renderContext.getPickSupport();
        this.renderer = vv.getRenderer();
        this.transformingRenderer = new BasicRenderer();
        this.transformingRenderer.setVertexRenderer(new TransformingImageVertexIconRenderer());
        this.savedGraphicsDecorator = this.renderContext.getGraphicsContext();
        this.lensTransformer = lensTransformer;
        this.savedEdgeRenderer = vv.getRenderer().getEdgeRenderer();
        this.reshapingEdgeRenderer = new ReshapingEdgeRenderer();
        Dimension d = vv.getSize();
        lensTransformer.setViewRadius((double)(d.width / 5));
        this.lensGraphicsDecorator = new TransformingFlatnessGraphics((BidirectionalTransformer)lensTransformer);
    }

    public void activate() {
        this.lensTransformer.setDelegate(this.vv.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.VIEW));
        if (this.lens == null) {
            this.lens = new AbstractLensSupport.Lens(this.lensTransformer);
        }
        if (this.lensControls == null) {
            this.lensControls = new AbstractLensSupport.LensControls(this.lensTransformer);
        }
        this.renderContext.setPickSupport((GraphElementAccessor)new ViewLensShapePickSupport((VisualizationServer)this.vv));
        this.lensTransformer.setDelegate(this.vv.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.VIEW));
        this.vv.getRenderContext().getMultiLayerTransformer().setTransformer(Layer.VIEW, (MutableTransformer)this.lensTransformer);
        this.renderContext.setGraphicsContext(this.lensGraphicsDecorator);
        this.vv.setRenderer(this.transformingRenderer);
        this.vv.getRenderer().setEdgeRenderer(this.reshapingEdgeRenderer);
        this.vv.addPreRenderPaintable((VisualizationServer.Paintable)this.lens);
        this.vv.addPostRenderPaintable((VisualizationServer.Paintable)this.lensControls);
        this.vv.setGraphMouse((VisualizationViewer.GraphMouse)this.lensGraphMouse);
        this.vv.setToolTipText(instructions);
        this.vv.repaint();
    }

    public void deactivate() {
        this.renderContext.setPickSupport(this.pickSupport);
        this.vv.getRenderContext().getMultiLayerTransformer().setTransformer(Layer.VIEW, this.lensTransformer.getDelegate());
        this.vv.removePreRenderPaintable((VisualizationServer.Paintable)this.lens);
        this.vv.removePostRenderPaintable((VisualizationServer.Paintable)this.lensControls);
        this.renderContext.setGraphicsContext(this.savedGraphicsDecorator);
        this.vv.setRenderer(this.renderer);
        this.vv.setToolTipText(this.defaultToolTipText);
        this.vv.setGraphMouse(this.graphMouse);
        this.vv.repaint();
    }
}

