/*
 * Decompiled with CFR 0.152.
 */
package com.jgraph.layout.orthogonal;

import com.jgraph.layout.orthogonal.DirectionUtils;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

final class OrthogonalLinkRouterRegion
extends Rectangle {
    public static final int MIN_INT_REGION = -20000;
    public static final int MAX_INT_REGION = 20000;
    private int direction;
    private boolean horizontal;
    private int depth;

    public OrthogonalLinkRouterRegion(double d, double d2, int n, int n2, int n3, int n4) {
        super((int)d, (int)d2, n, n2);
        this.direction = n3;
        switch (n3) {
            case 1: 
            case 2: {
                this.horizontal = true;
                break;
            }
            case 4: 
            case 8: {
                this.horizontal = false;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.depth = n4;
    }

    public int getDirection() {
        return this.direction;
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }

    public int getDepth() {
        return this.depth;
    }

    public void extendToInfinity() {
        switch (this.direction) {
            case 1: {
                this.width = this.x - -20000;
                this.x = -20000;
                break;
            }
            case 2: {
                this.width = 20000 - this.x;
                break;
            }
            case 4: {
                this.height = this.y - -20000;
                this.y = -20000;
                break;
            }
            case 8: {
                this.height = 20000 - this.y;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public double compareImportant(Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        boolean bl = false;
        double d = rectangle2D.getX();
        double d2 = rectangle2D.getY();
        double d3 = rectangle2D.getWidth();
        double d4 = rectangle2D.getHeight();
        if (this.isEmpty() || d3 <= 0.0 || d4 <= 0.0) {
            bl = false;
        } else {
            double d5 = this.getX();
            double d6 = this.getY();
            boolean bl2 = bl = d + d3 > d5 && d2 + d4 > d6 && d < d5 + this.getWidth() && d2 < d6 + this.getHeight();
        }
        if (!bl) {
            return 2.147483647E9;
        }
        if (rectangle2D2 == null) {
            return -2.147483648E9;
        }
        switch (this.direction) {
            case 1: {
                return rectangle2D2.getX() + rectangle2D2.getWidth() - (d + d3);
            }
            case 2: {
                return d - rectangle2D2.getX();
            }
            case 4: {
                return rectangle2D2.getY() + rectangle2D2.getHeight() - (d2 + d4);
            }
            case 8: {
                return d2 - rectangle2D2.getY();
            }
        }
        throw new IllegalArgumentException();
    }

    private void parseIntervalsBy(ArrayList arrayList, Rectangle2D rectangle2D) {
        int n;
        int n2;
        if (this.horizontal) {
            n2 = (int)rectangle2D.getY();
            n = (int)(rectangle2D.getY() + rectangle2D.getHeight());
        } else {
            n2 = (int)rectangle2D.getX();
            n = (int)(rectangle2D.getX() + rectangle2D.getWidth());
        }
        int n3 = 0;
        while (n3 < arrayList.size()) {
            int n4;
            int n5;
            int n6;
            OrthogonalLinkRouterRegion orthogonalLinkRouterRegion = (OrthogonalLinkRouterRegion)arrayList.get(n3);
            if (this.horizontal) {
                n6 = orthogonalLinkRouterRegion.y;
                n5 = orthogonalLinkRouterRegion.y + orthogonalLinkRouterRegion.height;
            } else {
                n6 = orthogonalLinkRouterRegion.x;
                n5 = orthogonalLinkRouterRegion.x + orthogonalLinkRouterRegion.width;
            }
            if (n <= n6 || n2 >= n5) {
                ++n3;
                continue;
            }
            if (n2 <= n6 && n >= n5) {
                arrayList.remove(n3);
                continue;
            }
            if (n2 > n6 && n < n5) {
                OrthogonalLinkRouterRegion orthogonalLinkRouterRegion2 = orthogonalLinkRouterRegion.cloneExactly();
                int n7 = n2 - n6;
                int n8 = n5 - n;
                if (this.horizontal) {
                    orthogonalLinkRouterRegion.height = n7;
                    orthogonalLinkRouterRegion2.y = n5 - n8;
                    orthogonalLinkRouterRegion2.height = n8;
                    arrayList.add(n3 + 1, orthogonalLinkRouterRegion2);
                } else {
                    orthogonalLinkRouterRegion.width = n7;
                    orthogonalLinkRouterRegion2.x = n5 - n8;
                    orthogonalLinkRouterRegion2.width = n8;
                    arrayList.add(n3 + 1, orthogonalLinkRouterRegion2);
                }
                return;
            }
            if (n2 <= n6 && n > n6 && n < n5) {
                n4 = n - n6;
                if (this.horizontal) {
                    orthogonalLinkRouterRegion.y += n4;
                    orthogonalLinkRouterRegion.height -= n4;
                } else {
                    orthogonalLinkRouterRegion.x += n4;
                    orthogonalLinkRouterRegion.width -= n4;
                }
                ++n3;
                continue;
            }
            if (n >= n5 && n2 > n6 && n2 < n5) {
                n4 = n5 - n2;
                if (this.horizontal) {
                    orthogonalLinkRouterRegion.height -= n4;
                } else {
                    orthogonalLinkRouterRegion.width -= n4;
                }
                ++n3;
                continue;
            }
            throw new IllegalStateException();
        }
    }

    public OrthogonalLinkRouterRegion cloneExactly() {
        return new OrthogonalLinkRouterRegion(this.x, this.y, this.width, this.height, this.direction, this.depth);
    }

    public ArrayList parseSubRegions(Collection collection) {
        Cloneable cloneable;
        ArrayList<Cloneable> arrayList = new ArrayList<Cloneable>();
        Iterator iterator = collection.iterator();
        Cloneable cloneable2 = null;
        while (iterator.hasNext()) {
            cloneable = (Rectangle2D)iterator.next();
            double d = this.compareImportant((Rectangle2D)cloneable, (Rectangle2D)cloneable2);
            if (!(d <= 0.0)) continue;
            if (d < 0.0) {
                arrayList.clear();
                cloneable2 = cloneable;
            }
            arrayList.add(cloneable);
        }
        cloneable = new ArrayList();
        if (arrayList.size() > 0) {
            this.cutLengthBy((Rectangle2D)cloneable2);
            ((ArrayList)cloneable).add(this.cloneWithForwardEdge());
            for (int i = 0; i < arrayList.size(); ++i) {
                Rectangle2D rectangle2D = (Rectangle2D)arrayList.get(i);
                this.parseIntervalsBy((ArrayList)cloneable, rectangle2D);
            }
        }
        return cloneable;
    }

    public OrthogonalLinkRouterRegion cloneWithForwardEdge() {
        return this.cloneWithEdge(this.direction, this.depth);
    }

    public OrthogonalLinkRouterRegion cloneWithCounterClockwiseEdge() {
        return this.cloneWithEdge(DirectionUtils.getCounterClockWiseDirection(this.direction), this.depth + 1);
    }

    public OrthogonalLinkRouterRegion cloneWithClockwiseEdge() {
        return this.cloneWithEdge(DirectionUtils.getClockWiseDirection(this.direction), this.depth + 1);
    }

    private OrthogonalLinkRouterRegion cloneWithEdge(int n, int n2) {
        switch (n) {
            case 1: {
                return new OrthogonalLinkRouterRegion(this.x, this.y, 0, this.height, n, n2);
            }
            case 2: {
                return new OrthogonalLinkRouterRegion(this.x + this.width, this.y, 0, this.height, n, n2);
            }
            case 4: {
                return new OrthogonalLinkRouterRegion(this.x, this.y, this.width, 0, n, n2);
            }
            case 8: {
                return new OrthogonalLinkRouterRegion(this.x, this.y + this.height, this.width, 0, n, n2);
            }
        }
        throw new IllegalArgumentException();
    }

    private void cutLengthBy(Rectangle2D rectangle2D) {
        switch (this.direction) {
            case 1: {
                double d = rectangle2D.getX() + rectangle2D.getWidth();
                int n = this.x;
                if (d > (double)(this.x + this.width)) {
                    this.x += this.width;
                    this.width = 0;
                    break;
                }
                if (!(d > (double)n)) break;
                this.width = (int)((double)(this.x + this.width) - d);
                this.x = (int)d;
                break;
            }
            case 2: {
                double d = rectangle2D.getX();
                int n = this.x + this.width;
                if (d < (double)this.x) {
                    this.width = 0;
                    break;
                }
                if (!(d < (double)n)) break;
                this.width = (int)(d - (double)this.x);
                break;
            }
            case 4: {
                int n = (int)(rectangle2D.getY() + rectangle2D.getHeight());
                int n2 = this.y;
                if (n > this.y + this.height) {
                    this.y += this.height;
                    this.height = 0;
                    break;
                }
                if (n <= n2) break;
                this.height = this.y + this.height - n;
                this.y = n;
                break;
            }
            case 8: {
                int n = (int)rectangle2D.getY();
                int n3 = this.y + this.height;
                if (n < this.y) {
                    this.height = 0;
                    break;
                }
                if (n >= n3) break;
                this.height = n - this.y;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public boolean containsInsideEdges(Point2D point2D) {
        return point2D.getX() >= (double)this.x && point2D.getX() <= (double)(this.x + this.width) && point2D.getY() >= (double)this.y && point2D.getY() <= (double)(this.y + this.height);
    }

    public int getLength() {
        if (this.horizontal) {
            return this.width;
        }
        return this.height;
    }

    public String toString() {
        String string = super.toString();
        string = string + "\ndirection = " + this.direction + ", horizontal = " + this.horizontal + ", depth = " + this.depth;
        return string;
    }
}

