/*
 * Decompiled with CFR 0.152.
 */
package com.jgraph.layout.orthogonal;

import com.jgraph.layout.JGraphFacade;
import com.jgraph.layout.JGraphLayout;
import com.jgraph.layout.orthogonal.OrthogonalLinkRouterRegion;
import com.jgraph.layout.orthogonal.OrthogonalLinkRouterUtils;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphConstants;

public class OrthogonalLinkRouter
implements JGraphLayout {
    private int MAXIMAL_DEPTH = 4;
    private static int firstLengthDistance = 20;
    private static final int CORNER_LENGTH = 200;
    private static final boolean UPDATE_COLLISION_LISTS = false;
    private static final boolean UPDATE_COLLISION_LISTS_REMOVE = true;
    static final boolean IGNORE_LINKS_WITH_ACTUAL_PORTS = false;
    private static final boolean OPTIMALIZE_REGIONS = true;
    Object edge;
    Object sourcePort;
    Object targetPort;
    Point2D sourcePoint;
    Point2D targetPoint;
    int sourceDirection;
    int targetDirection;
    Collection verticalCollisions = new HashSet();
    Collection horizontalCollisions = new HashSet();
    private final OrthogonalLinkRouterRegion[] regions = new OrthogonalLinkRouterRegion[this.MAXIMAL_DEPTH];
    private Point2D[] bestControlPoints;
    private int bestControlPointsLength;

    public void run(JGraphFacade jGraphFacade) {
        Collection collection = jGraphFacade.getEdges();
        Object[] objectArray = collection.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            this.routeEdge(objectArray[i], jGraphFacade);
        }
    }

    public void routeEdge(Object object, JGraphFacade jGraphFacade) {
        this.edge = object;
        Object object2 = jGraphFacade.getSourcePort(object);
        Object object3 = jGraphFacade.getTargetPort(object);
        if (object2 == null || object3 == null) {
            return;
        }
        this.verticalCollisions.clear();
        this.horizontalCollisions.clear();
        this.bestControlPoints = null;
        this.bestControlPointsLength = Integer.MIN_VALUE;
        OrthogonalLinkRouterUtils.calculateCollisionBounds(jGraphFacade, object, object2, object3, this.verticalCollisions, this.horizontalCollisions);
        ArrayList<Point2D> arrayList = new ArrayList<Point2D>();
        Object object4 = jGraphFacade.getCellView(object);
        if (object4 != null && object4 instanceof EdgeView) {
            EdgeView edgeView = (EdgeView)object4;
            int n = edgeView.getPointCount();
            Point2D point2D = edgeView.getPoint(0);
            Point2D point2D2 = edgeView.getPoint(n - 1);
            if (point2D != null && point2D2 != null) {
                int n2;
                this.sourcePoint = new Point2D.Double((int)point2D.getX(), (int)point2D.getY());
                this.sourceDirection = OrthogonalLinkRouterUtils.getDirection(jGraphFacade, object2);
                this.targetDirection = OrthogonalLinkRouterUtils.getDirection(jGraphFacade, object3);
                if (this.sourceDirection == 0 || this.targetDirection == 0) {
                    n2 = -1;
                    int n3 = -1;
                    double d = point2D2.getX() - point2D.getX();
                    double d2 = point2D2.getY() - point2D.getY();
                    if (Math.abs(d2) > Math.abs(d)) {
                        if (d2 > 0.0) {
                            n2 = 8;
                            n3 = 4;
                        } else {
                            n2 = 4;
                            n3 = 8;
                        }
                    } else if (d > 0.0) {
                        n2 = 2;
                        n3 = 1;
                    } else {
                        n2 = 1;
                        n3 = 2;
                    }
                    if (this.sourceDirection == 0) {
                        this.sourceDirection = n2;
                    }
                    if (this.targetDirection == 0) {
                        this.targetDirection = n3;
                    }
                }
                switch (this.targetDirection) {
                    case 1: {
                        this.targetPoint = new Point2D.Double(point2D2.getX() - (double)firstLengthDistance, (int)point2D2.getY());
                        break;
                    }
                    case 2: {
                        this.targetPoint = new Point2D.Double(point2D2.getX() + (double)firstLengthDistance, (int)point2D2.getY());
                        break;
                    }
                    case 4: {
                        this.targetPoint = new Point2D.Double(point2D2.getX(), (int)(point2D2.getY() - (double)firstLengthDistance));
                        break;
                    }
                    case 8: {
                        this.targetPoint = new Point2D.Double(point2D2.getX(), (int)(point2D2.getY() + (double)firstLengthDistance));
                        break;
                    }
                }
                this.search(jGraphFacade, new OrthogonalLinkRouterRegion(this.sourcePoint.getX(), this.sourcePoint.getY(), 0, 0, this.sourceDirection, 0));
                if (this.bestControlPoints != null) {
                    for (n2 = 0; n2 < this.bestControlPoints.length; ++n2) {
                        arrayList.add(this.bestControlPoints[n2]);
                    }
                    jGraphFacade.setPoints(object, arrayList);
                    jGraphFacade.disableRouting(object);
                    GraphConstants.setLineStyle(jGraphFacade.getAttributes(object), 11);
                }
            }
        }
    }

    private void search(JGraphFacade jGraphFacade, OrthogonalLinkRouterRegion orthogonalLinkRouterRegion) {
        if (orthogonalLinkRouterRegion.width < 0 || orthogonalLinkRouterRegion.height < 0) {
            return;
        }
        int n = orthogonalLinkRouterRegion.getDepth();
        if (n >= this.MAXIMAL_DEPTH) {
            return;
        }
        orthogonalLinkRouterRegion.extendToInfinity();
        this.regions[n] = orthogonalLinkRouterRegion;
        Collection collection = orthogonalLinkRouterRegion.isHorizontal() ? this.horizontalCollisions : this.verticalCollisions;
        ArrayList arrayList = orthogonalLinkRouterRegion.parseSubRegions(collection);
        Object var6_6 = null;
        if (!orthogonalLinkRouterRegion.isEmpty()) {
            // empty if block
        }
        if (orthogonalLinkRouterRegion.containsInsideEdges(this.targetPoint)) {
            this.constructControlPoints(jGraphFacade, n);
        } else {
            if (orthogonalLinkRouterRegion.getLength() > 0) {
                this.search(jGraphFacade, orthogonalLinkRouterRegion.cloneWithCounterClockwiseEdge());
                this.search(jGraphFacade, orthogonalLinkRouterRegion.cloneWithClockwiseEdge());
            }
            if (!arrayList.isEmpty()) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    OrthogonalLinkRouterRegion orthogonalLinkRouterRegion2 = (OrthogonalLinkRouterRegion)arrayList.get(i);
                    if (orthogonalLinkRouterRegion.equals(orthogonalLinkRouterRegion2)) continue;
                    this.search(jGraphFacade, orthogonalLinkRouterRegion2);
                }
            }
        }
    }

    private void constructControlPoints(JGraphFacade jGraphFacade, int n) {
        Point2D.Double[] doubleArray = new Point2D.Double[n + 4];
        Object object = jGraphFacade.getCellView(this.edge);
        if (object != null && object instanceof EdgeView) {
            int n2;
            int n3;
            int n4;
            EdgeView edgeView = (EdgeView)object;
            int n5 = edgeView.getPointCount();
            Point2D point2D = edgeView.getPoint(0);
            Point2D point2D2 = edgeView.getPoint(n5 - 1);
            doubleArray[0] = edgeView.getAllAttributes().createPoint((int)point2D.getX(), (int)point2D.getY());
            doubleArray[n + 2] = edgeView.getAllAttributes().createPoint((int)this.targetPoint.getX(), (int)this.targetPoint.getY());
            doubleArray[n + 3] = edgeView.getAllAttributes().createPoint((int)point2D2.getX(), (int)point2D2.getY());
            for (n4 = 0; n4 <= n; ++n4) {
                double d;
                double d2;
                OrthogonalLinkRouterRegion orthogonalLinkRouterRegion = this.regions[n4];
                int n6 = orthogonalLinkRouterRegion.getDirection();
                int n7 = n4 + 1;
                switch (n6) {
                    case 1: 
                    case 2: {
                        int n8;
                        int n9;
                        if (n4 > 0) {
                            n9 = orthogonalLinkRouterRegion.y;
                            n8 = orthogonalLinkRouterRegion.y + orthogonalLinkRouterRegion.height;
                            d2 = n9 <= -20000 && n8 < 20000 ? (double)(n8 - 6) : (n9 > -20000 && n8 >= 20000 ? (double)(n9 + 6) : (double)(orthogonalLinkRouterRegion.y + orthogonalLinkRouterRegion.height / 2));
                            if (doubleArray[n7] == null) {
                                doubleArray[n7] = new Point2D.Double(0.0, d2);
                            } else {
                                ((Point2D)doubleArray[n7]).setLocation(((Point2D)doubleArray[n7]).getX(), d2);
                            }
                        } else {
                            d2 = point2D.getY();
                        }
                        if (n4 == n) {
                            d = (int)this.targetPoint.getX();
                            break;
                        }
                        d = 0.0;
                        break;
                    }
                    case 4: 
                    case 8: {
                        int n8;
                        int n9;
                        if (n4 > 0) {
                            n9 = orthogonalLinkRouterRegion.x;
                            n8 = orthogonalLinkRouterRegion.x + orthogonalLinkRouterRegion.width;
                            d = n9 <= -20000 && n8 < 20000 ? (double)(n8 - 6) : (n9 > -20000 && n8 >= 20000 ? (double)(n9 + 6) : (double)(orthogonalLinkRouterRegion.x + orthogonalLinkRouterRegion.width / 2));
                            ((Point2D)doubleArray[n7]).setLocation(d, ((Point2D)doubleArray[n7]).getY());
                        } else {
                            d = point2D.getX();
                        }
                        if (n4 == n) {
                            d2 = this.targetPoint.getY();
                            break;
                        }
                        d2 = 0.0;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                if (n4 == 0) {
                    doubleArray[n7] = edgeView.getAllAttributes().createPoint((int)d, (int)d2);
                }
                doubleArray[n7 + 1] = edgeView.getAllAttributes().createPoint((int)d, (int)d2);
            }
            for (n4 = n; n4 > 0; --n4) {
                double d = ((Point2D)doubleArray[n4 + 3]).getY();
                OrthogonalLinkRouterRegion orthogonalLinkRouterRegion = this.regions[n4];
                OrthogonalLinkRouterRegion orthogonalLinkRouterRegion2 = this.regions[n4 - 1];
                if (d >= (double)orthogonalLinkRouterRegion.y && d < (double)(orthogonalLinkRouterRegion.y + orthogonalLinkRouterRegion.height) && d >= (double)orthogonalLinkRouterRegion2.y && d < (double)(orthogonalLinkRouterRegion2.y + orthogonalLinkRouterRegion2.height)) {
                    ((Point2D)doubleArray[n4 + 2]).setLocation(((Point2D)doubleArray[n4 + 2]).getX(), d);
                    ((Point2D)doubleArray[n4 + 1]).setLocation(((Point2D)doubleArray[n4 + 1]).getX(), d);
                }
                double d3 = ((Point2D)doubleArray[n4 + 3]).getX();
                OrthogonalLinkRouterRegion orthogonalLinkRouterRegion3 = this.regions[n4];
                OrthogonalLinkRouterRegion orthogonalLinkRouterRegion4 = this.regions[n4 - 1];
                if (!(d3 >= (double)orthogonalLinkRouterRegion3.x) || !(d3 < (double)(orthogonalLinkRouterRegion3.x + orthogonalLinkRouterRegion3.width)) || !(d3 >= (double)orthogonalLinkRouterRegion4.x) || !(d3 < (double)(orthogonalLinkRouterRegion4.x + orthogonalLinkRouterRegion4.width))) continue;
                ((Point2D)doubleArray[n4 + 2]).setLocation(d3, ((Point2D)doubleArray[n4 + 2]).getY());
                ((Point2D)doubleArray[n4 + 1]).setLocation(d3, ((Point2D)doubleArray[n4 + 1]).getY());
            }
            n4 = 0;
            for (n3 = 1; n3 < doubleArray.length - 1; ++n3) {
                Point2D.Double double_ = doubleArray[n4];
                Point2D.Double double_2 = doubleArray[n3];
                Point2D.Double double_3 = doubleArray[n3 + 1];
                if (((Point2D)double_).getX() == ((Point2D)double_2).getX() && ((Point2D)double_2).getX() == ((Point2D)double_3).getX() || ((Point2D)double_).getY() == ((Point2D)double_2).getY() && ((Point2D)double_2).getY() == ((Point2D)double_3).getY() || ++n4 == n3) continue;
                doubleArray[n4] = double_2;
            }
            if (++n4 < doubleArray.length - 1) {
                doubleArray[n4++] = doubleArray[doubleArray.length - 1];
            }
            n3 = 0;
            for (n2 = 1; n2 < n4; ++n2) {
                Point2D.Double double_ = doubleArray[n2 - 1];
                Point2D.Double double_4 = doubleArray[n2];
                n3 = (int)((double)n3 + (Math.abs(((Point2D)double_4).getY() - ((Point2D)double_).getY()) + Math.abs(((Point2D)double_4).getX() - ((Point2D)double_).getX()) + 200.0));
            }
            if (n4 > 0) {
                n2 = n3 / n4;
                int n10 = 0;
                for (int i = 1; i < n4; ++i) {
                    Point2D.Double double_ = doubleArray[i - 1];
                    Point2D.Double double_5 = doubleArray[i];
                    n10 = (int)((double)n10 + Math.abs(Math.abs(((Point2D)double_5).getY() - ((Point2D)double_).getY()) + Math.abs(((Point2D)double_5).getX() - ((Point2D)double_).getX()) - (double)n2));
                }
                n3 += (n10 /= n4);
            }
            if (this.bestControlPoints == null || this.bestControlPointsLength > n3) {
                if (n4 < doubleArray.length) {
                    this.bestControlPoints = new Point2D.Double[n4];
                    System.arraycopy(doubleArray, 0, this.bestControlPoints, 0, n4);
                } else {
                    this.bestControlPoints = doubleArray;
                }
                this.bestControlPointsLength = n3;
            }
        }
    }

    public String toString() {
        return "Orthogonal Edges";
    }

    public int getMAXIMAL_DEPTH() {
        return this.MAXIMAL_DEPTH;
    }

    public void setMAXIMAL_DEPTH(int n) {
        this.MAXIMAL_DEPTH = n;
    }
}

