/*
 * Decompiled with CFR 0.152.
 */
package com.jgraph.layout.hierarchical;

import com.jgraph.layout.JGraphFacade;
import com.jgraph.layout.hierarchical.JGraphHierarchicalLayoutStep;
import com.jgraph.layout.hierarchical.model.JGraphAbstractHierarchyCell;
import com.jgraph.layout.hierarchical.model.JGraphHierarchyEdge;
import com.jgraph.layout.hierarchical.model.JGraphHierarchyModel;
import com.jgraph.layout.hierarchical.model.JGraphHierarchyNode;
import com.jgraph.layout.hierarchical.model.JGraphHierarchyRank;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JGraphCoordinateAssignment
implements JGraphHierarchicalLayoutStep {
    protected double intraCellSpacing = 30.0;
    protected double interRankCellSpacing = 30.0;
    protected double parallelEdgeSpacing = 10.0;
    protected int maxIterations = 8;
    protected int orientation = 1;
    protected double initialX;
    protected double limitX;
    protected double currentXDelta;
    protected int widestRank;
    protected double widestRankValue;
    protected double[] rankWidths;
    protected double[] rankY;
    protected boolean fineTuning = true;
    protected boolean compactLayout = false;
    protected JGraphAbstractHierarchyCell[][] nextLayerConnectedCache;
    protected JGraphAbstractHierarchyCell[][] previousLayerConnectedCache;
    private static Logger logger = Logger.getLogger("com.jgraph.layout.hierarchical.JGraphCoordinateAssignment");

    public JGraphCoordinateAssignment(double d, double d2, int n, boolean bl, double d3, double d4) {
        this.intraCellSpacing = d;
        this.interRankCellSpacing = d2;
        this.orientation = n;
        this.compactLayout = bl;
        this.initialX = d3;
        this.parallelEdgeSpacing = d4;
        this.setLoggerLevel(Level.OFF);
    }

    public JGraphHierarchyModel run(JGraphFacade jGraphFacade, JGraphHierarchyModel jGraphHierarchyModel) {
        this.currentXDelta = 0.0;
        this.initialise(jGraphHierarchyModel);
        this.initialCoords(jGraphFacade, jGraphHierarchyModel);
        if (this.fineTuning) {
            this.minNode(jGraphHierarchyModel);
        }
        double d = 1.0E8;
        if (this.fineTuning) {
            for (int i = 0; i < this.maxIterations; ++i) {
                JGraphAbstractHierarchyCell jGraphAbstractHierarchyCell;
                Iterator iterator;
                JGraphHierarchyRank jGraphHierarchyRank;
                int n;
                if (i != 0) {
                    this.medianPos(i, jGraphHierarchyModel);
                    this.minNode(jGraphHierarchyModel);
                }
                if (this.currentXDelta < d) {
                    for (n = 0; n < jGraphHierarchyModel.ranks.size(); ++n) {
                        jGraphHierarchyRank = (JGraphHierarchyRank)jGraphHierarchyModel.ranks.get(new Integer(n));
                        iterator = jGraphHierarchyRank.iterator();
                        while (iterator.hasNext()) {
                            jGraphAbstractHierarchyCell = (JGraphAbstractHierarchyCell)iterator.next();
                            jGraphAbstractHierarchyCell.setX(n, jGraphAbstractHierarchyCell.getGeneralPurposeVariable(n));
                        }
                    }
                    d = this.currentXDelta;
                } else {
                    for (n = 0; n < jGraphHierarchyModel.ranks.size(); ++n) {
                        jGraphHierarchyRank = (JGraphHierarchyRank)jGraphHierarchyModel.ranks.get(new Integer(n));
                        iterator = jGraphHierarchyRank.iterator();
                        while (iterator.hasNext()) {
                            jGraphAbstractHierarchyCell = (JGraphAbstractHierarchyCell)iterator.next();
                            jGraphAbstractHierarchyCell.setGeneralPurposeVariable(n, (int)jGraphAbstractHierarchyCell.getX(n));
                        }
                    }
                }
                this.currentXDelta = 0.0;
            }
        }
        if (this.compactLayout) {
            // empty if block
        }
        this.setCellLocations(jGraphFacade, jGraphHierarchyModel);
        return jGraphHierarchyModel;
    }

    private void minNode(JGraphHierarchyModel jGraphHierarchyModel) {
        Object object;
        Object object2;
        int n;
        int n2;
        LinkedList<Object> linkedList = new LinkedList<Object>();
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        Object[][] objectArrayArray = new Object[jGraphHierarchyModel.maxRank + 1][];
        for (n2 = 0; n2 <= jGraphHierarchyModel.maxRank; ++n2) {
            JGraphHierarchyRank jGraphHierarchyRank = (JGraphHierarchyRank)jGraphHierarchyModel.ranks.get(new Integer(n2));
            objectArrayArray[n2] = jGraphHierarchyRank.toArray();
            n = 0;
            while (n < objectArrayArray[n2].length) {
                object2 = (JGraphAbstractHierarchyCell)objectArrayArray[n2][n];
                object = new WeightedCellSorter((JGraphAbstractHierarchyCell)object2, n2);
                ((WeightedCellSorter)object).rankIndex = n++;
                ((WeightedCellSorter)object).visited = true;
                linkedList.add(object);
                hashtable.put(object2, object);
            }
        }
        n2 = linkedList.size() * 10;
        n = 1;
        for (int i = 0; !linkedList.isEmpty() && i <= n2; ++i) {
            object2 = (WeightedCellSorter)linkedList.getFirst();
            object = ((WeightedCellSorter)object2).cell;
            int n3 = ((WeightedCellSorter)object2).weightedValue;
            int n4 = ((WeightedCellSorter)object2).rankIndex;
            Object[] objectArray = ((JGraphAbstractHierarchyCell)object).getNextLayerConnectedCells(n3).toArray();
            Object[] objectArray2 = ((JGraphAbstractHierarchyCell)object).getPreviousLayerConnectedCells(n3).toArray();
            int n5 = objectArray.length;
            int n6 = objectArray2.length;
            int n7 = this.medianXValue(objectArray, n3 + 1);
            int n8 = this.medianXValue(objectArray2, n3 - 1);
            int n9 = n5 + n6;
            int n10 = ((JGraphAbstractHierarchyCell)object).getGeneralPurposeVariable(n3);
            double d = n10;
            if (n9 > 0) {
                d = (n7 * n5 + n8 * n6) / n9;
            }
            boolean bl = false;
            if (d < (double)(n10 - n)) {
                if (n4 == 0) {
                    ((JGraphAbstractHierarchyCell)object).setGeneralPurposeVariable(n3, (int)d);
                    bl = true;
                } else {
                    JGraphAbstractHierarchyCell jGraphAbstractHierarchyCell = (JGraphAbstractHierarchyCell)objectArrayArray[n3][n4 - 1];
                    int n11 = jGraphAbstractHierarchyCell.getGeneralPurposeVariable(n3);
                    if ((double)(n11 = n11 + (int)jGraphAbstractHierarchyCell.width / 2 + (int)this.intraCellSpacing + (int)((JGraphAbstractHierarchyCell)object).width / 2) < d) {
                        ((JGraphAbstractHierarchyCell)object).setGeneralPurposeVariable(n3, (int)d);
                        bl = true;
                    } else if (n11 < ((JGraphAbstractHierarchyCell)object).getGeneralPurposeVariable(n3) - n) {
                        ((JGraphAbstractHierarchyCell)object).setGeneralPurposeVariable(n3, n11);
                        bl = true;
                    }
                }
            } else if (d > (double)(n10 + n)) {
                int n12 = objectArrayArray[n3].length;
                if (n4 == n12 - 1) {
                    ((JGraphAbstractHierarchyCell)object).setGeneralPurposeVariable(n3, (int)d);
                    bl = true;
                } else {
                    JGraphAbstractHierarchyCell jGraphAbstractHierarchyCell = (JGraphAbstractHierarchyCell)objectArrayArray[n3][n4 + 1];
                    int n13 = jGraphAbstractHierarchyCell.getGeneralPurposeVariable(n3);
                    if ((double)(n13 = n13 - (int)jGraphAbstractHierarchyCell.width / 2 - (int)this.intraCellSpacing - (int)((JGraphAbstractHierarchyCell)object).width / 2) > d) {
                        ((JGraphAbstractHierarchyCell)object).setGeneralPurposeVariable(n3, (int)d);
                        bl = true;
                    } else if (n13 > ((JGraphAbstractHierarchyCell)object).getGeneralPurposeVariable(n3) + n) {
                        ((JGraphAbstractHierarchyCell)object).setGeneralPurposeVariable(n3, n13);
                        bl = true;
                    }
                }
            }
            if (bl) {
                int n14;
                for (n14 = 0; n14 < objectArray.length; ++n14) {
                    JGraphAbstractHierarchyCell jGraphAbstractHierarchyCell = (JGraphAbstractHierarchyCell)objectArray[n14];
                    WeightedCellSorter weightedCellSorter = (WeightedCellSorter)hashtable.get(jGraphAbstractHierarchyCell);
                    if (weightedCellSorter == null || weightedCellSorter.visited) continue;
                    weightedCellSorter.visited = true;
                    linkedList.add(weightedCellSorter);
                }
                for (n14 = 0; n14 < objectArray2.length; ++n14) {
                    JGraphAbstractHierarchyCell jGraphAbstractHierarchyCell = (JGraphAbstractHierarchyCell)objectArray2[n14];
                    WeightedCellSorter weightedCellSorter = (WeightedCellSorter)hashtable.get(jGraphAbstractHierarchyCell);
                    if (weightedCellSorter == null || weightedCellSorter.visited) continue;
                    weightedCellSorter.visited = true;
                    linkedList.add(weightedCellSorter);
                }
            }
            linkedList.removeFirst();
            ((WeightedCellSorter)object2).visited = false;
        }
    }

    private void medianPos(int n, JGraphHierarchyModel jGraphHierarchyModel) {
        boolean bl;
        boolean bl2 = bl = n % 2 == 0;
        if (bl) {
            for (int i = jGraphHierarchyModel.maxRank; i > 0; --i) {
                this.rankMedianPosition(i - 1, jGraphHierarchyModel, i);
            }
        } else {
            for (int i = 0; i < jGraphHierarchyModel.maxRank - 1; ++i) {
                this.rankMedianPosition(i + 1, jGraphHierarchyModel, i);
            }
        }
    }

    protected void rankMedianPosition(int n, JGraphHierarchyModel jGraphHierarchyModel, int n2) {
        Object object;
        int n3;
        JGraphHierarchyRank jGraphHierarchyRank = (JGraphHierarchyRank)jGraphHierarchyModel.ranks.get(new Integer(n));
        Object[] objectArray = jGraphHierarchyRank.toArray();
        Object[] objectArray2 = new WeightedCellSorter[objectArray.length];
        Hashtable<JGraphAbstractHierarchyCell, Object> hashtable = new Hashtable<JGraphAbstractHierarchyCell, Object>(objectArray.length);
        for (n3 = 0; n3 < objectArray.length; ++n3) {
            JGraphAbstractHierarchyCell jGraphAbstractHierarchyCell = (JGraphAbstractHierarchyCell)objectArray[n3];
            objectArray2[n3] = new WeightedCellSorter();
            ((WeightedCellSorter)objectArray2[n3]).cell = jGraphAbstractHierarchyCell;
            ((WeightedCellSorter)objectArray2[n3]).rankIndex = n3;
            hashtable.put(jGraphAbstractHierarchyCell, objectArray2[n3]);
            object = null;
            object = n2 < n ? jGraphAbstractHierarchyCell.getPreviousLayerConnectedCells(n) : jGraphAbstractHierarchyCell.getNextLayerConnectedCells(n);
            ((WeightedCellSorter)objectArray2[n3]).weightedValue = this.calculatedWeightedValue(jGraphAbstractHierarchyCell, (Collection)object);
        }
        Arrays.sort(objectArray2);
        for (n3 = 0; n3 < objectArray2.length; ++n3) {
            int n4 = 0;
            object = ((WeightedCellSorter)objectArray2[n3]).cell;
            Object[] objectArray3 = null;
            int n5 = 0;
            objectArray3 = n2 < n ? ((JGraphAbstractHierarchyCell)object).getPreviousLayerConnectedCells(n).toArray() : ((JGraphAbstractHierarchyCell)object).getNextLayerConnectedCells(n).toArray();
            if (objectArray3 != null) {
                n4 = objectArray3.length;
                n5 = n4 > 0 ? this.medianXValue(objectArray3, n2) : ((JGraphAbstractHierarchyCell)object).getGeneralPurposeVariable(n);
            }
            double d = 0.0;
            double d2 = -1.0E8;
            int n6 = ((WeightedCellSorter)objectArray2[n3]).rankIndex - 1;
            while (n6 >= 0) {
                WeightedCellSorter weightedCellSorter = (WeightedCellSorter)hashtable.get(objectArray[n6]);
                if (weightedCellSorter == null) continue;
                JGraphAbstractHierarchyCell jGraphAbstractHierarchyCell = weightedCellSorter.cell;
                if (weightedCellSorter.visited) {
                    d2 = (double)jGraphAbstractHierarchyCell.getGeneralPurposeVariable(n) + jGraphAbstractHierarchyCell.width / 2.0 + this.intraCellSpacing + d + ((JGraphAbstractHierarchyCell)object).width / 2.0;
                    n6 = -1;
                    continue;
                }
                d += jGraphAbstractHierarchyCell.width + this.intraCellSpacing;
                --n6;
            }
            double d3 = 0.0;
            double d4 = 1.0E8;
            int n7 = ((WeightedCellSorter)objectArray2[n3]).rankIndex + 1;
            while (n7 < objectArray2.length) {
                WeightedCellSorter weightedCellSorter = (WeightedCellSorter)hashtable.get(objectArray[n7]);
                if (weightedCellSorter == null) continue;
                JGraphAbstractHierarchyCell jGraphAbstractHierarchyCell = weightedCellSorter.cell;
                if (weightedCellSorter.visited) {
                    d4 = (double)jGraphAbstractHierarchyCell.getGeneralPurposeVariable(n) - jGraphAbstractHierarchyCell.width / 2.0 - this.intraCellSpacing - d3 - ((JGraphAbstractHierarchyCell)object).width / 2.0;
                    n7 = objectArray2.length;
                    continue;
                }
                d3 += jGraphAbstractHierarchyCell.width + this.intraCellSpacing;
                ++n7;
            }
            if ((double)n5 >= d2 && (double)n5 <= d4) {
                ((JGraphAbstractHierarchyCell)object).setGeneralPurposeVariable(n, n5);
            } else if ((double)n5 < d2) {
                ((JGraphAbstractHierarchyCell)object).setGeneralPurposeVariable(n, (int)d2);
                this.currentXDelta += d2 - (double)n5;
            } else if ((double)n5 > d4) {
                ((JGraphAbstractHierarchyCell)object).setGeneralPurposeVariable(n, (int)d4);
                this.currentXDelta += (double)n5 - d4;
            }
            ((WeightedCellSorter)objectArray2[n3]).visited = true;
        }
    }

    private int calculatedWeightedValue(JGraphAbstractHierarchyCell jGraphAbstractHierarchyCell, Collection collection) {
        int n = 0;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            JGraphAbstractHierarchyCell jGraphAbstractHierarchyCell2 = (JGraphAbstractHierarchyCell)iterator.next();
            if (jGraphAbstractHierarchyCell.isVertex() && jGraphAbstractHierarchyCell2.isVertex()) {
                ++n;
                continue;
            }
            if (jGraphAbstractHierarchyCell.isEdge() && jGraphAbstractHierarchyCell2.isEdge()) {
                n += 8;
                continue;
            }
            n += 2;
        }
        return n;
    }

    private int medianXValue(Object[] objectArray, int n) {
        int n2;
        if (objectArray.length == 0) {
            return 0;
        }
        int[] nArray = new int[objectArray.length];
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            nArray[n2] = ((JGraphAbstractHierarchyCell)objectArray[n2]).getGeneralPurposeVariable(n);
        }
        Arrays.sort(nArray);
        if (objectArray.length % 2 == 1) {
            return nArray[objectArray.length / 2];
        }
        n2 = objectArray.length / 2;
        int n3 = nArray[n2 - 1];
        int n4 = nArray[n2];
        return (n3 + n4) / 2;
    }

    private void initialise(JGraphHierarchyModel jGraphHierarchyModel) {
    }

    private void initialCoords(JGraphFacade jGraphFacade, JGraphHierarchyModel jGraphHierarchyModel) {
        int n;
        this.calculateWidestRank(jGraphFacade, jGraphHierarchyModel);
        for (n = this.widestRank; n > 0; --n) {
            if (n >= jGraphHierarchyModel.maxRank) continue;
            this.rankCoordinates(n, jGraphFacade, jGraphHierarchyModel);
        }
        for (n = this.widestRank; n <= jGraphHierarchyModel.maxRank; ++n) {
            if (n <= 0) continue;
            this.rankCoordinates(n, jGraphFacade, jGraphHierarchyModel);
        }
    }

    protected void rankCoordinates(int n, JGraphFacade jGraphFacade, JGraphHierarchyModel jGraphHierarchyModel) {
        JGraphHierarchyRank jGraphHierarchyRank = (JGraphHierarchyRank)jGraphHierarchyModel.ranks.get(new Integer(n));
        double d = 0.0;
        double d2 = this.initialX + (this.widestRankValue - this.rankWidths[n]) / 2.0;
        Iterator iterator = jGraphHierarchyRank.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            JGraphAbstractHierarchyCell jGraphAbstractHierarchyCell;
            JGraphAbstractHierarchyCell jGraphAbstractHierarchyCell2 = (JGraphAbstractHierarchyCell)iterator.next();
            if (jGraphAbstractHierarchyCell2.isVertex()) {
                jGraphAbstractHierarchyCell = (JGraphHierarchyNode)jGraphAbstractHierarchyCell2;
                Rectangle2D rectangle2D = jGraphFacade.getBounds(jGraphAbstractHierarchyCell.cell);
                if (rectangle2D != null) {
                    if (this.orientation == 1 || this.orientation == 5) {
                        jGraphAbstractHierarchyCell2.width = rectangle2D.getWidth();
                        jGraphAbstractHierarchyCell2.height = rectangle2D.getHeight();
                    } else {
                        jGraphAbstractHierarchyCell2.width = rectangle2D.getHeight();
                        jGraphAbstractHierarchyCell2.height = rectangle2D.getWidth();
                    }
                } else {
                    bl = true;
                }
                d = Math.max(d, jGraphAbstractHierarchyCell2.height);
            } else if (jGraphAbstractHierarchyCell2.isEdge()) {
                jGraphAbstractHierarchyCell = (JGraphHierarchyEdge)jGraphAbstractHierarchyCell2;
                int n2 = 1;
                if (((JGraphHierarchyEdge)jGraphAbstractHierarchyCell).edges != null) {
                    n2 = ((JGraphHierarchyEdge)jGraphAbstractHierarchyCell).edges.size();
                } else {
                    logger.info("edge.edges is null");
                }
                jGraphAbstractHierarchyCell2.width = (double)(n2 - 1) * this.parallelEdgeSpacing;
            }
            jGraphAbstractHierarchyCell2.setX(n, d2 += jGraphAbstractHierarchyCell2.width / 2.0);
            jGraphAbstractHierarchyCell2.setGeneralPurposeVariable(n, (int)d2);
            d2 += jGraphAbstractHierarchyCell2.width / 2.0;
            d2 += this.intraCellSpacing;
        }
        if (bl) {
            logger.info("At least one cell has no bounds");
        }
    }

    protected void calculateWidestRank(JGraphFacade jGraphFacade, JGraphHierarchyModel jGraphHierarchyModel) {
        double d = -this.interRankCellSpacing;
        double d2 = 0.0;
        this.rankWidths = new double[jGraphHierarchyModel.maxRank + 1];
        this.rankY = new double[jGraphHierarchyModel.maxRank + 1];
        for (int i = jGraphHierarchyModel.maxRank; i >= 0; --i) {
            Object object;
            double d3 = 0.0;
            JGraphHierarchyRank jGraphHierarchyRank = (JGraphHierarchyRank)jGraphHierarchyModel.ranks.get(new Integer(i));
            double d4 = this.initialX;
            Iterator iterator = jGraphHierarchyRank.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                JGraphAbstractHierarchyCell jGraphAbstractHierarchyCell;
                JGraphAbstractHierarchyCell jGraphAbstractHierarchyCell2 = (JGraphAbstractHierarchyCell)iterator.next();
                if (jGraphAbstractHierarchyCell2.isVertex()) {
                    jGraphAbstractHierarchyCell = (JGraphHierarchyNode)jGraphAbstractHierarchyCell2;
                    object = jGraphFacade.getBounds(jGraphAbstractHierarchyCell.cell);
                    if (object != null) {
                        if (this.orientation == 1 || this.orientation == 5) {
                            jGraphAbstractHierarchyCell2.width = ((RectangularShape)object).getWidth();
                            jGraphAbstractHierarchyCell2.height = ((RectangularShape)object).getHeight();
                        } else {
                            jGraphAbstractHierarchyCell2.width = ((RectangularShape)object).getHeight();
                            jGraphAbstractHierarchyCell2.height = ((RectangularShape)object).getWidth();
                        }
                    } else {
                        bl = true;
                    }
                    d3 = Math.max(d3, jGraphAbstractHierarchyCell2.height);
                } else if (jGraphAbstractHierarchyCell2.isEdge()) {
                    jGraphAbstractHierarchyCell = (JGraphHierarchyEdge)jGraphAbstractHierarchyCell2;
                    int n = 1;
                    if (((JGraphHierarchyEdge)jGraphAbstractHierarchyCell).edges != null) {
                        n = ((JGraphHierarchyEdge)jGraphAbstractHierarchyCell).edges.size();
                    } else {
                        logger.info("edge.edges is null");
                    }
                    jGraphAbstractHierarchyCell2.width = (double)(n - 1) * this.parallelEdgeSpacing;
                }
                jGraphAbstractHierarchyCell2.setX(i, d4 += jGraphAbstractHierarchyCell2.width / 2.0);
                jGraphAbstractHierarchyCell2.setGeneralPurposeVariable(i, (int)d4);
                d4 += jGraphAbstractHierarchyCell2.width / 2.0;
                d4 += this.intraCellSpacing;
                if (d4 > this.widestRankValue) {
                    this.widestRankValue = d4;
                    this.widestRank = i;
                }
                this.rankWidths[i] = d4;
            }
            if (bl) {
                logger.info("At least one cell has no bounds");
            }
            this.rankY[i] = d;
            double d5 = d3 / 2.0 + d2 / 2.0 + this.interRankCellSpacing;
            d2 = d3;
            d = this.orientation == 1 || this.orientation == 7 ? (d += d5) : (d -= d5);
            iterator = jGraphHierarchyRank.iterator();
            while (iterator.hasNext()) {
                object = (JGraphAbstractHierarchyCell)iterator.next();
                ((JGraphAbstractHierarchyCell)object).setY(i, d);
            }
        }
    }

    private void setCellLocations(JGraphFacade jGraphFacade, JGraphHierarchyModel jGraphHierarchyModel) {
        for (int i = 0; i < jGraphHierarchyModel.ranks.size(); ++i) {
            JGraphHierarchyRank jGraphHierarchyRank = (JGraphHierarchyRank)jGraphHierarchyModel.ranks.get(new Integer(i));
            Iterator iterator = jGraphHierarchyRank.iterator();
            while (iterator.hasNext()) {
                double d;
                Iterator iterator2;
                JGraphAbstractHierarchyCell jGraphAbstractHierarchyCell;
                JGraphAbstractHierarchyCell jGraphAbstractHierarchyCell2 = (JGraphAbstractHierarchyCell)iterator.next();
                if (jGraphAbstractHierarchyCell2.isVertex()) {
                    jGraphAbstractHierarchyCell = (JGraphHierarchyNode)jGraphAbstractHierarchyCell2;
                    iterator2 = ((JGraphHierarchyNode)jGraphAbstractHierarchyCell).cell;
                    d = ((JGraphHierarchyNode)jGraphAbstractHierarchyCell).x[0] - ((JGraphHierarchyNode)jGraphAbstractHierarchyCell).width / 2.0;
                    double d2 = ((JGraphHierarchyNode)jGraphAbstractHierarchyCell).y[0] - ((JGraphHierarchyNode)jGraphAbstractHierarchyCell).height / 2.0;
                    if (this.orientation == 1 || this.orientation == 5) {
                        jGraphFacade.setLocation(iterator2, d, d2);
                    } else {
                        jGraphFacade.setLocation(iterator2, d2, d);
                    }
                    this.limitX = Math.max(this.limitX, d + ((JGraphHierarchyNode)jGraphAbstractHierarchyCell).width);
                    continue;
                }
                if (!jGraphAbstractHierarchyCell2.isEdge()) continue;
                jGraphAbstractHierarchyCell = (JGraphHierarchyEdge)jGraphAbstractHierarchyCell2;
                iterator2 = ((JGraphHierarchyEdge)jGraphAbstractHierarchyCell).edges.iterator();
                d = 0.0;
                if (((JGraphHierarchyEdge)jGraphAbstractHierarchyCell).temp[0] == 101207) continue;
                while (iterator2.hasNext()) {
                    double d3;
                    int n;
                    Object e = iterator2.next();
                    List list = jGraphFacade.getPoints(e);
                    ArrayList arrayList = new ArrayList(((JGraphHierarchyEdge)jGraphAbstractHierarchyCell).x.length + 2);
                    arrayList.add(list.get(0));
                    if (((JGraphHierarchyEdge)jGraphAbstractHierarchyCell).isReversed()) {
                        for (n = 0; n < ((JGraphHierarchyEdge)jGraphAbstractHierarchyCell).x.length; ++n) {
                            d3 = ((JGraphHierarchyEdge)jGraphAbstractHierarchyCell).x[n] + d;
                            if (this.orientation == 1 || this.orientation == 5) {
                                arrayList.add(new Point2D.Double(d3, ((JGraphHierarchyEdge)jGraphAbstractHierarchyCell).y[n]));
                            } else {
                                arrayList.add(new Point2D.Double(((JGraphHierarchyEdge)jGraphAbstractHierarchyCell).y[n], d3));
                            }
                            this.limitX = Math.max(this.limitX, d3);
                        }
                        this.processReversedEdge((JGraphHierarchyEdge)jGraphAbstractHierarchyCell, e);
                    } else {
                        for (n = ((JGraphHierarchyEdge)jGraphAbstractHierarchyCell).x.length - 1; n >= 0; --n) {
                            d3 = ((JGraphHierarchyEdge)jGraphAbstractHierarchyCell).x[n] + d;
                            if (this.orientation == 1 || this.orientation == 5) {
                                arrayList.add(new Point2D.Double(d3, ((JGraphHierarchyEdge)jGraphAbstractHierarchyCell).y[n]));
                            } else {
                                arrayList.add(new Point2D.Double(((JGraphHierarchyEdge)jGraphAbstractHierarchyCell).y[n], d3));
                            }
                            this.limitX = Math.max(this.limitX, d3);
                        }
                    }
                    arrayList.add(list.get(list.size() - 1));
                    jGraphFacade.setPoints(e, arrayList);
                    jGraphFacade.disableRouting(e);
                    if (d == 0.0) {
                        d = this.parallelEdgeSpacing;
                        continue;
                    }
                    if (d > 0.0) {
                        d = -d;
                        continue;
                    }
                    d = -d + this.parallelEdgeSpacing;
                }
                ((JGraphHierarchyEdge)jGraphAbstractHierarchyCell).temp[0] = 101207;
            }
        }
    }

    private void processReversedEdge(JGraphHierarchyEdge jGraphHierarchyEdge, Object object) {
    }

    public double getInterRankCellSpacing() {
        return this.interRankCellSpacing;
    }

    public void setInterRankCellSpacing(double d) {
        this.interRankCellSpacing = d;
    }

    public double getIntraCellSpacing() {
        return this.intraCellSpacing;
    }

    public void setIntraCellSpacing(double d) {
        this.intraCellSpacing = d;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int n) {
        this.orientation = n;
    }

    public double getLimitX() {
        return this.limitX;
    }

    public void setLimitX(double d) {
        this.limitX = d;
    }

    public boolean isFineTuning() {
        return this.fineTuning;
    }

    public void setFineTuning(boolean bl) {
        this.fineTuning = bl;
    }

    public boolean isCompactLayout() {
        return this.compactLayout;
    }

    public void setCompactLayout(boolean bl) {
        this.compactLayout = bl;
    }

    public void setLoggerLevel(Level level) {
        try {
            logger.setLevel(level);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    protected class AreaSpatialCache
    extends Rectangle2D.Double {
        public Set cells = new HashSet();

        protected AreaSpatialCache() {
        }
    }

    protected class WeightedCellSorter
    implements Comparable {
        public int weightedValue = 0;
        public boolean nudge = false;
        public boolean visited = false;
        public int rankIndex;
        public JGraphAbstractHierarchyCell cell = null;

        public WeightedCellSorter() {
            this(null, 0);
        }

        public WeightedCellSorter(JGraphAbstractHierarchyCell jGraphAbstractHierarchyCell, int n) {
            this.cell = jGraphAbstractHierarchyCell;
            this.weightedValue = n;
        }

        public int compareTo(Object object) {
            if (object instanceof WeightedCellSorter) {
                if (this.weightedValue > ((WeightedCellSorter)object).weightedValue) {
                    return -1;
                }
                if (this.weightedValue < ((WeightedCellSorter)object).weightedValue) {
                    return 1;
                }
                if (this.nudge) {
                    return -1;
                }
                return 1;
            }
            return 0;
        }
    }
}

