/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.shortestpath;

import edu.uci.ics.jung.algorithms.scoring.ClosenessCentrality;
import edu.uci.ics.jung.algorithms.scoring.util.VertexScoreTransformer;
import edu.uci.ics.jung.algorithms.shortestpath.Distance;
import edu.uci.ics.jung.algorithms.shortestpath.UnweightedShortestPath;
import edu.uci.ics.jung.graph.Graph;
import java.util.Collection;
import org.apache.commons.collections15.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistanceStatistics {
    public static <V, E> Transformer<V, Double> averageDistances(Graph<V, E> graph, Distance<V> d) {
        ClosenessCentrality<V, E> cc = new ClosenessCentrality<V, E>(graph, d);
        return new VertexScoreTransformer<V, E>(cc);
    }

    public static <V, E> Transformer<V, Double> averageDistances(Graph<V, E> g) {
        ClosenessCentrality<V, E> cc = new ClosenessCentrality<V, E>(g, new UnweightedShortestPath<V, E>(g));
        return new VertexScoreTransformer<V, E>(cc);
    }

    public static <V, E> double diameter(Graph<V, E> g, Distance<V> d, boolean use_max) {
        double diameter = 0.0;
        Collection vertices = g.getVertices();
        for (Object v : vertices) {
            for (Object w : vertices) {
                if (v.equals(w)) continue;
                Number dist = d.getDistance(v, w);
                if (dist == null) {
                    if (use_max) continue;
                    return Double.POSITIVE_INFINITY;
                }
                diameter = Math.max(diameter, dist.doubleValue());
            }
        }
        return diameter;
    }

    public static <V, E> double diameter(Graph<V, E> g, Distance<V> d) {
        return DistanceStatistics.diameter(g, d, false);
    }

    public static <V, E> double diameter(Graph<V, E> g) {
        return DistanceStatistics.diameter(g, new UnweightedShortestPath<V, E>(g));
    }
}

