/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.layout;

import java.awt.geom.Point2D;

public class PolarPoint {
    double theta;
    double radius;

    public PolarPoint() {
        this(0.0, 0.0);
    }

    public PolarPoint(double theta, double radius) {
        this.theta = theta;
        this.radius = radius;
    }

    public double getTheta() {
        return this.theta;
    }

    public double getRadius() {
        return this.radius;
    }

    public void setTheta(double theta) {
        this.theta = theta;
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    public static Point2D polarToCartesian(PolarPoint polar) {
        return PolarPoint.polarToCartesian(polar.getTheta(), polar.getRadius());
    }

    public static Point2D polarToCartesian(double theta, double radius) {
        return new Point2D.Double(radius * Math.cos(theta), radius * Math.sin(theta));
    }

    public static PolarPoint cartesianToPolar(Point2D point) {
        return PolarPoint.cartesianToPolar(point.getX(), point.getY());
    }

    public static PolarPoint cartesianToPolar(double x, double y) {
        double theta = Math.atan2(y, x);
        double radius = Math.sqrt(x * x + y * y);
        return new PolarPoint(theta, radius);
    }

    public String toString() {
        String superString = super.toString();
        return superString.replace("Point2D", "PolarPoint2D");
    }

    public void setLocation(PolarPoint p) {
        this.theta = p.getTheta();
        this.radius = p.getRadius();
    }
}

