/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.importance;

import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.impl.SparseDoubleMatrix1D;
import edu.uci.ics.jung.algorithms.importance.PageRank;
import edu.uci.ics.jung.algorithms.importance.Ranking;
import edu.uci.ics.jung.algorithms.importance.RelativeAuthorityRanker;
import edu.uci.ics.jung.algorithms.matrix.GraphMatrixOperations;
import edu.uci.ics.jung.algorithms.util.Indexer;
import edu.uci.ics.jung.graph.DirectedGraph;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections15.BidiMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkovCentrality<V, E>
extends RelativeAuthorityRanker<V, E> {
    public static final String MEAN_FIRST_PASSAGE_TIME = "jung.algorithms.importance.mean_first_passage_time";
    private DoubleMatrix1D mRankings;
    private BidiMap<V, Integer> mIndexer;

    public MarkovCentrality(DirectedGraph<V, E> graph, Set<V> rootNodes) {
        this(graph, rootNodes, null);
    }

    public MarkovCentrality(DirectedGraph<V, E> graph, Set<V> rootNodes, Map<E, Number> edgeWeightKey) {
        super.initialize(graph, true, false);
        this.setPriors(rootNodes);
        if (edgeWeightKey == null) {
            this.assignDefaultEdgeTransitionWeights();
        } else {
            this.setEdgeWeights(edgeWeightKey);
        }
        this.normalizeEdgeTransitionWeights();
        this.mIndexer = Indexer.create(graph.getVertices());
        this.mRankings = new SparseDoubleMatrix1D(graph.getVertexCount());
    }

    @Override
    public String getRankScoreKey() {
        return MEAN_FIRST_PASSAGE_TIME;
    }

    @Override
    public double getVertexRankScore(V vert) {
        return this.mRankings.get(((Integer)this.mIndexer.get(vert)).intValue());
    }

    @Override
    public void step() {
        DoubleMatrix2D mFPTMatrix = GraphMatrixOperations.computeMeanFirstPassageMatrix(this.getGraph(), this.getEdgeWeights(), this.getStationaryDistribution());
        this.mRankings.assign(0.0);
        for (Object p : this.getPriors()) {
            int p_id = (Integer)this.mIndexer.get(p);
            for (Object v : this.getVertices()) {
                int v_id = (Integer)this.mIndexer.get(v);
                this.mRankings.set(v_id, this.mRankings.get(v_id) + mFPTMatrix.get(p_id, v_id));
            }
        }
        for (Object v : this.getVertices()) {
            int v_id = (Integer)this.mIndexer.get(v);
            this.mRankings.set(v_id, 1.0 / (this.mRankings.get(v_id) / (double)this.getPriors().size()));
        }
        double total = this.mRankings.zSum();
        for (Object v : this.getVertices()) {
            int v_id = (Integer)this.mIndexer.get(v);
            this.mRankings.set(v_id, this.mRankings.get(v_id) / total);
        }
    }

    private DoubleMatrix1D getStationaryDistribution() {
        DenseDoubleMatrix1D piVector = new DenseDoubleMatrix1D(this.getVertexCount());
        PageRank pageRank = new PageRank((DirectedGraph)this.getGraph(), 0.0, this.getEdgeWeights());
        pageRank.evaluate();
        List<Ranking<?>> rankings = pageRank.getRankings();
        for (Ranking<?> rank : rankings) {
            piVector.set(((Integer)this.mIndexer.get(rank.getRanked())).intValue(), rank.rankScore);
        }
        return piVector;
    }
}

