/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph;

import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.Tree;
import junit.framework.TestCase;
import org.apache.commons.collections15.Factory;

public abstract class AbstractSparseTreeTest
extends TestCase {
    protected Tree<String, Integer> tree;
    protected Factory<DirectedGraph<String, Integer>> graphFactory;
    protected Factory<Integer> edgeFactory;

    public void testRemoveVertex() {
        this.tree.addVertex((Object)"A");
        this.tree.addEdge(this.edgeFactory.create(), (Object)"A", (Object)"B");
        this.tree.addEdge(this.edgeFactory.create(), (Object)"A", (Object)"C");
        this.tree.addEdge(this.edgeFactory.create(), (Object)"B", (Object)"E");
        this.tree.addEdge(this.edgeFactory.create(), (Object)"B", (Object)"F");
        this.tree.removeVertex((Object)"B");
    }

    public void testSimpleTree() {
        this.tree.addVertex((Object)"A");
        this.tree.addEdge(this.edgeFactory.create(), (Object)"A", (Object)"B");
        this.tree.addEdge(this.edgeFactory.create(), (Object)"A", (Object)"C");
    }

    public void testCreateLoop() {
        try {
            this.tree.addVertex((Object)"A");
            this.tree.addEdge(this.edgeFactory.create(), (Object)"A", (Object)"A");
            AbstractSparseTreeTest.fail((String)"should not be able to addChild(v,v)");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            this.tree.addEdge(this.edgeFactory.create(), (Object)"A", (Object)"B");
            this.tree.addEdge(this.edgeFactory.create(), (Object)"B", (Object)"A");
            AbstractSparseTreeTest.fail((String)"should not allow loop");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testHeightAndDepth() {
        this.tree.addVertex((Object)"V0");
        AbstractSparseTreeTest.assertEquals((int)this.tree.getHeight(), (int)0);
        AbstractSparseTreeTest.assertEquals((int)this.tree.getDepth((Object)"V0"), (int)0);
        this.tree.addEdge(this.edgeFactory.create(), (Object)"V0", (Object)"V1");
        AbstractSparseTreeTest.assertEquals((int)this.tree.getHeight(), (int)1);
        AbstractSparseTreeTest.assertEquals((int)this.tree.getDepth((Object)"V1"), (int)1);
        this.tree.addEdge(this.edgeFactory.create(), (Object)"V0", (Object)"V2");
        AbstractSparseTreeTest.assertEquals((int)this.tree.getHeight(), (int)1);
        AbstractSparseTreeTest.assertEquals((int)this.tree.getDepth((Object)"V2"), (int)1);
        this.tree.addEdge(this.edgeFactory.create(), (Object)"V1", (Object)"V4");
        AbstractSparseTreeTest.assertEquals((int)this.tree.getHeight(), (int)2);
        AbstractSparseTreeTest.assertEquals((int)this.tree.getDepth((Object)"V4"), (int)2);
        this.tree.addEdge(this.edgeFactory.create(), (Object)"V2", (Object)"V3");
        AbstractSparseTreeTest.assertEquals((int)this.tree.getHeight(), (int)2);
        AbstractSparseTreeTest.assertEquals((int)this.tree.getDepth((Object)"V3"), (int)2);
        this.tree.addEdge(this.edgeFactory.create(), (Object)"V2", (Object)"V5");
        AbstractSparseTreeTest.assertEquals((int)this.tree.getHeight(), (int)2);
        AbstractSparseTreeTest.assertEquals((int)this.tree.getDepth((Object)"V5"), (int)2);
        this.tree.addEdge(this.edgeFactory.create(), (Object)"V4", (Object)"V6");
        AbstractSparseTreeTest.assertEquals((int)this.tree.getHeight(), (int)3);
        AbstractSparseTreeTest.assertEquals((int)this.tree.getDepth((Object)"V6"), (int)3);
        this.tree.addEdge(this.edgeFactory.create(), (Object)"V4", (Object)"V7");
        AbstractSparseTreeTest.assertEquals((int)this.tree.getHeight(), (int)3);
        AbstractSparseTreeTest.assertEquals((int)this.tree.getDepth((Object)"V7"), (int)3);
        this.tree.addEdge(this.edgeFactory.create(), (Object)"V3", (Object)"V8");
        AbstractSparseTreeTest.assertEquals((int)this.tree.getHeight(), (int)3);
        AbstractSparseTreeTest.assertEquals((int)this.tree.getDepth((Object)"V8"), (int)3);
        this.tree.addEdge(this.edgeFactory.create(), (Object)"V6", (Object)"V9");
        AbstractSparseTreeTest.assertEquals((int)this.tree.getHeight(), (int)4);
        AbstractSparseTreeTest.assertEquals((int)this.tree.getDepth((Object)"V9"), (int)4);
        this.tree.addEdge(this.edgeFactory.create(), (Object)"V4", (Object)"V10");
        AbstractSparseTreeTest.assertEquals((int)this.tree.getHeight(), (int)4);
        AbstractSparseTreeTest.assertEquals((int)this.tree.getDepth((Object)"V10"), (int)3);
        this.tree.addEdge(this.edgeFactory.create(), (Object)"V4", (Object)"V11");
        AbstractSparseTreeTest.assertEquals((int)this.tree.getHeight(), (int)4);
        AbstractSparseTreeTest.assertEquals((int)this.tree.getDepth((Object)"V11"), (int)3);
        this.tree.addEdge(this.edgeFactory.create(), (Object)"V4", (Object)"V12");
        AbstractSparseTreeTest.assertEquals((int)this.tree.getHeight(), (int)4);
        AbstractSparseTreeTest.assertEquals((int)this.tree.getDepth((Object)"V12"), (int)3);
        this.tree.addEdge(this.edgeFactory.create(), (Object)"V6", (Object)"V13");
        AbstractSparseTreeTest.assertEquals((int)this.tree.getHeight(), (int)4);
        AbstractSparseTreeTest.assertEquals((int)this.tree.getDepth((Object)"V13"), (int)4);
        this.tree.addEdge(this.edgeFactory.create(), (Object)"V10", (Object)"V14");
        AbstractSparseTreeTest.assertEquals((int)this.tree.getHeight(), (int)4);
        AbstractSparseTreeTest.assertEquals((int)this.tree.getDepth((Object)"V14"), (int)4);
        this.tree.addEdge(this.edgeFactory.create(), (Object)"V13", (Object)"V15");
        AbstractSparseTreeTest.assertEquals((int)this.tree.getHeight(), (int)5);
        AbstractSparseTreeTest.assertEquals((int)this.tree.getDepth((Object)"V15"), (int)5);
        this.tree.addEdge(this.edgeFactory.create(), (Object)"V13", (Object)"V16");
        AbstractSparseTreeTest.assertEquals((int)this.tree.getHeight(), (int)5);
        AbstractSparseTreeTest.assertEquals((int)this.tree.getDepth((Object)"V16"), (int)5);
    }
}

