/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph;

import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Hypergraph;
import edu.uci.ics.jung.graph.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import junit.framework.TestCase;
import org.apache.commons.collections15.Factory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHypergraphTest
extends TestCase {
    protected Factory<? extends Hypergraph<Integer, Character>> factory;
    protected Hypergraph<Integer, Character> h;

    public AbstractHypergraphTest(Factory<? extends Hypergraph<Integer, Character>> factory) {
        this.factory = factory;
    }

    public void runTest() throws Exception {
        this.setUp();
        this.testAddVertex();
        this.testAddEdge();
        this.testEdgeEndpoints();
        this.tearDown();
    }

    public void testAddVertex() {
        int count = this.h.getVertexCount();
        AbstractHypergraphTest.assertTrue((boolean)this.h.addVertex((Object)new Integer(1)));
        AbstractHypergraphTest.assertEquals((int)(count + 1), (int)this.h.getVertexCount());
        AbstractHypergraphTest.assertTrue((boolean)this.h.containsVertex((Object)1));
        boolean success = false;
        try {
            success = this.h.addVertex(null);
            AbstractHypergraphTest.fail((String)"Implementation should disallow null vertices");
        }
        catch (IllegalArgumentException iae) {
        }
        catch (NullPointerException npe) {
            AbstractHypergraphTest.fail((String)"Implementation should actively prevent null vertices");
        }
        AbstractHypergraphTest.assertFalse((boolean)success);
        AbstractHypergraphTest.assertFalse((boolean)this.h.addVertex((Object)1));
        AbstractHypergraphTest.assertEquals((int)(count + 1), (int)this.h.getVertexCount());
        AbstractHypergraphTest.assertFalse((boolean)this.h.containsVertex((Object)2));
    }

    public void testAddEdge() {
        int edge_count = this.h.getEdgeCount();
        int vertex_count = this.h.getVertexCount();
        Pair p = new Pair((Object)2, (Object)3);
        AbstractHypergraphTest.assertTrue((boolean)this.h.addEdge((Object)Character.valueOf('a'), (Collection)p));
        AbstractHypergraphTest.assertEquals((int)(edge_count + 1), (int)this.h.getEdgeCount());
        AbstractHypergraphTest.assertEquals((int)(vertex_count + 2), (int)this.h.getVertexCount());
        AbstractHypergraphTest.assertTrue((boolean)this.h.containsEdge((Object)Character.valueOf('a')));
        boolean success = false;
        try {
            success = this.h.addEdge((Object)Character.valueOf('b'), null);
            AbstractHypergraphTest.fail((String)"Implementation should disallow null pairs/collections");
            success = this.h.addEdge(null, (Collection)p);
            AbstractHypergraphTest.fail((String)"Implementation should disallow null edges");
        }
        catch (IllegalArgumentException iae) {
        }
        catch (NullPointerException npe) {
            AbstractHypergraphTest.fail((String)"Implementation should actively prevent null edges, pairs, and collections");
        }
        AbstractHypergraphTest.assertFalse((boolean)success);
        AbstractHypergraphTest.assertFalse((boolean)this.h.addEdge((Object)Character.valueOf('a'), (Collection)new Pair((Object)2, (Object)3)));
        AbstractHypergraphTest.assertFalse((boolean)this.h.addEdge((Object)Character.valueOf('a'), (Collection)p));
        try {
            success = this.h.addEdge((Object)Character.valueOf('a'), (Collection)new Pair((Object)3, (Object)4));
            AbstractHypergraphTest.fail((String)"Implementation should disallow existing edge objects from connecting new pairs/collections");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        AbstractHypergraphTest.assertEquals((int)(edge_count + 1), (int)this.h.getEdgeCount());
        AbstractHypergraphTest.assertFalse((boolean)this.h.containsEdge((Object)Character.valueOf('b')));
    }

    public void testEdgeEndpoints() {
        ArrayList<Integer> c = new ArrayList<Integer>();
        for (int i = 0; i < 10; ++i) {
            try {
                this.h.addEdge((Object)Character.valueOf((char)i), c);
                c.add(i);
                continue;
            }
            catch (IllegalArgumentException iae) {
                if (this.h instanceof Graph) {
                    if (c.size() != 2) continue;
                    AbstractHypergraphTest.fail((String)("improperly rejected incident vertex collection " + c));
                    continue;
                }
                AbstractHypergraphTest.fail((String)"hypergraph implementations should accept any positive number of incident vertices");
            }
        }
    }

    public void testFindEdge() {
    }
}

