/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph;

import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.graph.util.Pair;
import java.util.Collection;
import java.util.Collections;
import junit.framework.TestCase;

public abstract class AbstractDirectedSparseMultigraphTest
extends TestCase {
    protected Integer v0 = new Integer(0);
    protected Integer v1 = new Integer(1);
    protected Integer v2 = new Integer(2);
    protected Float e01 = new Float(0.1f);
    protected Float e10 = new Float(0.2f);
    protected Float e12 = new Float(0.3f);
    protected Float e21 = new Float(0.4f);
    protected Graph<Integer, Number> graph;

    public void testGetEdges() {
        AbstractDirectedSparseMultigraphTest.assertEquals((int)this.graph.getEdgeCount(), (int)4);
    }

    public void testGetVertices() {
        AbstractDirectedSparseMultigraphTest.assertEquals((int)this.graph.getVertexCount(), (int)3);
    }

    public void testAddVertex() {
        int count = this.graph.getVertexCount();
        this.graph.addVertex((Object)new Integer(3));
        AbstractDirectedSparseMultigraphTest.assertEquals((int)this.graph.getVertexCount(), (int)(count + 1));
    }

    public void testRemoveEndVertex() {
        int vertexCount = this.graph.getVertexCount();
        this.graph.removeVertex((Object)this.v0);
        AbstractDirectedSparseMultigraphTest.assertEquals((int)(vertexCount - 1), (int)this.graph.getVertexCount());
        AbstractDirectedSparseMultigraphTest.assertEquals((int)2, (int)this.graph.getEdgeCount());
    }

    public void testRemoveMiddleVertex() {
        int vertexCount = this.graph.getVertexCount();
        this.graph.removeVertex((Object)this.v1);
        AbstractDirectedSparseMultigraphTest.assertEquals((int)(vertexCount - 1), (int)this.graph.getVertexCount());
        AbstractDirectedSparseMultigraphTest.assertEquals((int)0, (int)this.graph.getEdgeCount());
    }

    public void testAddEdge() {
        int edgeCount = this.graph.getEdgeCount();
        this.graph.addEdge((Object)new Double(0.5), (Object)this.v0, (Object)this.v1);
        AbstractDirectedSparseMultigraphTest.assertEquals((int)this.graph.getEdgeCount(), (int)(edgeCount + 1));
    }

    public void testRemoveEdge() {
        int edgeCount = this.graph.getEdgeCount();
        this.graph.removeEdge((Object)this.e12);
        AbstractDirectedSparseMultigraphTest.assertEquals((int)this.graph.getEdgeCount(), (int)(edgeCount - 1));
    }

    public void testNullEndpoint() {
        try {
            this.graph.addEdge((Object)0.99, (Collection)new Pair((Object)1, null));
            AbstractDirectedSparseMultigraphTest.fail((String)"should not be able to add an edge with a null endpoint");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetInEdges() {
        AbstractDirectedSparseMultigraphTest.assertEquals((int)this.graph.getInEdges((Object)this.v1).size(), (int)2);
    }

    public void testGetOutEdges() {
        AbstractDirectedSparseMultigraphTest.assertEquals((int)this.graph.getOutEdges((Object)this.v1).size(), (int)2);
    }

    public void testGetPredecessors() {
        AbstractDirectedSparseMultigraphTest.assertTrue((boolean)this.graph.getPredecessors((Object)this.v0).containsAll(Collections.singleton(this.v1)));
    }

    public void testGetSuccessors() {
        AbstractDirectedSparseMultigraphTest.assertTrue((boolean)this.graph.getPredecessors((Object)this.v1).contains(this.v0));
        AbstractDirectedSparseMultigraphTest.assertTrue((boolean)this.graph.getPredecessors((Object)this.v1).contains(this.v2));
    }

    public void testGetNeighbors() {
        Collection neighbors = this.graph.getNeighbors((Object)this.v1);
        AbstractDirectedSparseMultigraphTest.assertTrue((boolean)neighbors.contains(this.v0));
        AbstractDirectedSparseMultigraphTest.assertTrue((boolean)neighbors.contains(this.v2));
    }

    public void testGetIncidentEdges() {
        AbstractDirectedSparseMultigraphTest.assertEquals((int)this.graph.getIncidentEdges((Object)this.v0).size(), (int)2);
    }

    public void testFindEdge() {
        Number edge = (Number)this.graph.findEdge((Object)this.v1, (Object)this.v2);
        AbstractDirectedSparseMultigraphTest.assertTrue((edge == this.e12 || edge == this.e21 ? 1 : 0) != 0);
    }

    public void testGetEndpoints() {
        Pair endpoints = this.graph.getEndpoints((Object)this.e01);
        AbstractDirectedSparseMultigraphTest.assertTrue((endpoints.getFirst() == this.v0 && endpoints.getSecond() == this.v1 || endpoints.getFirst() == this.v1 && endpoints.getSecond() == this.v0 ? 1 : 0) != 0);
    }

    public void testIsDirected() {
        for (Number edge : this.graph.getEdges()) {
            AbstractDirectedSparseMultigraphTest.assertEquals((Object)this.graph.getEdgeType((Object)edge), (Object)EdgeType.DIRECTED);
        }
    }

    public void testAddDirectedEdge() {
        Float edge = new Float(0.9);
        this.graph.addEdge((Object)edge, (Object)this.v1, (Object)this.v2, EdgeType.DIRECTED);
        AbstractDirectedSparseMultigraphTest.assertEquals((Object)this.graph.getEdgeType((Object)edge), (Object)EdgeType.DIRECTED);
    }

    public void testAddUndirectedEdge() {
        try {
            this.graph.addEdge((Object)new Float(0.9), (Object)this.v1, (Object)this.v2, EdgeType.UNDIRECTED);
            AbstractDirectedSparseMultigraphTest.fail((String)"Cannot add an undirected edge to this graph");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

