/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.decorators;

import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.algorithms.util.SelfLoopEdgePredicate;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.Context;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.graph.util.Pair;
import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.renderers.BasicEdgeRenderer;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.geom.Point2D;
import org.apache.commons.collections15.Predicate;
import org.apache.commons.collections15.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GradientEdgePaintRenderer<V, E>
extends BasicEdgeRenderer<V, E>
implements Renderer.Edge<V, E>,
Transformer<E, Paint> {
    protected Color c1;
    protected Color c2;
    protected VisualizationViewer<V, E> vv;
    protected Predicate<Context<Graph<V, E>, E>> selfLoop = new SelfLoopEdgePredicate();
    protected Graph<V, E> graph;
    protected float xB;
    protected float yB;
    protected float xF;
    protected float yF;

    public GradientEdgePaintRenderer(Color c1, Color c2, VisualizationViewer<V, E> vv) {
        this.c1 = c1;
        this.c2 = c2;
        this.vv = vv;
    }

    @Override
    public Paint transform(E e) {
        return this.getGradientPaint(e, this.graph, this.xB, this.yB, this.xF, this.yF);
    }

    private Paint getGradientPaint(E e, Graph<V, E> graph, float xB, float yB, float xF, float yF) {
        if (graph.getEdgeType(e) == EdgeType.UNDIRECTED) {
            xF = (xF + xB) / 2.0f;
            yF = (yF + yB) / 2.0f;
        }
        if (this.selfLoop.evaluate(Context.getInstance(graph, e))) {
            yF += 50.0f;
            xF += 50.0f;
        }
        return new GradientPaint(xB, yB, this.c1, xF, yF, this.c2, true);
    }

    @Override
    public void paintEdge(RenderContext<V, E> rc, Layout<V, E> layout, E e) {
        Graph graph = layout.getGraph();
        Pair endpoints = graph.getEndpoints(e);
        Object v1 = endpoints.getFirst();
        Object v2 = endpoints.getSecond();
        Point2D p1 = (Point2D)layout.transform(v1);
        Point2D p2 = (Point2D)layout.transform(v2);
        p1 = rc.getMultiLayerTransformer().transform(Layer.LAYOUT, p1);
        p2 = rc.getMultiLayerTransformer().transform(Layer.LAYOUT, p2);
        float x1 = (float)p1.getX();
        float y1 = (float)p1.getY();
        float x2 = (float)p2.getX();
        float y2 = (float)p2.getY();
        this.xB = x1;
        this.yB = y1;
        this.xF = x2;
        this.yF = y2;
        this.graph = graph;
        Transformer<E, Paint> oldEdgeDrawPaintTransformer = rc.getEdgeDrawPaintTransformer();
        Transformer<E, Paint> oldEdgeFillPaintTransformer = rc.getEdgeFillPaintTransformer();
        rc.setEdgeDrawPaintTransformer(this);
        rc.setEdgeFillPaintTransformer(this);
        super.drawSimpleEdge(rc, layout, e);
        rc.setEdgeDrawPaintTransformer(oldEdgeDrawPaintTransformer);
        rc.setEdgeFillPaintTransformer(oldEdgeFillPaintTransformer);
    }
}

