/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization;

import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.visualization.BasicVisualizationServer;
import edu.uci.ics.jung.visualization.Layer;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VisualizationImageServer<V, E>
extends BasicVisualizationServer<V, E> {
    Map renderingHints = new HashMap();

    public VisualizationImageServer(Layout<V, E> layout, Dimension preferredSize) {
        super(layout, preferredSize);
        this.setSize(preferredSize);
        this.renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.addNotify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getImage(Point2D center, Dimension d) {
        int width = this.getWidth();
        int height = this.getHeight();
        float scalex = (float)width / (float)d.width;
        float scaley = (float)height / (float)d.height;
        try {
            this.renderContext.getMultiLayerTransformer().getTransformer(Layer.VIEW).scale(scalex, scaley, center);
            BufferedImage bi = new BufferedImage(width, height, 1);
            Graphics2D graphics = bi.createGraphics();
            graphics.setRenderingHints(this.renderingHints);
            this.paint(graphics);
            graphics.dispose();
            BufferedImage bufferedImage = bi;
            return bufferedImage;
        }
        finally {
            this.renderContext.getMultiLayerTransformer().getTransformer(Layer.VIEW).setToIdentity();
        }
    }
}

