/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.samples;

import edu.uci.ics.jung.algorithms.layout.PolarPoint;
import edu.uci.ics.jung.algorithms.layout.RadialTreeLayout;
import edu.uci.ics.jung.algorithms.layout.TreeLayout;
import edu.uci.ics.jung.graph.DelegateForest;
import edu.uci.ics.jung.graph.DelegateTree;
import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.DirectedSparseGraph;
import edu.uci.ics.jung.graph.Forest;
import edu.uci.ics.jung.graph.Tree;
import edu.uci.ics.jung.visualization.DefaultVisualizationModel;
import edu.uci.ics.jung.visualization.GraphZoomScrollPane;
import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.VisualizationModel;
import edu.uci.ics.jung.visualization.VisualizationServer;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.CrossoverScalingControl;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.control.ModalGraphMouse;
import edu.uci.ics.jung.visualization.control.ModalLensGraphMouse;
import edu.uci.ics.jung.visualization.control.ScalingControl;
import edu.uci.ics.jung.visualization.decorators.EdgeShape;
import edu.uci.ics.jung.visualization.decorators.PickableEdgePaintTransformer;
import edu.uci.ics.jung.visualization.decorators.PickableVertexPaintTransformer;
import edu.uci.ics.jung.visualization.decorators.ToStringLabeller;
import edu.uci.ics.jung.visualization.picking.PickedInfo;
import edu.uci.ics.jung.visualization.picking.PickedState;
import edu.uci.ics.jung.visualization.transform.LensSupport;
import edu.uci.ics.jung.visualization.transform.LensTransformer;
import edu.uci.ics.jung.visualization.transform.shape.HyperbolicShapeTransformer;
import edu.uci.ics.jung.visualization.transform.shape.ViewLensSupport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.apache.commons.collections15.Factory;
import org.apache.commons.collections15.Transformer;
import org.apache.commons.collections15.TransformerUtils;
import org.apache.commons.collections15.functors.ConstantTransformer;

public class RadialTreeLensDemo
extends JApplet {
    Forest<String, Integer> graph;
    Factory<DirectedGraph<String, Integer>> graphFactory = new Factory<DirectedGraph<String, Integer>>(){

        @Override
        public DirectedGraph<String, Integer> create() {
            return new DirectedSparseGraph();
        }
    };
    Factory<Tree<String, Integer>> treeFactory = new Factory<Tree<String, Integer>>(){

        @Override
        public Tree<String, Integer> create() {
            return new DelegateTree(RadialTreeLensDemo.this.graphFactory);
        }
    };
    Factory<Integer> edgeFactory = new Factory<Integer>(){
        int i = 0;

        @Override
        public Integer create() {
            return this.i++;
        }
    };
    Factory<String> vertexFactory = new Factory<String>(){
        int i = 0;

        @Override
        public String create() {
            return "V" + this.i++;
        }
    };
    VisualizationServer.Paintable rings;
    String root;
    TreeLayout<String, Integer> layout;
    RadialTreeLayout<String, Integer> radialLayout;
    VisualizationViewer<String, Integer> vv;
    LensSupport hyperbolicViewSupport;
    ScalingControl scaler;

    public RadialTreeLensDemo() {
        this.graph = new DelegateForest();
        this.createTree();
        this.layout = new TreeLayout(this.graph);
        this.radialLayout = new RadialTreeLayout(this.graph);
        this.radialLayout.setSize(new Dimension(600, 600));
        Dimension preferredSize = new Dimension(600, 600);
        HashMap map = new HashMap();
        Transformer vlf = TransformerUtils.mapTransformer(map);
        DefaultVisualizationModel visualizationModel = new DefaultVisualizationModel(this.radialLayout, preferredSize);
        this.vv = new VisualizationViewer((VisualizationModel)visualizationModel, preferredSize);
        PickedState ps = this.vv.getPickedVertexState();
        PickedState pes = this.vv.getPickedEdgeState();
        this.vv.getRenderContext().setVertexFillPaintTransformer((Transformer)new PickableVertexPaintTransformer((PickedInfo)ps, (Paint)Color.red, (Paint)Color.yellow));
        this.vv.getRenderContext().setEdgeDrawPaintTransformer((Transformer)new PickableEdgePaintTransformer((PickedInfo)pes, (Paint)Color.black, (Paint)Color.cyan));
        this.vv.setBackground(Color.white);
        this.vv.getRenderContext().setVertexLabelTransformer((Transformer)new ToStringLabeller());
        this.vv.getRenderContext().setEdgeShapeTransformer((Transformer)new EdgeShape.Line());
        Transformer ovals = this.vv.getRenderContext().getVertexShapeTransformer();
        ConstantTransformer<Rectangle2D.Float> squares = new ConstantTransformer<Rectangle2D.Float>(new Rectangle2D.Float(-10.0f, -10.0f, 20.0f, 20.0f));
        this.vv.setVertexToolTipTransformer((Transformer)new ToStringLabeller());
        Container content = this.getContentPane();
        GraphZoomScrollPane gzsp = new GraphZoomScrollPane(this.vv);
        content.add((Component)gzsp);
        DefaultModalGraphMouse graphMouse = new DefaultModalGraphMouse();
        this.vv.setGraphMouse((VisualizationViewer.GraphMouse)graphMouse);
        this.vv.addKeyListener(graphMouse.getModeKeyListener());
        this.rings = new Rings();
        this.vv.addPreRenderPaintable(this.rings);
        this.hyperbolicViewSupport = new ViewLensSupport(this.vv, (LensTransformer)new HyperbolicShapeTransformer(this.vv, this.vv.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.VIEW)), (ModalGraphMouse)new ModalLensGraphMouse());
        CrossoverScalingControl scaler = new CrossoverScalingControl();
        JButton plus = new JButton("+");
        plus.addActionListener(new ActionListener((ScalingControl)scaler){
            final /* synthetic */ ScalingControl val$scaler;
            {
                this.val$scaler = scalingControl;
            }

            public void actionPerformed(ActionEvent e) {
                this.val$scaler.scale(RadialTreeLensDemo.this.vv, 1.1f, RadialTreeLensDemo.this.vv.getCenter());
            }
        });
        JButton minus = new JButton("-");
        minus.addActionListener(new ActionListener((ScalingControl)scaler){
            final /* synthetic */ ScalingControl val$scaler;
            {
                this.val$scaler = scalingControl;
            }

            public void actionPerformed(ActionEvent e) {
                this.val$scaler.scale(RadialTreeLensDemo.this.vv, 0.9090909f, RadialTreeLensDemo.this.vv.getCenter());
            }
        });
        JRadioButton hyperView = new JRadioButton("Hyperbolic View");
        hyperView.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                RadialTreeLensDemo.this.hyperbolicViewSupport.activate(e.getStateChange() == 1);
            }
        });
        graphMouse.addItemListener(this.hyperbolicViewSupport.getGraphMouse().getModeListener());
        JMenuBar menubar = new JMenuBar();
        menubar.add(graphMouse.getModeMenu());
        gzsp.setCorner((JComponent)menubar);
        JPanel controls = new JPanel();
        JPanel zoomControls = new JPanel(new GridLayout(2, 1));
        zoomControls.setBorder(BorderFactory.createTitledBorder("Zoom"));
        JPanel hyperControls = new JPanel(new GridLayout(3, 2));
        hyperControls.setBorder(BorderFactory.createTitledBorder("Examiner Lens"));
        zoomControls.add(plus);
        zoomControls.add(minus);
        JPanel modeControls = new JPanel(new BorderLayout());
        modeControls.setBorder(BorderFactory.createTitledBorder("Mouse Mode"));
        modeControls.add(graphMouse.getModeComboBox());
        hyperControls.add(hyperView);
        controls.add(zoomControls);
        controls.add(hyperControls);
        controls.add(modeControls);
        content.add((Component)controls, "South");
    }

    private void createTree() {
        this.graph.addVertex("V0");
        this.graph.addEdge(this.edgeFactory.create(), "V0", "V1");
        this.graph.addEdge(this.edgeFactory.create(), "V0", "V2");
        this.graph.addEdge(this.edgeFactory.create(), "V1", "V4");
        this.graph.addEdge(this.edgeFactory.create(), "V2", "V3");
        this.graph.addEdge(this.edgeFactory.create(), "V2", "V5");
        this.graph.addEdge(this.edgeFactory.create(), "V4", "V6");
        this.graph.addEdge(this.edgeFactory.create(), "V4", "V7");
        this.graph.addEdge(this.edgeFactory.create(), "V3", "V8");
        this.graph.addEdge(this.edgeFactory.create(), "V6", "V9");
        this.graph.addEdge(this.edgeFactory.create(), "V4", "V10");
        this.graph.addVertex("A0");
        this.graph.addEdge(this.edgeFactory.create(), "A0", "A1");
        this.graph.addEdge(this.edgeFactory.create(), "A0", "A2");
        this.graph.addEdge(this.edgeFactory.create(), "A0", "A3");
        this.graph.addVertex("B0");
        this.graph.addEdge(this.edgeFactory.create(), "B0", "B1");
        this.graph.addEdge(this.edgeFactory.create(), "B0", "B2");
        this.graph.addEdge(this.edgeFactory.create(), "B1", "B4");
        this.graph.addEdge(this.edgeFactory.create(), "B2", "B3");
        this.graph.addEdge(this.edgeFactory.create(), "B2", "B5");
        this.graph.addEdge(this.edgeFactory.create(), "B4", "B6");
        this.graph.addEdge(this.edgeFactory.create(), "B4", "B7");
        this.graph.addEdge(this.edgeFactory.create(), "B3", "B8");
        this.graph.addEdge(this.edgeFactory.create(), "B6", "B9");
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        f.getContentPane().add(new RadialTreeLensDemo());
        f.pack();
        f.setVisible(true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Rings
    implements VisualizationServer.Paintable {
        Collection<Double> depths = this.getDepths();

        private Collection<Double> getDepths() {
            HashSet<Double> depths = new HashSet<Double>();
            Map polarLocations = RadialTreeLensDemo.this.radialLayout.getPolarLocations();
            for (String v : RadialTreeLensDemo.this.graph.getVertices()) {
                PolarPoint pp = (PolarPoint)polarLocations.get(v);
                depths.add(pp.getRadius());
            }
            return depths;
        }

        public void paint(Graphics g) {
            g.setColor(Color.gray);
            Graphics2D g2d = (Graphics2D)g;
            Point2D center = RadialTreeLensDemo.this.radialLayout.getCenter();
            Ellipse2D.Double ellipse = new Ellipse2D.Double();
            for (double d : this.depths) {
                ellipse.setFrameFromDiagonal(center.getX() - d, center.getY() - d, center.getX() + d, center.getY() + d);
                Shape shape = RadialTreeLensDemo.this.vv.getRenderContext().getMultiLayerTransformer().transform((Shape)ellipse);
                g2d.draw(shape);
            }
        }

        public boolean useTransform() {
            return true;
        }
    }
}

