/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.samples;

import edu.uci.ics.jung.algorithms.layout.AbstractLayout;
import edu.uci.ics.jung.algorithms.layout.FRLayout;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.algorithms.layout.SpringLayout;
import edu.uci.ics.jung.algorithms.layout.StaticLayout;
import edu.uci.ics.jung.algorithms.layout.util.VisRunner;
import edu.uci.ics.jung.algorithms.util.IterativeContext;
import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.DirectedSparseMultigraph;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.ObservableGraph;
import edu.uci.ics.jung.graph.event.GraphEvent;
import edu.uci.ics.jung.graph.event.GraphEventListener;
import edu.uci.ics.jung.graph.util.Graphs;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.decorators.ToStringLabeller;
import edu.uci.ics.jung.visualization.layout.LayoutTransition;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import edu.uci.ics.jung.visualization.util.Animator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import org.apache.commons.collections15.Transformer;

public class AnimatingAddNodeDemo
extends JApplet {
    private static final long serialVersionUID = -5345319851341875800L;
    private Graph<Number, Number> g = null;
    private VisualizationViewer<Number, Number> vv = null;
    private AbstractLayout<Number, Number> layout = null;
    Timer timer;
    boolean done;
    protected JButton switchLayout;
    public static final SpringLayout.LengthFunction<Number> UNITLENGTHFUNCTION = new SpringLayout.UnitLengthFunction(100);
    Integer v_prev = null;

    public void init() {
        DirectedGraph ig = Graphs.synchronizedDirectedGraph(new DirectedSparseMultigraph());
        ObservableGraph<Number, Number> og = new ObservableGraph<Number, Number>(ig);
        og.addGraphEventListener(new GraphEventListener<Number, Number>(){

            @Override
            public void handleGraphEvent(GraphEvent<Number, Number> evt) {
                System.err.println("got " + evt);
            }
        });
        this.g = og;
        this.layout = new FRLayout(this.g);
        this.layout.setSize(new Dimension(600, 600));
        VisRunner relaxer = new VisRunner((IterativeContext)this.layout);
        relaxer.stop();
        relaxer.prerelax();
        StaticLayout staticLayout = new StaticLayout(this.g, this.layout);
        this.vv = new VisualizationViewer((Layout)staticLayout, new Dimension(600, 600));
        JRootPane rp = this.getRootPane();
        rp.putClientProperty("defeatSystemEventQueueCheck", Boolean.TRUE);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().setBackground(Color.lightGray);
        this.getContentPane().setFont(new Font("Serif", 0, 12));
        this.vv.setGraphMouse((VisualizationViewer.GraphMouse)new DefaultModalGraphMouse());
        this.vv.getRenderer().getVertexLabelRenderer().setPosition(Renderer.VertexLabel.Position.CNTR);
        this.vv.getRenderContext().setVertexLabelTransformer((Transformer)new ToStringLabeller());
        this.vv.setForeground(Color.white);
        this.vv.addComponentListener((ComponentListener)new ComponentAdapter(){

            public void componentResized(ComponentEvent arg0) {
                super.componentResized(arg0);
                System.err.println("resized");
                AnimatingAddNodeDemo.this.layout.setSize(arg0.getComponent().getSize());
            }
        });
        this.getContentPane().add((Component)this.vv);
        this.switchLayout = new JButton("Switch to SpringLayout");
        this.switchLayout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                Dimension d = AnimatingAddNodeDemo.this.vv.getSize();
                if (AnimatingAddNodeDemo.this.switchLayout.getText().indexOf("Spring") > 0) {
                    AnimatingAddNodeDemo.this.switchLayout.setText("Switch to FRLayout");
                    AnimatingAddNodeDemo.this.layout = (AbstractLayout)new SpringLayout(AnimatingAddNodeDemo.this.g, UNITLENGTHFUNCTION);
                    AnimatingAddNodeDemo.this.layout.setSize(d);
                    VisRunner relaxer = new VisRunner((IterativeContext)AnimatingAddNodeDemo.this.layout);
                    relaxer.stop();
                    relaxer.prerelax();
                    StaticLayout staticLayout = new StaticLayout(AnimatingAddNodeDemo.this.g, (Transformer)AnimatingAddNodeDemo.this.layout);
                    LayoutTransition lt = new LayoutTransition(AnimatingAddNodeDemo.this.vv, AnimatingAddNodeDemo.this.vv.getGraphLayout(), (Layout)staticLayout);
                    Animator animator = new Animator((IterativeContext)lt);
                    animator.start();
                    AnimatingAddNodeDemo.this.vv.repaint();
                } else {
                    AnimatingAddNodeDemo.this.switchLayout.setText("Switch to SpringLayout");
                    AnimatingAddNodeDemo.this.layout = (AbstractLayout)new FRLayout(AnimatingAddNodeDemo.this.g, d);
                    AnimatingAddNodeDemo.this.layout.setSize(d);
                    VisRunner relaxer = new VisRunner((IterativeContext)AnimatingAddNodeDemo.this.layout);
                    relaxer.stop();
                    relaxer.prerelax();
                    StaticLayout staticLayout = new StaticLayout(AnimatingAddNodeDemo.this.g, (Transformer)AnimatingAddNodeDemo.this.layout);
                    LayoutTransition lt = new LayoutTransition(AnimatingAddNodeDemo.this.vv, AnimatingAddNodeDemo.this.vv.getGraphLayout(), (Layout)staticLayout);
                    Animator animator = new Animator((IterativeContext)lt);
                    animator.start();
                    AnimatingAddNodeDemo.this.vv.repaint();
                }
            }
        });
        this.getContentPane().add((Component)this.switchLayout, "South");
        this.timer = new Timer();
    }

    public void start() {
        this.validate();
        this.timer.schedule((TimerTask)new RemindTask(), 1000L, 1000L);
        this.vv.repaint();
    }

    public void process() {
        this.vv.getRenderContext().getPickedVertexState().clear();
        this.vv.getRenderContext().getPickedEdgeState().clear();
        try {
            if (this.g.getVertexCount() < 100) {
                Integer v1 = new Integer(this.g.getVertexCount());
                this.g.addVertex(v1);
                this.vv.getRenderContext().getPickedVertexState().pick((Object)v1, true);
                if (this.v_prev != null) {
                    Integer edge = this.g.getEdgeCount();
                    this.vv.getRenderContext().getPickedEdgeState().pick((Object)edge, true);
                    this.g.addEdge((Number)edge, this.v_prev, v1);
                    int rand = (int)(Math.random() * (double)this.g.getVertexCount());
                    edge = this.g.getEdgeCount();
                    this.vv.getRenderContext().getPickedEdgeState().pick((Object)edge, true);
                    this.g.addEdge((Number)edge, v1, rand);
                }
                this.v_prev = v1;
                this.layout.initialize();
                VisRunner relaxer = new VisRunner((IterativeContext)this.layout);
                relaxer.stop();
                relaxer.prerelax();
                StaticLayout staticLayout = new StaticLayout(this.g, this.layout);
                LayoutTransition lt = new LayoutTransition(this.vv, this.vv.getGraphLayout(), (Layout)staticLayout);
                Animator animator = new Animator((IterativeContext)lt);
                animator.start();
                this.vv.repaint();
            } else {
                this.done = true;
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public static void main(String[] args) {
        AnimatingAddNodeDemo and = new AnimatingAddNodeDemo();
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add(and);
        and.init();
        and.start();
        frame.pack();
        frame.setVisible(true);
    }

    class RemindTask
    extends TimerTask {
        RemindTask() {
        }

        public void run() {
            AnimatingAddNodeDemo.this.process();
            if (AnimatingAddNodeDemo.this.done) {
                this.cancel();
            }
        }
    }
}

