/*
 * Decompiled with CFR 0.152.
 */
package samples.graph.jai;

import edu.uci.ics.jung.algorithms.layout.FRLayout;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.graph.DirectedSparseMultigraph;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.visualization.GraphZoomScrollPane;
import edu.uci.ics.jung.visualization.LayeredIcon;
import edu.uci.ics.jung.visualization.VisualizationServer;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.CrossoverScalingControl;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.control.ScalingControl;
import edu.uci.ics.jung.visualization.decorators.DefaultVertexIconTransformer;
import edu.uci.ics.jung.visualization.decorators.EllipseVertexShapeTransformer;
import edu.uci.ics.jung.visualization.decorators.ToStringLabeller;
import edu.uci.ics.jung.visualization.decorators.VertexIconShapeTransformer;
import edu.uci.ics.jung.visualization.jai.PerspectiveImageLensSupport;
import edu.uci.ics.jung.visualization.jai.PerspectiveLayoutTransformSupport;
import edu.uci.ics.jung.visualization.jai.PerspectiveTransformSupport;
import edu.uci.ics.jung.visualization.picking.PickedState;
import edu.uci.ics.jung.visualization.renderers.Checkmark;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Map;
import javax.media.jai.PerspectiveTransform;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.collections15.Transformer;

public class PerspectiveVertexImageShaperDemo
extends JApplet {
    private static final long serialVersionUID = -1943329822820885759L;
    Graph<Number, Number> graph;
    VisualizationViewer<Number, Number> vv;
    String[] iconNames = new String[]{"apple", "os", "x", "linux", "inputdevices", "wireless", "graphics3", "gamespcgames", "humor", "music", "privacy"};
    PerspectiveTransformSupport viewSupport;
    PerspectiveTransformSupport layoutSupport;

    public PerspectiveVertexImageShaperDemo() {
        this.graph = new DirectedSparseMultigraph();
        Number[] vertices = this.createVertices(11);
        HashMap<Number, String> map = new HashMap<Number, String>();
        for (int i = 0; i < vertices.length; ++i) {
            map.put(vertices[i], this.iconNames[i % this.iconNames.length]);
        }
        HashMap<Number, LayeredIcon> iconMap = new HashMap<Number, LayeredIcon>();
        for (int i = 0; i < vertices.length; ++i) {
            String name = "/images/topic" + this.iconNames[i] + ".gif";
            try {
                LayeredIcon icon = new LayeredIcon(new ImageIcon(PerspectiveVertexImageShaperDemo.class.getResource(name)).getImage());
                iconMap.put(vertices[i], icon);
                continue;
            }
            catch (Exception ex) {
                System.err.println("You need slashdoticons.jar in your classpath to see the image " + name);
            }
        }
        this.createEdges(vertices);
        final VertexStringerImpl vertexStringerImpl = new VertexStringerImpl(map);
        VertexIconShapeTransformer vertexImageShapeFunction = new VertexIconShapeTransformer((Transformer)new EllipseVertexShapeTransformer());
        FRLayout layout = new FRLayout(this.graph);
        layout.setMaxIterations(100);
        this.vv = new VisualizationViewer((Layout)layout, new Dimension(400, 400));
        this.vv.setBackground(Color.decode("0xffffdd"));
        DefaultVertexIconTransformer vertexIconFunction = new DefaultVertexIconTransformer();
        vertexImageShapeFunction.setIconMap(iconMap);
        vertexIconFunction.setIconMap(iconMap);
        this.vv.getRenderContext().setVertexShapeTransformer((Transformer)vertexImageShapeFunction);
        this.vv.getRenderContext().setVertexIconTransformer((Transformer)vertexIconFunction);
        this.vv.getRenderContext().setVertexLabelTransformer(vertexStringerImpl);
        PickedState ps = this.vv.getPickedVertexState();
        ps.addItemListener((ItemListener)new PickWithIconListener((DefaultVertexIconTransformer<Number>)vertexIconFunction));
        this.vv.addPostRenderPaintable(new VisualizationServer.Paintable(){
            int x;
            int y;
            Font font;
            FontMetrics metrics;
            int swidth;
            int sheight;
            String str = "Thank You, slashdot.org, for the images!";

            public void paint(Graphics g) {
                Dimension d = PerspectiveVertexImageShaperDemo.this.vv.getSize();
                if (this.font == null) {
                    this.font = new Font(g.getFont().getName(), 1, 20);
                    this.metrics = g.getFontMetrics(this.font);
                    this.swidth = this.metrics.stringWidth(this.str);
                    this.sheight = this.metrics.getMaxAscent() + this.metrics.getMaxDescent();
                    this.x = (d.width - this.swidth) / 2;
                    this.y = (int)((double)d.height - (double)this.sheight * 1.5);
                }
                g.setFont(this.font);
                Color oldColor = g.getColor();
                g.setColor(Color.lightGray);
                g.drawString(this.str, this.x, this.y);
                g.setColor(oldColor);
            }

            public boolean useTransform() {
                return false;
            }
        });
        this.vv.setVertexToolTipTransformer((Transformer)new ToStringLabeller());
        Container content = this.getContentPane();
        GraphZoomScrollPane panel = new GraphZoomScrollPane(this.vv);
        content.add((Component)panel);
        DefaultModalGraphMouse graphMouse = new DefaultModalGraphMouse();
        this.vv.setGraphMouse((VisualizationViewer.GraphMouse)graphMouse);
        this.viewSupport = new PerspectiveImageLensSupport(this.vv);
        this.layoutSupport = new PerspectiveLayoutTransformSupport(this.vv);
        CrossoverScalingControl scaler = new CrossoverScalingControl();
        JButton plus = new JButton("+");
        plus.addActionListener(new ActionListener((ScalingControl)scaler){
            final /* synthetic */ ScalingControl val$scaler;
            {
                this.val$scaler = scalingControl;
            }

            public void actionPerformed(ActionEvent e) {
                this.val$scaler.scale(PerspectiveVertexImageShaperDemo.this.vv, 1.1f, PerspectiveVertexImageShaperDemo.this.vv.getCenter());
            }
        });
        JButton minus = new JButton("-");
        minus.addActionListener(new ActionListener((ScalingControl)scaler){
            final /* synthetic */ ScalingControl val$scaler;
            {
                this.val$scaler = scalingControl;
            }

            public void actionPerformed(ActionEvent e) {
                this.val$scaler.scale(PerspectiveVertexImageShaperDemo.this.vv, 0.9f, PerspectiveVertexImageShaperDemo.this.vv.getCenter());
            }
        });
        final JSlider horizontalSlider = new JSlider(-120, 120, 0){

            public Dimension getPreferredSize() {
                return new Dimension(80, super.getPreferredSize().height);
            }
        };
        final JSlider verticalSlider = new JSlider(-120, 120, 0){

            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, 80);
            }
        };
        verticalSlider.setOrientation(1);
        ChangeListener changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                int vval = -verticalSlider.getValue();
                int hval = horizontalSlider.getValue();
                Dimension d = PerspectiveVertexImageShaperDemo.this.vv.getSize();
                PerspectiveTransform pt = null;
                pt = PerspectiveTransform.getQuadToQuad((float)vval, (float)hval, (float)(d.width - vval), (float)(-hval), (float)(d.width + vval), (float)(d.height + hval), (float)(-vval), (float)(d.height - hval), (float)0.0f, (float)0.0f, (float)d.width, (float)0.0f, (float)d.width, (float)d.height, (float)0.0f, (float)d.height);
                PerspectiveVertexImageShaperDemo.this.viewSupport.getPerspectiveTransformer().setPerspectiveTransform(pt);
                PerspectiveVertexImageShaperDemo.this.layoutSupport.getPerspectiveTransformer().setPerspectiveTransform(pt);
                PerspectiveVertexImageShaperDemo.this.vv.repaint();
            }
        };
        horizontalSlider.addChangeListener(changeListener);
        verticalSlider.addChangeListener(changeListener);
        JPanel perspectivePanel = new JPanel(new BorderLayout());
        JPanel perspectiveCenterPanel = new JPanel(new BorderLayout());
        perspectivePanel.setBorder(BorderFactory.createTitledBorder("Perspective Controls"));
        final JButton center = new JButton("Center");
        center.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                horizontalSlider.setValue(0);
                verticalSlider.setValue(0);
            }
        });
        JCheckBox noText = new JCheckBox("No Text");
        noText.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                JCheckBox cb = (JCheckBox)e.getSource();
                vertexStringerImpl.setEnabled(!cb.isSelected());
                PerspectiveVertexImageShaperDemo.this.vv.repaint();
            }
        });
        JPanel centerPanel = new JPanel();
        centerPanel.add(noText);
        ButtonGroup radio = new ButtonGroup();
        JRadioButton none = new JRadioButton("None");
        none.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                boolean selected;
                boolean bl = selected = e.getStateChange() == 1;
                if (selected) {
                    if (PerspectiveVertexImageShaperDemo.this.viewSupport != null) {
                        PerspectiveVertexImageShaperDemo.this.viewSupport.deactivate();
                    }
                    if (PerspectiveVertexImageShaperDemo.this.layoutSupport != null) {
                        PerspectiveVertexImageShaperDemo.this.layoutSupport.deactivate();
                    }
                }
                center.setEnabled(!selected);
                horizontalSlider.setEnabled(!selected);
                verticalSlider.setEnabled(!selected);
            }
        });
        none.setSelected(true);
        JRadioButton hyperView = new JRadioButton("View");
        hyperView.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                PerspectiveVertexImageShaperDemo.this.viewSupport.activate(e.getStateChange() == 1);
            }
        });
        JRadioButton hyperModel = new JRadioButton("Layout");
        hyperModel.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                PerspectiveVertexImageShaperDemo.this.layoutSupport.activate(e.getStateChange() == 1);
            }
        });
        radio.add(none);
        radio.add(hyperView);
        radio.add(hyperModel);
        JMenuBar menubar = new JMenuBar();
        JMenu modeMenu = graphMouse.getModeMenu();
        menubar.add(modeMenu);
        panel.setCorner((JComponent)menubar);
        JPanel scaleGrid = new JPanel(new GridLayout(2, 0));
        scaleGrid.setBorder(BorderFactory.createTitledBorder("Zoom"));
        JPanel controls = new JPanel(new BorderLayout());
        scaleGrid.add(plus);
        scaleGrid.add(minus);
        controls.add((Component)scaleGrid, "West");
        JPanel lensPanel = new JPanel(new GridLayout(2, 0));
        lensPanel.add(none);
        lensPanel.add(hyperView);
        lensPanel.add(hyperModel);
        perspectivePanel.add((Component)lensPanel, "West");
        perspectiveCenterPanel.add((Component)horizontalSlider, "South");
        perspectivePanel.add((Component)verticalSlider, "East");
        perspectiveCenterPanel.add(center);
        perspectivePanel.add(perspectiveCenterPanel);
        controls.add((Component)perspectivePanel, "East");
        controls.add(centerPanel);
        content.add((Component)controls, "South");
    }

    private Number[] createVertices(int count) {
        Number[] v = new Number[count];
        for (int i = 0; i < count; ++i) {
            v[i] = new Integer(i);
            this.graph.addVertex(v[i]);
        }
        return v;
    }

    void createEdges(Number[] v) {
        this.graph.addEdge(new Double(Math.random()), v[0], v[1], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[3], v[0], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[0], v[4], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[4], v[5], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[5], v[3], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[2], v[1], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[4], v[1], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[8], v[2], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[3], v[8], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[6], v[7], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[7], v[5], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[0], v[9], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[9], v[8], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[7], v[6], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[6], v[5], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[4], v[2], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[5], v[4], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[4], v[10], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[10], v[4], EdgeType.DIRECTED);
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        Container content = frame.getContentPane();
        frame.setDefaultCloseOperation(3);
        content.add(new PerspectiveVertexImageShaperDemo());
        frame.pack();
        frame.setVisible(true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PickWithIconListener
    implements ItemListener {
        DefaultVertexIconTransformer<Number> imager;
        Icon checked;

        public PickWithIconListener(DefaultVertexIconTransformer<Number> imager) {
            this.imager = imager;
            this.checked = new Checkmark(Color.red);
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            Icon icon = this.imager.transform((Object)((Number)e.getItem()));
            if (icon != null && icon instanceof LayeredIcon) {
                if (e.getStateChange() == 1) {
                    ((LayeredIcon)icon).add(this.checked);
                } else {
                    ((LayeredIcon)icon).remove(this.checked);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class VertexStringerImpl<V>
    implements Transformer<V, String> {
        Map<V, String> map = new HashMap<V, String>();
        boolean enabled = true;

        public VertexStringerImpl(Map<V, String> map) {
            this.map = map;
        }

        @Override
        public String transform(Object v) {
            if (this.isEnabled()) {
                return this.map.get(v);
            }
            return "";
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }
}

