/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.util;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.jgraph.JGraph;
import org.jgraph.graph.AbstractCellView;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellView;
import org.jgraph.graph.DefaultEdge;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;

public class ParallelEdgeRouter
extends DefaultEdge.LoopRouting {
    protected static final ParallelEdgeRouter sharedInstance = new ParallelEdgeRouter();
    private static double edgeSeparation = 10.0;
    private static double edgeDeparture = 10.0;

    public static ParallelEdgeRouter getSharedInstance() {
        return sharedInstance;
    }

    @Override
    public List routeEdge(GraphLayoutCache graphLayoutCache, EdgeView edgeView) {
        ArrayList arrayList = new ArrayList();
        CellView cellView = edgeView.getSource();
        CellView cellView2 = edgeView.getTarget();
        if (null == cellView) {
            cellView = edgeView.getSourceParentView();
        }
        if (null == cellView2) {
            cellView2 = edgeView.getTargetParentView();
        }
        if (null == cellView || null == cellView2) {
            return null;
        }
        if (cellView == cellView2) {
            return null;
        }
        List list = edgeView.getPoints();
        Object e = list.get(0);
        Object e2 = list.get(list.size() - 1);
        arrayList.add(e);
        Object[] objectArray = this.getParallelEdges(graphLayoutCache, edgeView, cellView, cellView2);
        if (objectArray == null) {
            return null;
        }
        if (objectArray.length >= 2) {
            Object object;
            int n = 0;
            for (int i = 0; i < objectArray.length; ++i) {
                object = objectArray[i];
                if (object != edgeView.getCell()) continue;
                n = i + 1;
            }
            Object object2 = object = edgeView.getTarget() != null ? edgeView.getPoint(edgeView.getPointCount() - 1) : AbstractCellView.getCenterPoint(cellView2);
            if (object == null) {
                object = AbstractCellView.getCenterPoint(cellView2);
            }
            Point2D point2D = edgeView.getSource() == null || edgeView.getSource().getParentView() == null ? cellView.getPerimeterPoint(edgeView, AbstractCellView.getCenterPoint(cellView), (Point2D)object) : edgeView.getSource().getParentView().getPerimeterPoint(edgeView, AbstractCellView.getCenterPoint(edgeView.getSource().getParentView()), edgeView.getTarget() != null && edgeView.getTarget().getParentView() != null ? AbstractCellView.getCenterPoint(edgeView.getTarget().getParentView()) : AbstractCellView.getCenterPoint(cellView2));
            Point2D point2D2 = edgeView.getTarget() == null || edgeView.getTarget().getParentView() == null ? cellView2.getPerimeterPoint(edgeView, AbstractCellView.getCenterPoint(cellView2), point2D) : edgeView.getTarget().getParentView().getPerimeterPoint(edgeView, AbstractCellView.getCenterPoint(edgeView.getTarget().getParentView()), point2D);
            if (point2D != null && point2D2 != null) {
                AttributeMap attributeMap;
                double d;
                double d2;
                double d3;
                double d4 = point2D.getY() - point2D2.getY();
                double d5 = point2D.getX() - point2D2.getX();
                if (d4 == 0.0 && d5 == 0.0) {
                    return null;
                }
                double d6 = 0.0;
                if (d4 == 0.0) {
                    d6 = 1.5707963267948966;
                } else if (d5 == 0.0) {
                    d6 = 0.0;
                } else {
                    d3 = d4 / d5;
                    d6 = Math.atan(-1.0 / d3);
                }
                d3 = Math.sqrt(d5 * d5 + d4 * d4);
                double d7 = d5 / d3;
                double d8 = d4 / d3;
                double d9 = Math.max(cellView.getBounds().getWidth(), cellView.getBounds().getHeight()) / 2.0;
                double d10 = Math.max(cellView2.getBounds().getWidth(), cellView2.getBounds().getHeight()) / 2.0;
                double d11 = (Math.sqrt(d5 * d5 + d4 * d4) - d9 - d10) / 2.0 + d9;
                double d12 = edgeDeparture + d9;
                double d13 = edgeDeparture + d10;
                double d14 = edgeSeparation * Math.floor(n / 2);
                if (0 == n % 2) {
                    d14 = -d14;
                }
                double d15 = d14 * Math.cos(d6);
                double d16 = d14 * Math.sin(d6);
                if (d11 <= d12) {
                    d2 = point2D.getX() - d7 * d11;
                    double d17 = point2D.getY() - d8 * d11;
                    Point2D.Double double_ = new Point2D.Double(d15 + d2, d16 + d17);
                    arrayList.add(double_);
                } else {
                    d2 = point2D.getX() - d7 * d12;
                    double d18 = point2D.getY() - d8 * d12;
                    double d19 = point2D2.getX() + d7 * d13;
                    double d20 = point2D2.getY() + d8 * d13;
                    Point2D.Double double_ = new Point2D.Double(d15 + d2, d16 + d18);
                    Point2D.Double double_2 = new Point2D.Double(d15 + d19, d16 + d20);
                    arrayList.add(double_);
                    arrayList.add(double_2);
                }
                Point2D point2D3 = edgeView.getLabelPosition();
                if (point2D3 != null && (d = point2D3.getX()) == 500.0 && (attributeMap = edgeView.getAllAttributes()) != null) {
                    int n2;
                    if (d4 < 0.0) {
                        d14 = -d14;
                    }
                    if ((n2 = this.getPreferredLineStyle(edgeView)) == -1) {
                        n2 = GraphConstants.getLineStyle(attributeMap);
                    }
                    if (n2 == 12 || n2 == 13) {
                        GraphConstants.setLabelPosition(attributeMap, new Point2D.Double(d, d14 * d11 / 79.0));
                    } else {
                        GraphConstants.setExactSegmentLabel(attributeMap, true);
                    }
                }
            }
        }
        arrayList.add(e2);
        return arrayList;
    }

    public static double getEdgeSeparation() {
        return edgeSeparation;
    }

    public static void setEdgeSeparation(double d) {
        edgeSeparation = d;
    }

    public static double getEdgeDeparture() {
        return edgeDeparture;
    }

    public static void setEdgeDeparture(double d) {
        edgeDeparture = d;
    }

    protected Object[] getParallelEdges(GraphLayoutCache graphLayoutCache, EdgeView edgeView, CellView cellView, CellView cellView2) {
        Object object52;
        Object object222;
        GraphModel graphModel = graphLayoutCache.getModel();
        Object object3 = cellView.getCell();
        Object object4 = cellView2.getCell();
        Object[] objectArray = DefaultGraphModel.getRoots(graphModel);
        if (objectArray.length == 0) {
            return null;
        }
        Object[] objectArray2 = new Object[]{object3, object4};
        if ((objectArray2 = DefaultGraphModel.order(graphModel, objectArray2)) == null || objectArray2.length < 2) {
            return null;
        }
        object3 = objectArray2[0];
        object4 = objectArray2[1];
        while (graphModel.getParent(object3) != null && !graphLayoutCache.isVisible(object3)) {
            object3 = graphModel.getParent(object3);
        }
        while (graphModel.getParent(object4) != null && !graphLayoutCache.isVisible(object4)) {
            object4 = graphModel.getParent(object4);
        }
        List list = DefaultGraphModel.getDescendants(graphModel, new Object[]{object3});
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(object3);
        for (Object object222 : list) {
            if (!DefaultGraphModel.isVertex(graphModel, object222) || graphLayoutCache.isVisible(object222)) continue;
            arrayList.add(object222);
        }
        object222 = DefaultGraphModel.getDescendants(graphModel, new Object[]{object4});
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        arrayList2.add(object4);
        for (Object object52 : object222) {
            if (!DefaultGraphModel.isVertex(graphModel, object52) || graphLayoutCache.isVisible(object52)) continue;
            arrayList2.add(object52);
        }
        if (arrayList.size() == 1 && arrayList2.size() == 1) {
            return DefaultGraphModel.getEdgesBetween(graphModel, object3, object4, false);
        }
        object52 = null;
        for (Object e : arrayList) {
            for (Object e2 : arrayList2) {
                Object[] objectArray3 = DefaultGraphModel.getEdgesBetween(graphModel, e, e2, false);
                if (objectArray3.length <= 0) continue;
                if (object52 == null) {
                    object52 = objectArray3;
                    continue;
                }
                Object[] objectArray4 = new Object[objectArray3.length + ((E)object52).length];
                System.arraycopy(object52, 0, objectArray4, 0, ((E)object52).length);
                System.arraycopy(objectArray3, 0, objectArray4, ((E)object52).length, objectArray3.length);
                object52 = objectArray4;
            }
        }
        return object52;
    }

    public static void setGraph(JGraph jGraph) {
    }
}

