/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.jgraph.JGraph;
import org.jgraph.graph.CellView;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.PortView;

public class PortRenderer
extends JComponent
implements CellViewRenderer,
Serializable {
    protected transient PortView view;
    protected Color graphBackground = Color.white;
    protected transient boolean hasFocus;
    protected transient boolean selected;
    protected transient boolean preview;
    protected transient boolean xorEnabled;

    public PortRenderer() {
        this.setForeground(UIManager.getColor("MenuItem.selectionBackground"));
        this.setBackground(UIManager.getColor("Tree.selectionBorderColor"));
    }

    @Override
    public Component getRendererComponent(JGraph jGraph, CellView cellView, boolean bl, boolean bl2, boolean bl3) {
        if (cellView instanceof PortView && jGraph != null) {
            this.graphBackground = jGraph.getBackground();
            this.view = (PortView)cellView;
            this.hasFocus = bl2;
            this.selected = bl;
            this.preview = bl3;
            this.xorEnabled = jGraph.isXorEnabled();
            return this;
        }
        return null;
    }

    @Override
    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.xorEnabled) {
            graphics.setColor(this.graphBackground);
            graphics.setXORMode(this.graphBackground);
        }
        super.paint(graphics);
        if (this.preview) {
            graphics.fill3DRect(0, 0, dimension.width, dimension.height, true);
        } else {
            graphics.fillRect(0, 0, dimension.width, dimension.height);
        }
        boolean bl = GraphConstants.getOffset(this.view.getAllAttributes()) != null;
        graphics.setColor(this.getForeground());
        if (!bl) {
            graphics.fillRect(1, 1, dimension.width - 2, dimension.height - 2);
        } else if (!this.preview) {
            graphics.drawRect(1, 1, dimension.width - 3, dimension.height - 3);
        }
    }

    @Override
    public void validate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long l, int n, int n2, int n3, int n4) {
    }

    @Override
    public void repaint(Rectangle rectangle) {
    }

    @Override
    protected void firePropertyChange(String string, Object object, Object object2) {
        if (string == "text") {
            super.firePropertyChange(string, object, object2);
        }
    }

    @Override
    public void firePropertyChange(String string, byte by, byte by2) {
    }

    @Override
    public void firePropertyChange(String string, char c, char c2) {
    }

    @Override
    public void firePropertyChange(String string, short s, short s2) {
    }

    @Override
    public void firePropertyChange(String string, int n, int n2) {
    }

    @Override
    public void firePropertyChange(String string, long l, long l2) {
    }

    @Override
    public void firePropertyChange(String string, float f, float f2) {
    }

    @Override
    public void firePropertyChange(String string, double d, double d2) {
    }

    @Override
    public void firePropertyChange(String string, boolean bl, boolean bl2) {
    }
}

