/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.jgraph.JGraph;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellMapper;
import org.jgraph.graph.CellView;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.PortView;

public class GraphContext
implements CellMapper {
    public static boolean PREVIEW_EDGE_GROUPS = false;
    protected JGraph graph;
    protected transient GraphLayoutCache graphLayoutCache;
    protected Object[] cells;
    protected Set allCells;
    protected Set cellSet;
    protected int cellCount;
    protected Map views = new Hashtable();

    public GraphContext(JGraph jGraph, Object[] objectArray) {
        GraphModel graphModel = jGraph.getModel();
        this.allCells = new HashSet(DefaultGraphModel.getDescendants(graphModel, objectArray));
        this.graphLayoutCache = jGraph.getGraphLayoutCache();
        this.graph = jGraph;
        this.cells = objectArray;
        this.cellSet = new HashSet();
        for (Object e : this.allCells) {
            if (!this.graphLayoutCache.isVisible(e)) continue;
            this.cellSet.add(e);
            if (graphModel.isPort(e)) continue;
            ++this.cellCount;
        }
    }

    public boolean isEmpty() {
        return this.cells == null || this.cells.length == 0;
    }

    public int getDescendantCount() {
        return this.cellCount;
    }

    public JGraph getGraph() {
        return this.graph;
    }

    public Object[] getCells() {
        return this.cells;
    }

    public boolean contains(Object object) {
        return this.cellSet.contains(object);
    }

    public CellView[] createTemporaryCellViews() {
        CellView[] cellViewArray = new CellView[this.cells.length];
        for (int i = 0; i < this.cells.length; ++i) {
            cellViewArray[i] = this.getMapping(this.cells[i], true);
        }
        return cellViewArray;
    }

    public CellView[] createTemporaryPortViews() {
        Object object2;
        GraphModel graphModel = this.graph.getModel();
        ArrayList<CellView> arrayList = new ArrayList<CellView>();
        for (Object object2 : this.allCells) {
            if (!graphModel.isPort(object2) || !this.graph.getGraphLayoutCache().isVisible(object2)) continue;
            arrayList.add(this.getMapping(object2, true));
        }
        object2 = new PortView[arrayList.size()];
        arrayList.toArray((T[])object2);
        return object2;
    }

    public CellView[] createTemporaryContextViews() {
        return this.createTemporaryContextViews(this.cellSet);
    }

    public CellView[] createTemporaryContextViews(Set set) {
        Object[] objectArray = set.toArray();
        ArrayList<CellView> arrayList = new ArrayList<CellView>();
        Set set2 = DefaultGraphModel.getEdges(this.graph.getModel(), objectArray);
        do {
            for (Object e : set2) {
                CellView cellView = this.graphLayoutCache.getMapping(e, false);
                if (set.contains(e) || !this.graphLayoutCache.isVisible(e) || cellView == null || !PREVIEW_EDGE_GROUPS && !cellView.isLeaf()) continue;
                CellView cellView2 = this.createMapping(e);
                arrayList.add(cellView2);
                CellView[] cellViewArray = cellView2.getChildViews();
                for (int i = 0; i < cellViewArray.length; ++i) {
                    cellViewArray[i] = this.createMapping(cellViewArray[i].getCell());
                }
                cellView2.refresh(this.graph.getGraphLayoutCache(), this, false);
            }
        } while (!(set2 = DefaultGraphModel.getEdges(this.graph.getModel(), set2.toArray())).isEmpty());
        CellView[] cellViewArray = new CellView[arrayList.size()];
        arrayList.toArray(cellViewArray);
        return cellViewArray;
    }

    @Override
    public CellView getMapping(Object object, boolean bl) {
        if (object != null) {
            CellView cellView = (CellView)this.views.get(object);
            if (cellView != null) {
                return cellView;
            }
            if (this.contains(object) || this.graph.getModel().isPort(object) && bl && this.graph.getGraphLayoutCache().isVisible(object)) {
                return this.createMapping(object);
            }
            return this.graphLayoutCache.getMapping(object, false);
        }
        return null;
    }

    public CellView createMapping(Object object) {
        CellView cellView = this.graphLayoutCache.getFactory().createView(this.graph.getModel(), object);
        this.putMapping(object, cellView);
        cellView.refresh(this.graph.getGraphLayoutCache(), this, true);
        CellView cellView2 = this.graphLayoutCache.getMapping(object, false);
        if (cellView2 != null) {
            cellView.changeAttributes(this.graphLayoutCache, (AttributeMap)cellView2.getAttributes().clone());
            cellView.refresh(this.graph.getGraphLayoutCache(), this, false);
        }
        return cellView;
    }

    public ConnectionSet disconnect(CellView[] cellViewArray) {
        ConnectionSet connectionSet = new ConnectionSet();
        for (int i = 0; i < cellViewArray.length; ++i) {
            if (!(cellViewArray[i] instanceof EdgeView)) continue;
            EdgeView edgeView = (EdgeView)cellViewArray[i];
            CellView cellView = edgeView.getSource();
            if (!GraphConstants.isDisconnectable(edgeView.getAllAttributes())) continue;
            if (cellView != null && GraphConstants.isDisconnectable(cellView.getParentView().getAllAttributes()) && !this.contains(cellView.getCell())) {
                edgeView.setSource(null);
                connectionSet.disconnect(edgeView.getCell(), true);
            }
            if ((cellView = edgeView.getTarget()) == null || !GraphConstants.isDisconnectable(cellView.getParentView().getAllAttributes()) || this.contains(cellView.getCell())) continue;
            edgeView.setTarget(null);
            connectionSet.disconnect(edgeView.getCell(), false);
        }
        return connectionSet;
    }

    @Override
    public void putMapping(Object object, CellView cellView) {
        this.views.put(object, cellView);
    }
}

