/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.jgraph.JGraph;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellView;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.Edge;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphConstants;
import org.jgraph.util.Bezier;
import org.jgraph.util.Spline2D;

public class EdgeRenderer
extends JComponent
implements CellViewRenderer,
Serializable {
    protected static transient Graphics fontGraphics;
    public static double LABELWIDTHBUFFER;
    public boolean simpleExtraLabels = true;
    public Font extraLabelFont = null;
    protected transient FontMetrics metrics;
    protected transient WeakReference graph;
    protected transient EdgeView view;
    protected transient int beginDeco;
    protected transient int endDeco;
    protected transient int beginSize;
    protected transient int endSize;
    protected transient int lineStyle;
    protected transient float lineWidth;
    protected transient boolean labelsEnabled;
    protected transient boolean labelBorder;
    protected transient boolean beginFill;
    protected transient boolean endFill;
    protected transient boolean focus;
    protected transient boolean selected;
    protected transient boolean preview;
    protected transient boolean opaque;
    protected transient boolean childrenSelected;
    protected transient boolean labelTransformEnabled;
    protected transient boolean isMoveBelowZero;
    protected transient Color borderColor;
    protected transient Color defaultForeground = UIManager.getColor("Tree.textForeground");
    protected transient Color defaultBackground = UIManager.getColor("Tree.textBackground");
    protected transient Color fontColor;
    protected transient float[] lineDash;
    protected transient float dashOffset = 0.0f;
    protected transient Color gradientColor = null;
    protected transient Color gridColor = null;
    protected transient Color lockedHandleColor = null;
    protected transient Color highlightColor = null;
    protected transient Bezier bezier;
    protected transient Spline2D spline;

    void setView(CellView cellView) {
        if (cellView instanceof EdgeView) {
            this.view = (EdgeView)cellView;
            this.installAttributes(this.view);
        } else {
            this.view = null;
        }
    }

    @Override
    public Component getRendererComponent(JGraph jGraph, CellView cellView, boolean bl, boolean bl2, boolean bl3) {
        if (cellView instanceof EdgeView && jGraph != null) {
            this.gridColor = jGraph.getGridColor();
            this.lockedHandleColor = jGraph.getLockedHandleColor();
            this.highlightColor = jGraph.getHighlightColor();
            this.isMoveBelowZero = jGraph.isMoveBelowZero();
            this.graph = new WeakReference<JGraph>(jGraph);
            this.focus = bl2;
            this.selected = bl;
            this.preview = bl3;
            this.childrenSelected = jGraph.getSelectionModel().isChildrenSelected(cellView.getCell());
            this.setView(cellView);
            return this;
        }
        return null;
    }

    public boolean intersects(JGraph jGraph, CellView cellView, Rectangle rectangle) {
        if (cellView instanceof EdgeView && jGraph != null && cellView != null) {
            Object[] objectArray;
            Cloneable cloneable;
            this.setView(cellView);
            Graphics2D graphics2D = (Graphics2D)jGraph.getGraphics();
            EdgeView edgeView = (EdgeView)cellView;
            if (graphics2D == null || edgeView.getPointCount() == 2) {
                cloneable = edgeView.getPoint(0);
                objectArray = edgeView.getPoint(1);
                if (rectangle.intersectsLine(((Point2D)cloneable).getX(), ((Point2D)cloneable).getY(), objectArray.getX(), objectArray.getY())) {
                    return true;
                }
            } else if (graphics2D != null && graphics2D.hit(rectangle, this.view.getShape(), true)) {
                return true;
            }
            if ((cloneable = this.getLabelBounds(jGraph, this.view)) != null && ((RectangularShape)cloneable).intersects(rectangle)) {
                return true;
            }
            objectArray = GraphConstants.getExtraLabels(this.view.getAllAttributes());
            if (objectArray != null) {
                for (int i = 0; i < objectArray.length; ++i) {
                    cloneable = this.getExtraLabelBounds(jGraph, this.view, i);
                    if (cloneable == null || !((RectangularShape)cloneable).intersects(rectangle)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public Rectangle2D getBounds(CellView cellView) {
        if (cellView instanceof EdgeView && cellView != null) {
            int n;
            Object[] objectArray;
            Rectangle2D rectangle2D;
            this.view = (EdgeView)cellView;
            Rectangle2D rectangle2D2 = this.getPaintBounds(this.view);
            JGraph jGraph = null;
            if (this.graph != null) {
                jGraph = (JGraph)this.graph.get();
            }
            if ((rectangle2D = this.getLabelBounds(jGraph, this.view)) != null) {
                Rectangle2D.union(rectangle2D2, rectangle2D, rectangle2D2);
            }
            if ((objectArray = GraphConstants.getExtraLabels(this.view.getAllAttributes())) != null) {
                for (n = 0; n < objectArray.length; ++n) {
                    rectangle2D = this.getExtraLabelBounds(jGraph, this.view, n);
                    if (rectangle2D == null) continue;
                    Rectangle2D.union(rectangle2D2, rectangle2D, rectangle2D2);
                }
            }
            n = (int)Math.ceil(this.lineWidth);
            rectangle2D2.setFrame(rectangle2D2.getX() - (double)n, rectangle2D2.getY() - (double)n, rectangle2D2.getWidth() + (double)(2 * n), rectangle2D2.getHeight() + (double)(2 * n));
            return rectangle2D2;
        }
        return null;
    }

    private boolean isLabelTransformEnabled() {
        return this.labelTransformEnabled;
    }

    private boolean isLabelTransform(String string) {
        if (!this.isLabelTransformEnabled()) {
            return false;
        }
        Point2D point2D = this.getLabelPosition(this.view);
        if (point2D != null && string != null && string.length() > 0) {
            int n = this.metrics.stringWidth(string);
            Point2D point2D2 = this.view.getPoint(0);
            Point2D point2D3 = this.view.getPoint(this.view.getPointCount() - 1);
            double d = Math.sqrt((point2D3.getX() - point2D2.getX()) * (point2D3.getX() - point2D2.getX()) + (point2D3.getY() - point2D2.getY()) * (point2D3.getY() - point2D2.getY()));
            if (!(d <= Double.NaN) && !(d < (double)n)) {
                return true;
            }
        }
        return false;
    }

    private double getLabelAngle(String string) {
        Point2D point2D = this.getLabelPosition(this.view);
        double d = 0.0;
        if (point2D != null && string != null && string.length() > 0) {
            int n = this.metrics.stringWidth(string);
            Point2D point2D2 = this.view.getPoint(0);
            Point2D point2D3 = this.view.getPoint(this.view.getPointCount() - 1);
            double d2 = Math.sqrt((point2D3.getX() - point2D2.getX()) * (point2D3.getX() - point2D2.getX()) + (point2D3.getY() - point2D2.getY()) * (point2D3.getY() - point2D2.getY()));
            if (!(d2 <= Double.NaN) && !(d2 < (double)n)) {
                double d3 = (point2D3.getX() - point2D2.getX()) / d2;
                double d4 = (point2D3.getY() - point2D2.getY()) / d2;
                d = Math.acos(d3);
                if (d4 < 0.0) {
                    d = Math.PI * 2 - d;
                }
            }
            if (d > 1.5707963267948966 && d <= 4.71238898038469) {
                d -= Math.PI;
            }
        }
        return d;
    }

    public Rectangle2D getLabelBounds(JGraph object, EdgeView edgeView) {
        Object object2;
        if (object == null && this.graph != null) {
            object = object2 = (JGraph)this.graph.get();
        }
        Object object3 = object2 = object != null ? ((JGraph)object).convertValueToString(edgeView) : String.valueOf(edgeView.getCell());
        if (object2 != null) {
            Point2D point2D = this.getLabelPosition(edgeView);
            Dimension dimension = this.getLabelSize(edgeView, (String)object2);
            return this.getLabelBounds(point2D, dimension, (String)object2);
        }
        return null;
    }

    public Rectangle2D getExtraLabelBounds(JGraph object, EdgeView edgeView, int n) {
        Object object2;
        if (object == null && this.graph != null) {
            object = object2 = (JGraph)this.graph.get();
        }
        this.setView(edgeView);
        object2 = GraphConstants.getExtraLabels(edgeView.getAllAttributes());
        if (object2 != null && n < ((Object[])object2).length) {
            Point2D point2D = this.getExtraLabelPosition(this.view, n);
            Dimension dimension = this.getExtraLabelSize((JGraph)object, this.view, n);
            String string = object != null ? ((JGraph)object).convertValueToString(object2[n]) : String.valueOf(object2[n]);
            return this.getLabelBounds(point2D, dimension, string);
        }
        return new Rectangle2D.Double(this.getX(), this.getY(), 0.0, 0.0);
    }

    public Rectangle2D getLabelBounds(Point2D point2D, Dimension dimension, String string) {
        double d;
        double d2;
        if (string != null && this.isLabelTransform(string)) {
            d2 = this.getLabelAngle(string);
            if (d2 < 0.0) {
                d2 = -d2;
            }
            if (d2 > 1.5707963267948966) {
                d2 %= 1.5707963267948966;
            }
            d = Math.abs(Math.cos(d2) * (double)dimension.height + Math.sin(d2) * (double)dimension.width);
            double d3 = Math.abs((double)dimension.width * Math.cos(d2) + (double)dimension.height * Math.sin(d2));
            if (d3 > d) {
                d = d3;
            }
            if (d > d3) {
                d3 = d;
            }
            d2 = this.getLabelAngle(string);
            dimension.width = (int)d3 + dimension.height;
            dimension.height = (int)d + dimension.height;
        }
        if (point2D != null && dimension != null) {
            d2 = Math.max(0.0, point2D.getX() - (double)(dimension.width / 2));
            d = Math.max(0.0, point2D.getY() - (double)(dimension.height / 2));
            return new Rectangle2D.Double(d2, d, dimension.width + 1, dimension.height + 1);
        }
        return null;
    }

    public Point2D getLabelPosition(EdgeView edgeView) {
        this.setView(edgeView);
        return this.getLabelPosition(edgeView.getLabelPosition());
    }

    public Point2D getExtraLabelPosition(EdgeView edgeView, int n) {
        this.setView(edgeView);
        Point2D[] point2DArray = GraphConstants.getExtraLabelPositions(edgeView.getAllAttributes());
        if (point2DArray != null && n < point2DArray.length) {
            return this.getLabelPosition(point2DArray[n]);
        }
        return null;
    }

    protected Point2D getLabelPosition(Point2D point2D) {
        Rectangle2D rectangle2D = this.getPaintBounds(this.view);
        int n = 1000;
        Point2D point2D2 = this.view.getPoint(0);
        if (point2D != null && rectangle2D != null && point2D2 != null) {
            double d;
            if (!this.isLabelTransformEnabled()) {
                return this.view.getAbsoluteLabelPositionFromRelative(point2D);
            }
            Point2D point2D3 = this.view.getLabelVector();
            double d2 = point2D3.getX();
            double d3 = Math.sqrt(d2 * d2 + (d = point2D3.getY()) * d);
            if (d3 > 0.0) {
                int n2 = this.view.getFirstPointOfSegment();
                if (n2 >= 0 && n2 < this.view.getPointCount() - 1) {
                    point2D2 = this.view.getPoint(n2);
                }
                double d4 = point2D2.getX() + d2 * point2D.getX() / (double)n;
                double d5 = point2D2.getY() + d * point2D.getX() / (double)n;
                return new Point2D.Double(d4 += -d * point2D.getY() / d3, d5 += d2 * point2D.getY() / d3);
            }
            return new Point2D.Double(point2D2.getX() + point2D.getX(), point2D2.getY() + point2D.getY());
        }
        return null;
    }

    public Dimension getExtraLabelSize(JGraph jGraph, EdgeView edgeView, int n) {
        Object[] objectArray = GraphConstants.getExtraLabels(edgeView.getAllAttributes());
        if (objectArray != null && n < objectArray.length) {
            String string = jGraph != null ? jGraph.convertValueToString(objectArray[n]) : String.valueOf(objectArray[n]);
            return this.getLabelSize(edgeView, string);
        }
        return null;
    }

    public Dimension getLabelSize(EdgeView edgeView, String string) {
        if (string != null && fontGraphics != null) {
            fontGraphics.setFont(GraphConstants.getFont(edgeView.getAllAttributes()));
            this.metrics = fontGraphics.getFontMetrics();
            int n = (int)((double)this.metrics.stringWidth(string) * LABELWIDTHBUFFER);
            int n2 = this.metrics.getHeight();
            return new Dimension(n, n2);
        }
        return null;
    }

    protected void installAttributes(CellView cellView) {
        AttributeMap attributeMap = cellView.getAllAttributes();
        this.beginDeco = GraphConstants.getLineBegin(attributeMap);
        this.beginSize = GraphConstants.getBeginSize(attributeMap);
        this.beginFill = GraphConstants.isBeginFill(attributeMap) && this.isFillable(this.beginDeco);
        this.endDeco = GraphConstants.getLineEnd(attributeMap);
        this.endSize = GraphConstants.getEndSize(attributeMap);
        this.endFill = GraphConstants.isEndFill(attributeMap) && this.isFillable(this.endDeco);
        this.lineWidth = GraphConstants.getLineWidth(attributeMap);
        Edge.Routing routing = GraphConstants.getRouting(attributeMap);
        int n = this.lineStyle = routing != null && cellView instanceof EdgeView ? routing.getPreferredLineStyle((EdgeView)cellView) : -1;
        if (this.lineStyle == -1) {
            this.lineStyle = GraphConstants.getLineStyle(attributeMap);
        }
        this.lineDash = GraphConstants.getDashPattern(attributeMap);
        this.dashOffset = GraphConstants.getDashOffset(attributeMap);
        this.borderColor = GraphConstants.getBorderColor(attributeMap);
        Color color = GraphConstants.getLineColor(attributeMap);
        this.setForeground(color != null ? color : this.defaultForeground);
        Color color2 = GraphConstants.getBackground(attributeMap);
        this.setBackground(color2 != null ? color2 : this.defaultBackground);
        Color color3 = GraphConstants.getGradientColor(attributeMap);
        this.setGradientColor(color3);
        this.setOpaque(GraphConstants.isOpaque(attributeMap));
        this.setFont(GraphConstants.getFont(attributeMap));
        Color color4 = GraphConstants.getForeground(attributeMap);
        this.fontColor = color4 != null ? color4 : this.getForeground();
        this.labelTransformEnabled = GraphConstants.isLabelAlongEdge(attributeMap);
        this.labelsEnabled = GraphConstants.isLabelEnabled(attributeMap);
    }

    protected boolean isFillable(int n) {
        return n != 4 && n != 7 && n != 8;
    }

    public Rectangle2D getPaintBounds(EdgeView edgeView) {
        Rectangle2D rectangle2D = null;
        this.setView(edgeView);
        rectangle2D = edgeView.getShape() != null ? edgeView.getShape().getBounds() : new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        return rectangle2D;
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.view.isLeaf()) {
            Shape shape = this.view.getShape();
            if (shape != null) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
                int n = 0;
                int n2 = 0;
                this.setOpaque(false);
                super.paint(graphics);
                this.translateGraphics(graphics);
                graphics.setColor(this.getForeground());
                if (this.lineWidth > 0.0f) {
                    graphics2D.setStroke(new BasicStroke(this.lineWidth, n, n2));
                    if (this.gradientColor != null && !this.preview) {
                        graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, this.getBackground(), this.getWidth(), this.getHeight(), this.gradientColor, true));
                    }
                    if (this.view.beginShape != null) {
                        if (this.beginFill) {
                            graphics2D.fill(this.view.beginShape);
                        }
                        graphics2D.draw(this.view.beginShape);
                    }
                    if (this.view.endShape != null) {
                        if (this.endFill) {
                            graphics2D.fill(this.view.endShape);
                        }
                        graphics2D.draw(this.view.endShape);
                    }
                    if (this.lineDash != null) {
                        graphics2D.setStroke(new BasicStroke(this.lineWidth, n, n2, 10.0f, this.lineDash, this.dashOffset));
                    }
                    if (this.view.lineShape != null) {
                        graphics2D.draw(this.view.lineShape);
                    }
                }
                if (this.selected) {
                    graphics2D.setStroke(GraphConstants.SELECTION_STROKE);
                    graphics2D.setColor(this.highlightColor);
                    if (this.view.beginShape != null) {
                        graphics2D.draw(this.view.beginShape);
                    }
                    if (this.view.lineShape != null) {
                        graphics2D.draw(this.view.lineShape);
                    }
                    if (this.view.endShape != null) {
                        graphics2D.draw(this.view.endShape);
                    }
                }
                graphics2D.setStroke(new BasicStroke(1.0f));
                graphics.setFont(this.extraLabelFont != null ? this.extraLabelFont : this.getFont());
                Object[] objectArray = GraphConstants.getExtraLabels(this.view.getAllAttributes());
                JGraph jGraph = (JGraph)this.graph.get();
                if (objectArray != null) {
                    for (int i = 0; i < objectArray.length; ++i) {
                        this.paintLabel(graphics, jGraph.convertValueToString(objectArray[i]), this.getExtraLabelPosition(this.view, i), !this.simpleExtraLabels);
                    }
                }
                if (jGraph.getEditingCell() != this.view.getCell()) {
                    graphics.setFont(this.getFont());
                    String string = jGraph.convertValueToString(this.view);
                    if (string != null) {
                        this.paintLabel(graphics, string.toString(), this.getLabelPosition(this.view), true);
                    }
                }
            }
        } else {
            this.paintSelectionBorder(graphics);
        }
    }

    protected void paintSelectionBorder(Graphics graphics) {
        ((Graphics2D)graphics).setStroke(GraphConstants.SELECTION_STROKE);
        if (this.childrenSelected) {
            graphics.setColor(this.gridColor);
        } else if (this.focus && this.selected) {
            graphics.setColor(this.lockedHandleColor);
        } else if (this.selected) {
            graphics.setColor(this.highlightColor);
        }
        if (this.childrenSelected || this.selected) {
            Dimension dimension = this.getSize();
            graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
        }
    }

    protected void translateGraphics(Graphics graphics) {
        graphics.translate(-this.getX(), -this.getY());
    }

    protected void paintLabel(Graphics graphics, String string, Point2D point2D, boolean bl) {
        if (this.labelsEnabled && point2D != null && string != null && string.length() > 0 && this.metrics != null) {
            int n = this.metrics.stringWidth(string);
            int n2 = this.metrics.getHeight();
            Graphics2D graphics2D = (Graphics2D)graphics;
            boolean bl2 = this.isLabelTransform(string);
            double d = 0.0;
            int n3 = -n / 2;
            int n4 = this.isMoveBelowZero || bl2 ? 0 : Math.min(0, (int)((double)n3 + point2D.getX()));
            graphics2D.translate(point2D.getX() - (double)n4, point2D.getY());
            if (bl2) {
                d = this.getLabelAngle(string);
                graphics2D.rotate(d);
            }
            if (this.isOpaque() && bl) {
                graphics.setColor(this.getBackground());
                graphics.fillRect(-n / 2 - 1, -n2 / 2 - 1, n + 2, n2 + 2);
            }
            if (this.borderColor != null && bl) {
                graphics.setColor(this.borderColor);
                graphics.drawRect(-n / 2 - 1, -n2 / 2 - 1, n + 2, n2 + 2);
            }
            int n5 = n2 / 4;
            graphics.setColor(this.fontColor);
            if (bl2 && this.borderColor == null && !this.isOpaque()) {
                n5 = -this.metrics.getDescent();
            }
            graphics.drawString(string, n3, n5);
            if (bl2) {
                graphics2D.rotate(-d);
            }
            graphics2D.translate(-point2D.getX() + (double)n4, -point2D.getY());
        }
    }

    protected Shape createShape() {
        int n = this.view.getPointCount();
        if (n > 1) {
            Object[] objectArray;
            Point2D point2D;
            EdgeView edgeView = this.view;
            Point2D[] point2DArray = null;
            point2DArray = new Point2D[n];
            for (int i = 0; i < n; ++i) {
                point2D = edgeView.getPoint(i);
                if (point2D == null) {
                    return null;
                }
                point2DArray[i] = new Point2D.Double(point2D.getX(), point2D.getY());
            }
            if (this.view != edgeView) {
                this.view = edgeView;
                this.installAttributes(this.view);
            }
            if (this.view.sharedPath == null) {
                this.view.sharedPath = new GeneralPath(1, n);
            } else {
                this.view.sharedPath.reset();
            }
            this.view.endShape = null;
            this.view.lineShape = null;
            this.view.beginShape = null;
            Point2D point2D2 = point2DArray[0];
            point2D = point2DArray[n - 1];
            Point2D point2D3 = point2DArray[1];
            Point2D point2D4 = point2DArray[n - 2];
            if (this.lineStyle == 12 && n > 2) {
                this.bezier = new Bezier(point2DArray);
                point2D4 = this.bezier.getPoint(this.bezier.getPointCount() - 1);
            } else if (this.lineStyle == 13 && n > 2) {
                this.spline = new Spline2D(point2DArray);
                objectArray = this.spline.getPoint(0.9875);
                double d = point2D.getX() - (point2D.getX() - objectArray[0]) * 128.0;
                double d2 = point2D.getY() - (point2D.getY() - objectArray[1]) * 128.0;
                point2D4.setLocation(d, d2);
            }
            if (this.beginDeco != 0) {
                this.view.beginShape = this.createLineEnd(this.beginSize, this.beginDeco, point2D3, point2D2);
            }
            if (this.endDeco != 0) {
                this.view.endShape = this.createLineEnd(this.endSize, this.endDeco, point2D4, point2D);
            }
            this.view.sharedPath.moveTo((float)point2D2.getX(), (float)point2D2.getY());
            if (this.lineStyle == 12 && n > 2) {
                objectArray = this.bezier.getPoints();
                this.view.sharedPath.quadTo((float)objectArray[0].getX(), (float)objectArray[0].getY(), (float)point2D3.getX(), (float)point2D3.getY());
                for (int i = 2; i < n - 1; ++i) {
                    double d = objectArray[2 * i - 3];
                    double d3 = objectArray[2 * i - 2];
                    this.view.sharedPath.curveTo((float)d.getX(), (float)d.getY(), (float)d3.getX(), (float)d3.getY(), (float)point2DArray[i].getX(), (float)point2DArray[i].getY());
                }
                this.view.sharedPath.quadTo((float)objectArray[objectArray.length - 1].getX(), (float)objectArray[objectArray.length - 1].getY(), (float)point2DArray[n - 1].getX(), (float)point2DArray[n - 1].getY());
            } else if (this.lineStyle == 13 && n > 2) {
                for (double d = 0.0; d <= 1.0; d += 0.0125) {
                    double[] dArray = this.spline.getPoint(d);
                    this.view.sharedPath.lineTo((float)dArray[0], (float)dArray[1]);
                }
            } else {
                for (int i = 1; i < n - 1; ++i) {
                    this.view.sharedPath.lineTo((float)point2DArray[i].getX(), (float)point2DArray[i].getY());
                }
                this.view.sharedPath.lineTo((float)point2D.getX(), (float)point2D.getY());
            }
            this.view.sharedPath.moveTo((float)point2D.getX(), (float)point2D.getY());
            if (this.view.endShape == null && this.view.beginShape == null) {
                this.view.lineShape = this.view.sharedPath;
            } else {
                this.view.lineShape = (GeneralPath)this.view.sharedPath.clone();
                if (this.view.endShape != null) {
                    this.view.sharedPath.append(this.view.endShape, true);
                }
                if (this.view.beginShape != null) {
                    this.view.sharedPath.append(this.view.beginShape, true);
                }
            }
            return this.view.sharedPath;
        }
        return null;
    }

    protected Shape createLineEnd(int n, int n2, Point2D point2D, Point2D point2D2) {
        if (point2D == null || point2D2 == null) {
            return null;
        }
        int n3 = (int)Math.max(1.0, point2D2.distance(point2D));
        int n4 = (int)(-((double)n * (point2D2.getX() - point2D.getX()) / (double)n3));
        int n5 = (int)(-((double)n * (point2D2.getY() - point2D.getY()) / (double)n3));
        if (n2 == 9) {
            Polygon polygon = new Polygon();
            polygon.addPoint((int)point2D2.getX(), (int)point2D2.getY());
            polygon.addPoint((int)(point2D2.getX() + (double)(n4 / 2) + (double)(n5 / 3)), (int)(point2D2.getY() + (double)(n5 / 2) - (double)(n4 / 3)));
            Point2D point2D3 = (Point2D)point2D2.clone();
            point2D2.setLocation(point2D2.getX() + (double)n4, point2D2.getY() + (double)n5);
            polygon.addPoint((int)point2D2.getX(), (int)point2D2.getY());
            polygon.addPoint((int)(point2D3.getX() + (double)(n4 / 2) - (double)(n5 / 3)), (int)(point2D3.getY() + (double)(n5 / 2) + (double)(n4 / 3)));
            return polygon;
        }
        if (n2 == 2 || n2 == 1) {
            Polygon polygon = new Polygon();
            polygon.addPoint((int)point2D2.getX(), (int)point2D2.getY());
            polygon.addPoint((int)(point2D2.getX() + (double)n4 + (double)(n5 / 2)), (int)(point2D2.getY() + (double)n5 - (double)(n4 / 2)));
            Point2D point2D4 = (Point2D)point2D2.clone();
            if (n2 == 1) {
                point2D2.setLocation((int)(point2D2.getX() + (double)(n4 * 2 / 3)), (int)(point2D2.getY() + (double)(n5 * 2 / 3)));
                polygon.addPoint((int)point2D2.getX(), (int)point2D2.getY());
            } else if (n2 == 9) {
                point2D2.setLocation(point2D2.getX() + (double)(2 * n4), point2D2.getY() + (double)(2 * n5));
                polygon.addPoint((int)point2D2.getX(), (int)point2D2.getY());
            } else {
                point2D2.setLocation((int)(point2D2.getX() + (double)n4), (int)(point2D2.getY() + (double)n5));
            }
            polygon.addPoint((int)(point2D4.getX() + (double)n4 - (double)(n5 / 2)), (int)(point2D4.getY() + (double)n5 + (double)(n4 / 2)));
            return polygon;
        }
        if (n2 == 4) {
            GeneralPath generalPath = new GeneralPath(1, 4);
            generalPath.moveTo((float)(point2D2.getX() + (double)n4 + (double)(n5 / 2)), (float)(point2D2.getY() + (double)n5 - (double)(n4 / 2)));
            generalPath.lineTo((float)point2D2.getX(), (float)point2D2.getY());
            generalPath.lineTo((float)(point2D2.getX() + (double)n4 - (double)(n5 / 2)), (float)(point2D2.getY() + (double)n5 + (double)(n4 / 2)));
            return generalPath;
        }
        if (n2 == 5) {
            Ellipse2D.Float float_ = new Ellipse2D.Float((float)(point2D2.getX() + (double)(n4 / 2) - (double)(n / 2)), (float)(point2D2.getY() + (double)(n5 / 2) - (double)(n / 2)), n, n);
            point2D2.setLocation(point2D2.getX() + (double)n4, point2D2.getY() + (double)n5);
            return float_;
        }
        if (n2 == 7 || n2 == 8) {
            GeneralPath generalPath = new GeneralPath(1, 4);
            generalPath.moveTo((float)(point2D2.getX() + (double)(n4 / 2) + (double)(n5 / 2)), (float)(point2D2.getY() + (double)(n5 / 2) - (double)(n4 / 2)));
            generalPath.lineTo((float)(point2D2.getX() + (double)(n4 / 2) - (double)(n5 / 2)), (float)(point2D2.getY() + (double)(n5 / 2) + (double)(n4 / 2)));
            if (n2 == 8) {
                generalPath.moveTo((float)(point2D2.getX() + (double)(n4 / 3) + (double)(n5 / 2)), (float)(point2D2.getY() + (double)(n5 / 3) - (double)(n4 / 2)));
                generalPath.lineTo((float)(point2D2.getX() + (double)(n4 / 3) - (double)(n5 / 2)), (float)(point2D2.getY() + (double)(n5 / 3) + (double)(n4 / 2)));
            }
            return generalPath;
        }
        return null;
    }

    public Color getGradientColor() {
        return this.gradientColor;
    }

    public void setGradientColor(Color color) {
        this.gradientColor = color;
    }

    @Override
    public void validate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long l, int n, int n2, int n3, int n4) {
    }

    @Override
    public void repaint(Rectangle rectangle) {
    }

    @Override
    protected void firePropertyChange(String string, Object object, Object object2) {
        if (string == "text") {
            super.firePropertyChange(string, object, object2);
        }
    }

    @Override
    public void firePropertyChange(String string, byte by, byte by2) {
    }

    @Override
    public void firePropertyChange(String string, char c, char c2) {
    }

    @Override
    public void firePropertyChange(String string, short s, short s2) {
    }

    @Override
    public void firePropertyChange(String string, int n, int n2) {
    }

    @Override
    public void firePropertyChange(String string, long l, long l2) {
    }

    @Override
    public void firePropertyChange(String string, float f, float f2) {
    }

    @Override
    public void firePropertyChange(String string, double d, double d2) {
    }

    @Override
    public void firePropertyChange(String string, boolean bl, boolean bl2) {
    }

    static {
        try {
            fontGraphics = new BufferedImage(1, 1, 1).getGraphics();
        }
        catch (Error error) {
            fontGraphics = null;
        }
        LABELWIDTHBUFFER = 1.1;
    }
}

