<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html"/>

<xsl:template match="/Orchestrator">
	<html>
		<body>
			<TABLE width="90%" border="2" bordercolor="#000000">
				<CAPTION>
					<DIV align="center"><font size="4"><b>ORCHESTRATOR RESULT</b></font></DIV>
					<xsl:text>&#160;</xsl:text>
				</CAPTION>
				<THEAD>
					<TR>
						<TH><font size="4">Target Service State</font></TH>
						<TH><font size="4">Available Services States</font></TH>
						<TH><font size="4">Action</font></TH>
						<TH><font size="4">Available Services</font></TH>
					</TR>
				</THEAD>
				<TBODY>
					<xsl:apply-templates/>
				</TBODY>
			</TABLE>
		</body>
	</html>
</xsl:template>

<xsl:template match="/Orchestrator/OrchestratorLine">
	<TR>
		<xsl:apply-templates select="Input"/>
		<TD>
			<xsl:apply-templates select="AvailableServices"/>
		</TD>
	</TR>
</xsl:template>

<xsl:template match="/Orchestrator/OrchestratorLine/Input">
	<xsl:apply-templates select="TargetState"/>
	<TD>
		<DIV align="center"><xsl:apply-templates select=".//AvailableState"/></DIV>
		
	</TD>
	<xsl:apply-templates select="Action"/>
</xsl:template>

<xsl:template match="/Orchestrator/OrchestratorLine/Input/TargetState">
	<TD><DIV align="center"><xsl:value-of select="@name"/></DIV></TD>
</xsl:template>

<xsl:template match="/Orchestrator/OrchestratorLine/Input/AvailableState">
	<xsl:value-of select="@name"/>,
</xsl:template>

<xsl:template match="/Orchestrator/OrchestratorLine/Input/AvailableState[last()]">
	<xsl:value-of select="@name"/>
</xsl:template>

<xsl:template match="/Orchestrator/OrchestratorLine/Input/Action">
	<TD><DIV align="center"><xsl:value-of select="@name"/></DIV></TD>
</xsl:template>

<xsl:template match="/Orchestrator/OrchestratorLine/AvailableServices">
	<DIV align="center"><xsl:apply-templates /></DIV>
</xsl:template>

<xsl:template match="/Orchestrator/OrchestratorLine/AvailableServices/Service">
	<xsl:value-of select="@name"/>,
</xsl:template>

<xsl:template match="/Orchestrator/OrchestratorLine/AvailableServices/Service[last()]">
	<xsl:value-of select="@name"/>
</xsl:template>

</xsl:stylesheet>
