/*
 * Decompiled with CFR 0.152.
 */
package presentation;

import abstraction.ReadFile;
import abstraction.Service;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.jgraph.JGraph;
import presentation.OrchestratorFrame;
import presentation.graph.GraphFactory;
import presentation.util.Exporter;

public class TargetPanel
extends JPanel {
    private static final long serialVersionUID = -4349282040075258598L;
    private OrchestratorFrame owner;
    private JLabel targetLabel = null;
    private JButton addTargetButton = null;
    private JButton deleteTargetButton = null;
    private JButton saveToImageButton1 = null;
    private JButton saveToDotButton1 = null;
    private JLabel statusLabel = null;
    private JScrollPane targetScrollPane = null;
    private boolean targetLoaded = false;
    private Service targetService;
    private JGraph targetGraph = null;

    public Service getTargetService() {
        return this.targetService;
    }

    public TargetPanel(OrchestratorFrame frame) {
        this.owner = frame;
        this.initialize();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints31 = new GridBagConstraints();
        gridBagConstraints31.fill = 1;
        gridBagConstraints31.gridy = 1;
        gridBagConstraints31.weightx = 10.0;
        gridBagConstraints31.weighty = 10.0;
        gridBagConstraints31.gridheight = 5;
        gridBagConstraints31.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints31.gridx = 1;
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 1;
        gridBagConstraints5.anchor = 17;
        gridBagConstraints5.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints5.fill = 2;
        gridBagConstraints5.gridy = 0;
        this.statusLabel = new JLabel();
        this.statusLabel.setText("No Target Service Loaded");
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints4.ipadx = 38;
        gridBagConstraints4.gridy = 4;
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints3.ipadx = 49;
        gridBagConstraints3.gridy = 3;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints2.ipadx = 0;
        gridBagConstraints2.gridy = 2;
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.ipadx = 24;
        gridBagConstraints1.gridy = 1;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.ipadx = 83;
        gridBagConstraints.gridy = 0;
        this.targetLabel = new JLabel();
        this.targetLabel.setText("Target Service");
        this.setSize(300, 200);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.targetLabel, gridBagConstraints);
        this.add((Component)this.getAddTargetButton(), gridBagConstraints1);
        this.add((Component)this.getDeleteTargetButton(), gridBagConstraints2);
        this.add((Component)this.getSaveToImageButton1(), gridBagConstraints3);
        this.add((Component)this.getSaveToDotButton1(), gridBagConstraints4);
        this.add((Component)this.statusLabel, gridBagConstraints5);
        this.add((Component)this.getTargetScrollPane(), gridBagConstraints31);
    }

    private JButton getAddTargetButton() {
        if (this.addTargetButton == null) {
            this.addTargetButton = new JButton();
            this.addTargetButton.setText("Add Target Service");
            this.addTargetButton.setToolTipText("Add a target service");
            this.addTargetButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    File file = TargetPanel.this.openFile();
                    if (file != null) {
                        ReadFile.setFileName(file.getAbsolutePath());
                        try {
                            String target = ReadFile.readFile();
                            TargetPanel.this.targetService = new Service(target);
                            boolean deterministic = TargetPanel.this.targetService.isDeterministic();
                            if (deterministic) {
                                TargetPanel.this.statusLabel.setText("New Target Service Loaded: " + file.getName());
                                TargetPanel.this.targetGraph = new GraphFactory(TargetPanel.this.targetService).getGraph();
                                TargetPanel.this.targetScrollPane.setViewportView(TargetPanel.this.targetGraph);
                                TargetPanel.this.targetLoaded = true;
                            } else {
                                TargetPanel.this.targetService = null;
                                JOptionPane.showMessageDialog(null, "Target Service must be deterministic", "Warning", 2);
                            }
                        }
                        catch (Exception e1) {
                            String error = e1.getMessage();
                            JOptionPane.showMessageDialog(null, error, "Error", 0);
                        }
                    }
                }
            });
        }
        return this.addTargetButton;
    }

    private JButton getDeleteTargetButton() {
        if (this.deleteTargetButton == null) {
            this.deleteTargetButton = new JButton();
            this.deleteTargetButton.setText("Remove Target Service");
            this.deleteTargetButton.setToolTipText("Remove the target service");
            this.deleteTargetButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TargetPanel.this.targetLoaded = false;
                    TargetPanel.this.statusLabel.setText("No Target Service Loaded");
                    TargetPanel.this.targetService = null;
                    TargetPanel.this.targetGraph = null;
                    TargetPanel.this.targetScrollPane.setViewportView(null);
                }
            });
        }
        return this.deleteTargetButton;
    }

    private JButton getSaveToImageButton1() {
        if (this.saveToImageButton1 == null) {
            this.saveToImageButton1 = new JButton();
            this.saveToImageButton1.setText("Save To Image");
            this.saveToImageButton1.setToolTipText("Save the graph in a jpeg file");
            this.saveToImageButton1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    File file;
                    if (TargetPanel.this.targetService != null && (file = TargetPanel.this.saveImageFile()) != null) {
                        Exporter.exportToImage(file, TargetPanel.this.targetGraph);
                    }
                }
            });
        }
        return this.saveToImageButton1;
    }

    private JButton getSaveToDotButton1() {
        if (this.saveToDotButton1 == null) {
            this.saveToDotButton1 = new JButton();
            this.saveToDotButton1.setText("Save To DOT File");
            this.saveToDotButton1.setToolTipText("Save the graph in DOT format");
            this.saveToDotButton1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    File file;
                    if (TargetPanel.this.targetService != null && (file = TargetPanel.this.saveDotFile()) != null) {
                        Exporter.exportToDot(file, TargetPanel.this.targetService);
                    }
                }
            });
        }
        return this.saveToDotButton1;
    }

    private JScrollPane getTargetScrollPane() {
        if (this.targetScrollPane == null) {
            this.targetScrollPane = new JScrollPane();
            this.targetScrollPane.setViewportView(null);
        }
        return this.targetScrollPane;
    }

    private File openFile() {
        JFileChooser fc = new JFileChooser();
        File dir = this.owner.getLastFolder();
        if (dir != null && dir.isDirectory()) {
            fc.setCurrentDirectory(dir);
        }
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Graph File", "txt");
        fc.setFileFilter(filter);
        fc.setMultiSelectionEnabled(false);
        fc.showOpenDialog(this.owner);
        this.owner.setLastFolder(fc.getCurrentDirectory());
        return fc.getSelectedFile();
    }

    private File saveImageFile() {
        JFileChooser fc = new JFileChooser();
        File dir = this.owner.getLastFolder();
        if (dir != null && dir.isDirectory()) {
            fc.setCurrentDirectory(dir);
        }
        FileNameExtensionFilter filter = new FileNameExtensionFilter("JPEG File", "jpeg");
        fc.setFileFilter(filter);
        fc.showSaveDialog(this);
        this.owner.setLastFolder(fc.getCurrentDirectory());
        return fc.getSelectedFile();
    }

    private File saveDotFile() {
        JFileChooser fc = new JFileChooser();
        File dir = this.owner.getLastFolder();
        if (dir != null && dir.isDirectory()) {
            fc.setCurrentDirectory(dir);
        }
        FileNameExtensionFilter filter = new FileNameExtensionFilter("DOT File", "dot");
        fc.setFileFilter(filter);
        fc.showSaveDialog(this);
        this.owner.setLastFolder(fc.getCurrentDirectory());
        return fc.getSelectedFile();
    }

    public boolean isTargetLoaded() {
        return this.targetLoaded;
    }

    public void setEnableButtons(boolean flag) {
        this.addTargetButton.setEnabled(flag);
        this.deleteTargetButton.setEnabled(flag);
    }
}

