/*
 * Decompiled with CFR 0.152.
 */
package presentation;

import control.Orchestrator;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.filechooser.FileNameExtensionFilter;
import presentation.OrchestratorFrame;
import presentation.util.Exporter;
import presentation.util.XmlTableOrchestratorFactory;

public class OrchestratorTablePanel
extends JPanel {
    private static final long serialVersionUID = -3051686144124963060L;
    private JButton showOrchestratorButton = null;
    private JButton saveToXmlButton = null;
    private JButton showSimulationButton = null;
    private JLabel orchestratorLabel = null;
    private JLabel statusLabel = null;
    private JScrollPane orchestratorScrollPane = null;
    private OrchestratorFrame owner = null;
    private XmlTableOrchestratorFactory fact;
    private int selected = 0;
    private static final int ORCHESTRATOR = 0;
    private static final int SIMULATION = 1;
    private JTable orchestratorTable = null;

    public OrchestratorTablePanel(OrchestratorFrame frame) {
        this.initialize();
        this.owner = frame;
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
        gridBagConstraints21.gridx = 0;
        gridBagConstraints21.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints21.ipadx = 62;
        gridBagConstraints21.gridy = 3;
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.fill = 1;
        gridBagConstraints5.gridy = 1;
        gridBagConstraints5.weightx = 10.0;
        gridBagConstraints5.weighty = 10.0;
        gridBagConstraints5.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints5.gridheight = 4;
        gridBagConstraints5.gridx = 1;
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.gridy = 0;
        this.statusLabel = new JLabel();
        this.statusLabel.setText("Orchestrator");
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.ipadx = 37;
        gridBagConstraints2.gridy = 2;
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.ipadx = 0;
        gridBagConstraints1.gridy = 0;
        this.orchestratorLabel = new JLabel();
        this.orchestratorLabel.setText("Orchestrator Generator");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.ipadx = 23;
        gridBagConstraints.gridy = 1;
        this.setSize(300, 200);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getShowOrchestratorButton(), gridBagConstraints);
        this.add((Component)this.orchestratorLabel, gridBagConstraints1);
        this.add((Component)this.getShowSimulationButton(), gridBagConstraints2);
        this.add((Component)this.statusLabel, gridBagConstraints3);
        this.add((Component)this.getOrchestratorScrollPane(), gridBagConstraints5);
        this.add((Component)this.getSaveToXmlButton(), gridBagConstraints21);
    }

    private JButton getShowOrchestratorButton() {
        if (this.showOrchestratorButton == null) {
            this.showOrchestratorButton = new JButton();
            this.showOrchestratorButton.setText("Show Orchestrator");
            this.showOrchestratorButton.setToolTipText("Show the orchestrator table");
            this.showOrchestratorButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OrchestratorTablePanel.this.selected = 0;
                    OrchestratorTablePanel.this.orchestratorTable.setModel(OrchestratorTablePanel.this.fact.getOrchestratorModel());
                    OrchestratorTablePanel.this.statusLabel.setText("Orchestrator");
                }
            });
        }
        return this.showOrchestratorButton;
    }

    private JButton getShowSimulationButton() {
        if (this.showSimulationButton == null) {
            this.showSimulationButton = new JButton();
            this.showSimulationButton.setText("Show Simulation");
            this.showSimulationButton.setToolTipText("Show the simulation table");
            this.showSimulationButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OrchestratorTablePanel.this.selected = 1;
                    OrchestratorTablePanel.this.orchestratorTable.setModel(OrchestratorTablePanel.this.fact.getSimulationModel());
                    OrchestratorTablePanel.this.statusLabel.setText("Simulation");
                }
            });
        }
        return this.showSimulationButton;
    }

    private JScrollPane getOrchestratorScrollPane() {
        if (this.orchestratorScrollPane == null) {
            this.orchestratorScrollPane = new JScrollPane();
            this.orchestratorScrollPane.setViewportView(this.getOrchestratorTable());
        }
        return this.orchestratorScrollPane;
    }

    private File saveXmlFile() {
        JFileChooser fc = new JFileChooser();
        File dir = this.owner.getLastFolder();
        if (dir != null && dir.isDirectory()) {
            fc.setCurrentDirectory(dir);
        }
        FileNameExtensionFilter filter = new FileNameExtensionFilter("XML File", "xml");
        fc.setFileFilter(filter);
        fc.showSaveDialog(this);
        this.owner.setLastFolder(fc.getCurrentDirectory());
        return fc.getSelectedFile();
    }

    private JButton getSaveToXmlButton() {
        if (this.saveToXmlButton == null) {
            this.saveToXmlButton = new JButton();
            this.saveToXmlButton.setText("Save To Xml");
            this.saveToXmlButton.setToolTipText("Save the selected table in a xml file");
            this.saveToXmlButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    File file = OrchestratorTablePanel.this.saveXmlFile();
                    if (file != null) {
                        String dir = file.getParent();
                        File xslFile = null;
                        String xml = null;
                        String xsl = null;
                        if (OrchestratorTablePanel.this.selected == 0) {
                            xml = OrchestratorTablePanel.this.fact.getXmlOrchestrator();
                            xslFile = new File(dir, "orch.xsl");
                            xsl = OrchestratorTablePanel.this.fact.getXslOrchestrator();
                        } else if (OrchestratorTablePanel.this.selected == 1) {
                            xml = OrchestratorTablePanel.this.fact.getXmlSimulation();
                            xslFile = new File(dir, "sim.xsl");
                            xsl = OrchestratorTablePanel.this.fact.getXslSimulation();
                        }
                        Exporter.exportToText(file, xml);
                        Exporter.exportToText(xslFile, xsl);
                    }
                }
            });
        }
        return this.saveToXmlButton;
    }

    public void init(Orchestrator orch) {
        this.fact = new XmlTableOrchestratorFactory(orch);
        this.selected = 0;
        this.orchestratorTable.setModel(this.fact.getOrchestratorModel());
    }

    private JTable getOrchestratorTable() {
        if (this.orchestratorTable == null) {
            this.orchestratorTable = new JTable();
            this.orchestratorTable.setAutoCreateRowSorter(true);
        }
        return this.orchestratorTable;
    }
}

