/*
 * Decompiled with CFR 0.152.
 */
package presentation;

import abstraction.Service;
import control.Orchestrator;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.jgraph.JGraph;
import presentation.ChoiceLayoutDialog;
import presentation.OrchestratorFrame;
import presentation.graph.GraphFactory;
import presentation.util.Exporter;

public class OrchestratorGraphPanel
extends JPanel {
    private static final long serialVersionUID = 971167226552503028L;
    private OrchestratorFrame owner = null;
    private JButton changeRepresentationButton = null;
    private JButton saveToImageButton = null;
    private JButton saveToDotButton = null;
    private JLabel orchestratorLabel = null;
    private JScrollPane orchestratorScrollPane = null;
    private JGraph orchestratorGraph = null;
    private Service orchestrator = null;

    public OrchestratorGraphPanel(OrchestratorFrame frame) {
        this.initialize();
        this.owner = frame;
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
        gridBagConstraints12.gridx = 0;
        gridBagConstraints12.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints12.ipadx = 14;
        gridBagConstraints12.gridy = 4;
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.fill = 1;
        gridBagConstraints5.gridy = 1;
        gridBagConstraints5.weightx = 10.0;
        gridBagConstraints5.weighty = 10.0;
        gridBagConstraints5.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints5.gridheight = 6;
        gridBagConstraints5.gridx = 1;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.ipadx = 38;
        gridBagConstraints2.gridy = 3;
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.ipadx = 43;
        gridBagConstraints1.gridy = 0;
        this.orchestratorLabel = new JLabel();
        this.orchestratorLabel.setText("Orchestrator");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.ipadx = 49;
        gridBagConstraints.gridy = 2;
        this.setSize(300, 200);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getSaveToImageButton(), gridBagConstraints);
        this.add((Component)this.orchestratorLabel, gridBagConstraints1);
        this.add((Component)this.getSaveToDotButton(), gridBagConstraints2);
        this.add((Component)this.getOrchestratorScrollPane(), gridBagConstraints5);
        this.add((Component)this.getChangeRepresentationButton(), gridBagConstraints12);
    }

    public void init(Orchestrator orch) {
        this.orchestratorGraph = null;
        this.orchestratorScrollPane.setViewportView(null);
        this.orchestrator = orch.createOrchestratorGenerator();
        if (this.orchestrator != null) {
            this.orchestratorGraph = new GraphFactory(this.orchestrator).getGraph();
        }
        this.orchestratorScrollPane.setViewportView(this.orchestratorGraph);
    }

    private JButton getSaveToImageButton() {
        if (this.saveToImageButton == null) {
            this.saveToImageButton = new JButton();
            this.saveToImageButton.setText("Save To Image");
            this.saveToImageButton.setToolTipText("Save the graph in a jpeg file");
            this.saveToImageButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    File file;
                    if (OrchestratorGraphPanel.this.orchestratorGraph != null && (file = OrchestratorGraphPanel.this.saveImageFile()) != null) {
                        Exporter.exportToImage(file, OrchestratorGraphPanel.this.orchestratorGraph);
                    }
                }
            });
        }
        return this.saveToImageButton;
    }

    private JButton getSaveToDotButton() {
        if (this.saveToDotButton == null) {
            this.saveToDotButton = new JButton();
            this.saveToDotButton.setText("Save To DOT File");
            this.saveToDotButton.setToolTipText("Save the graph in DOT format");
            this.saveToDotButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    File file;
                    if (OrchestratorGraphPanel.this.orchestrator != null && (file = OrchestratorGraphPanel.this.saveDotFile()) != null) {
                        Exporter.exportToDot(file, OrchestratorGraphPanel.this.orchestrator);
                    }
                }
            });
        }
        return this.saveToDotButton;
    }

    private JScrollPane getOrchestratorScrollPane() {
        if (this.orchestratorScrollPane == null) {
            this.orchestratorScrollPane = new JScrollPane();
            this.orchestratorScrollPane.setViewportView(null);
        }
        return this.orchestratorScrollPane;
    }

    private File saveImageFile() {
        JFileChooser fc = new JFileChooser();
        File dir = this.owner.getLastFolder();
        if (dir != null && dir.isDirectory()) {
            fc.setCurrentDirectory(dir);
        }
        FileNameExtensionFilter filter = new FileNameExtensionFilter("JPEG File", "jpeg");
        fc.setFileFilter(filter);
        fc.showSaveDialog(this);
        this.owner.setLastFolder(fc.getCurrentDirectory());
        return fc.getSelectedFile();
    }

    private File saveDotFile() {
        JFileChooser fc = new JFileChooser();
        File dir = this.owner.getLastFolder();
        if (dir != null && dir.isDirectory()) {
            fc.setCurrentDirectory(dir);
        }
        FileNameExtensionFilter filter = new FileNameExtensionFilter("DOT File", "dot");
        fc.setFileFilter(filter);
        fc.showSaveDialog(this);
        this.owner.setLastFolder(fc.getCurrentDirectory());
        return fc.getSelectedFile();
    }

    private JButton getChangeRepresentationButton() {
        if (this.changeRepresentationButton == null) {
            this.changeRepresentationButton = new JButton();
            this.changeRepresentationButton.setText("Change Visualization");
            this.changeRepresentationButton.setToolTipText("Change the layout of the graph");
            this.changeRepresentationButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ChoiceLayoutDialog dialog;
                    String layout;
                    if (OrchestratorGraphPanel.this.orchestratorGraph != null && (layout = (dialog = new ChoiceLayoutDialog(OrchestratorGraphPanel.this.owner)).getGraphLayout()) != null) {
                        GraphFactory.changeRepresentation(OrchestratorGraphPanel.this.orchestratorGraph, layout);
                    }
                }
            });
        }
        return this.changeRepresentationButton;
    }
}

