/*
 * Decompiled with CFR 0.152.
 */
package presentation;

import abstraction.CartesianProduct;
import abstraction.Service;
import control.Community;
import control.Orchestrator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import presentation.AvailablePanel;
import presentation.CartesianProductPanel;
import presentation.ExecuteOrchestratorPanel;
import presentation.OrchestratorGraphPanel;
import presentation.OrchestratorTablePanel;
import presentation.TargetPanel;

public class OrchestratorFrame
extends JFrame {
    private static final long serialVersionUID = -5592078694670051572L;
    private static final String ABOUT = "Opus\n\n Course in Computer Engineering\n             \"La Sapienza di Roma\"\n       Accedemic year 2008\\2009\n\nAuthors:\nBalestra Concetta\nCoccia Chiara\nColarullo Diego\nIachini Alberto\nQusa Hani\n\nService Integration\nProf. Giuseppe De Giacomo\n\n            15th May 2009\n ";
    private static final String HELP = "For more details see user manual or documentation.";
    private JPanel mainContentPane = null;
    private JTabbedPane mainTabbedPane = null;
    private AvailablePanel availablePanel = null;
    private TargetPanel targetPanel = null;
    private OrchestratorTablePanel orchestratorTablePanel = null;
    private CartesianProductPanel cartesianProductPanel = null;
    private ExecuteOrchestratorPanel executeOrchestratorPanel = null;
    private JMenuBar menubar = null;
    private JMenu fileMenu = null;
    private JMenuItem exitItem = null;
    private JMenu OrchestratorMenu = null;
    private JMenuItem startItem = null;
    private JMenuItem stopItem = null;
    private JMenu helpMenu = null;
    private JMenuItem helpItem = null;
    private JMenuItem aboutItem = null;
    private Orchestrator orchestrator = null;
    private File lastFolder;
    private JLabel warningLabel = null;
    private OrchestratorGraphPanel orchestratorGraphPanel = null;

    public OrchestratorFrame() {
        this.initialize();
    }

    private void initialize() {
        this.setSize(800, 500);
        this.setJMenuBar(this.getMenubar());
        this.setContentPane(this.getJContentPane());
        this.setTitle("Opus");
        this.setMaximumSize(new Dimension(300, 300));
        this.setVisible(true);
        this.setDefaultCloseOperation(3);
    }

    private JPanel getJContentPane() {
        if (this.mainContentPane == null) {
            BorderLayout borderLayout = new BorderLayout();
            borderLayout.setHgap(0);
            this.warningLabel = new JLabel();
            this.warningLabel.setText("    * if there is a node with a loop, could be action's names overlapped");
            this.mainContentPane = new JPanel();
            this.mainContentPane.setLayout(borderLayout);
            this.mainContentPane.add((Component)this.getMainTabbedPane(), "Center");
            this.mainContentPane.add((Component)this.warningLabel, "South");
        }
        return this.mainContentPane;
    }

    private JMenuBar getMenubar() {
        if (this.menubar == null) {
            this.menubar = new JMenuBar();
            this.menubar.add(this.getFileMenu());
            this.menubar.add(this.getOrchestratorMenu());
            this.menubar.add(this.getHelpMenu());
        }
        return this.menubar;
    }

    private JMenu getFileMenu() {
        if (this.fileMenu == null) {
            this.fileMenu = new JMenu();
            this.fileMenu.setText("File");
            this.fileMenu.add(this.getExitItem());
        }
        return this.fileMenu;
    }

    private JMenu getOrchestratorMenu() {
        if (this.OrchestratorMenu == null) {
            this.OrchestratorMenu = new JMenu();
            this.OrchestratorMenu.setText("Orchestrator");
            this.OrchestratorMenu.add(this.getStartItem());
            this.OrchestratorMenu.add(this.getStopItem());
        }
        return this.OrchestratorMenu;
    }

    private JMenu getHelpMenu() {
        if (this.helpMenu == null) {
            this.helpMenu = new JMenu();
            this.helpMenu.setText("Help");
            this.helpMenu.add(this.getHelpItem());
            this.helpMenu.add(this.getAboutItem());
        }
        return this.helpMenu;
    }

    private JMenuItem getExitItem() {
        if (this.exitItem == null) {
            this.exitItem = new JMenuItem();
            this.exitItem.setText("Exit");
            this.exitItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.exit(0);
                }
            });
        }
        return this.exitItem;
    }

    private JMenuItem getStartItem() {
        if (this.startItem == null) {
            this.startItem = new JMenuItem();
            this.startItem.setText("Start");
            this.startItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!OrchestratorFrame.this.targetPanel.isTargetLoaded()) {
                        JOptionPane.showMessageDialog(null, "No Targer Service Loaded", "Error", 0);
                    } else if (!OrchestratorFrame.this.availablePanel.isAvailableLoaded()) {
                        JOptionPane.showMessageDialog(null, "No Available Services Loaded", "Error", 0);
                    } else {
                        long time = System.currentTimeMillis();
                        Community com = new Community(OrchestratorFrame.this.availablePanel.getServices());
                        OrchestratorFrame.this.orchestrator = new Orchestrator(com, OrchestratorFrame.this.targetPanel.getTargetService());
                        boolean flag = OrchestratorFrame.this.orchestrator.generateOrchestrator();
                        time = System.currentTimeMillis() - time;
                        if (!flag) {
                            JOptionPane.showMessageDialog(null, "Impossible to create orchestrator because composition does not exists", "Warning", 2);
                            OrchestratorFrame.this.orchestrator = null;
                        } else {
                            OrchestratorFrame.this.mainTabbedPane.setEnabledAt(3, true);
                            OrchestratorFrame.this.mainTabbedPane.setEnabledAt(4, true);
                            OrchestratorFrame.this.mainTabbedPane.setEnabledAt(5, true);
                            if (!OrchestratorFrame.this.orchestrator.checkComposition()) {
                                JOptionPane.showMessageDialog(null, "Composition does not exist, orchestrator may be not run correctly", "Warning", 2);
                                OrchestratorFrame.this.mainTabbedPane.setEnabledAt(5, false);
                            }
                            OrchestratorFrame.this.startItem.setEnabled(false);
                            OrchestratorFrame.this.stopItem.setEnabled(true);
                            OrchestratorFrame.this.availablePanel.setEnableButtons(false);
                            OrchestratorFrame.this.targetPanel.setEnableButtons(false);
                            OrchestratorFrame.this.executeOrchestratorPanel.initExecuteOrchestratorPanel(OrchestratorFrame.this.targetPanel.getTargetService(), com, OrchestratorFrame.this.orchestrator);
                            OrchestratorFrame.this.orchestratorTablePanel.init(OrchestratorFrame.this.orchestrator);
                            OrchestratorFrame.this.orchestratorGraphPanel.init(OrchestratorFrame.this.orchestrator);
                        }
                        long ms = time % 1000L;
                        long sec = (time /= 1000L) % 60L;
                        long min = (time /= 60L) % 60L;
                        String mess = "Elapsed Time: " + (time /= 60L) + " hours, " + min + " minutes, " + sec + " seconds, " + ms + " milliseconds";
                        JOptionPane.showMessageDialog(null, mess, "Time", 1);
                    }
                }
            });
        }
        return this.startItem;
    }

    private JMenuItem getHelpItem() {
        if (this.helpItem == null) {
            this.helpItem = new JMenuItem();
            this.helpItem.setText("Help");
            this.helpItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OrchestratorFrame.this.showHelp();
                }
            });
        }
        return this.helpItem;
    }

    private JMenuItem getAboutItem() {
        if (this.aboutItem == null) {
            this.aboutItem = new JMenuItem();
            this.aboutItem.setText("About");
            this.aboutItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OrchestratorFrame.this.showAbout();
                }
            });
        }
        return this.aboutItem;
    }

    private void showAbout() {
        JOptionPane.showMessageDialog(this, ABOUT, "About", 1);
    }

    private void showHelp() {
        JOptionPane.showMessageDialog(this, HELP, "Help", 1);
    }

    private JTabbedPane getMainTabbedPane() {
        if (this.mainTabbedPane == null) {
            this.mainTabbedPane = new JTabbedPane();
            this.mainTabbedPane.addTab("Available Services", null, this.getAvailablePanel(), null);
            this.mainTabbedPane.addTab("Target Service", null, this.getTargetPanel(), null);
            this.mainTabbedPane.addTab("Cartesian Product", null, this.getCartesianProductPanel(), null);
            this.mainTabbedPane.addTab("Orchestrator Table", null, this.getOrchestratorPanel(), null);
            this.mainTabbedPane.addTab("Orchestrator Generator", null, this.getOrchestratorGraphPanel(), null);
            this.mainTabbedPane.addTab("Execute Orchestrator", null, this.getExecuteOrchestratorPanel(), null);
            this.mainTabbedPane.setEnabledAt(3, false);
            this.mainTabbedPane.setEnabledAt(4, false);
            this.mainTabbedPane.setEnabledAt(5, false);
        }
        return this.mainTabbedPane;
    }

    private AvailablePanel getAvailablePanel() {
        if (this.availablePanel == null) {
            this.availablePanel = new AvailablePanel(this);
        }
        return this.availablePanel;
    }

    private TargetPanel getTargetPanel() {
        if (this.targetPanel == null) {
            this.targetPanel = new TargetPanel(this);
        }
        return this.targetPanel;
    }

    private OrchestratorTablePanel getOrchestratorPanel() {
        if (this.orchestratorTablePanel == null) {
            this.orchestratorTablePanel = new OrchestratorTablePanel(this);
        }
        return this.orchestratorTablePanel;
    }

    private CartesianProductPanel getCartesianProductPanel() {
        if (this.cartesianProductPanel == null) {
            this.cartesianProductPanel = new CartesianProductPanel(this);
        }
        return this.cartesianProductPanel;
    }

    public Service getProduct() {
        return CartesianProduct.executeProduct(this.availablePanel.getServices());
    }

    private JMenuItem getStopItem() {
        if (this.stopItem == null) {
            this.stopItem = new JMenuItem();
            this.stopItem.setEnabled(false);
            this.stopItem.setText("Stop");
            this.stopItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OrchestratorFrame.this.stopItem.setEnabled(false);
                    OrchestratorFrame.this.startItem.setEnabled(true);
                    OrchestratorFrame.this.availablePanel.setEnableButtons(true);
                    OrchestratorFrame.this.targetPanel.setEnableButtons(true);
                    OrchestratorFrame.this.mainTabbedPane.setEnabledAt(3, false);
                    OrchestratorFrame.this.mainTabbedPane.setEnabledAt(4, false);
                    OrchestratorFrame.this.mainTabbedPane.setEnabledAt(5, false);
                    int selected = OrchestratorFrame.this.mainTabbedPane.getSelectedIndex();
                    if (selected == 3 || selected == 4 || selected == 5) {
                        OrchestratorFrame.this.mainTabbedPane.setSelectedIndex(1);
                    }
                }
            });
        }
        return this.stopItem;
    }

    private ExecuteOrchestratorPanel getExecuteOrchestratorPanel() {
        if (this.executeOrchestratorPanel == null) {
            this.executeOrchestratorPanel = new ExecuteOrchestratorPanel(this);
        }
        return this.executeOrchestratorPanel;
    }

    public boolean isAvailableLoaded() {
        return this.availablePanel.isAvailableLoaded();
    }

    public File getLastFolder() {
        return this.lastFolder;
    }

    public void setLastFolder(File folder) {
        if (folder != null) {
            this.lastFolder = folder;
        }
    }

    private OrchestratorGraphPanel getOrchestratorGraphPanel() {
        if (this.orchestratorGraphPanel == null) {
            this.orchestratorGraphPanel = new OrchestratorGraphPanel(this);
        }
        return this.orchestratorGraphPanel;
    }
}

