/*
 * Decompiled with CFR 0.152.
 */
package presentation;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import presentation.graph.GraphFactory;

public class ChoiceLayoutDialog
extends JDialog {
    private static final long serialVersionUID = 1537787927972838799L;
    private String layout = null;
    private JPanel choiceLayoutContentPane = null;
    private JLabel choiceLayoutLabel = null;
    private JComboBox choiceLayoutComboBox = null;
    private JButton okButton = null;
    private JButton cancelButton = null;

    public ChoiceLayoutDialog(Frame owner) {
        super(owner);
        this.initialize();
    }

    private void initialize() {
        this.setSize(300, 200);
        this.setContentPane(this.getChoiceLayoutContentPane());
        this.setResizable(false);
        this.setModal(true);
        this.setTitle("Choice Graph Layout");
        this.setVisible(true);
    }

    private JPanel getChoiceLayoutContentPane() {
        if (this.choiceLayoutContentPane == null) {
            this.choiceLayoutLabel = new JLabel();
            this.choiceLayoutLabel.setBounds(new Rectangle(45, 15, 196, 16));
            this.choiceLayoutLabel.setText("Layout: ");
            this.choiceLayoutContentPane = new JPanel();
            this.choiceLayoutContentPane.setLayout(null);
            this.choiceLayoutContentPane.add((Component)this.choiceLayoutLabel, null);
            this.choiceLayoutContentPane.add((Component)this.getChoiceLayoutComboBox(), null);
            this.choiceLayoutContentPane.add((Component)this.getOkButton(), null);
            this.choiceLayoutContentPane.add((Component)this.getCancelButton(), null);
        }
        return this.choiceLayoutContentPane;
    }

    private JComboBox getChoiceLayoutComboBox() {
        if (this.choiceLayoutComboBox == null) {
            this.choiceLayoutComboBox = new JComboBox<String>(GraphFactory.layouts);
            this.choiceLayoutComboBox.setBounds(new Rectangle(45, 60, 196, 31));
            this.choiceLayoutComboBox.setToolTipText("Choose a layout for the graph");
        }
        return this.choiceLayoutComboBox;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setBounds(new Rectangle(45, 120, 76, 31));
            this.okButton.setText("Ok");
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ChoiceLayoutDialog.this.layout = (String)ChoiceLayoutDialog.this.choiceLayoutComboBox.getSelectedItem();
                    ChoiceLayoutDialog.this.closeDialog();
                }
            });
        }
        return this.okButton;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setBounds(new Rectangle(165, 120, 76, 31));
            this.cancelButton.setText("Cancel");
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ChoiceLayoutDialog.this.layout = null;
                    ChoiceLayoutDialog.this.closeDialog();
                }
            });
        }
        return this.cancelButton;
    }

    private void closeDialog() {
        this.setVisible(false);
    }

    public String getGraphLayout() {
        return this.layout;
    }
}

